/* ------------------------------------------------------------------------- */
/* sci.c : SCI Driver - LIN_Init_UL                                          */
/* ------------------------------------------------------------------------- */                                                                           



#include "lin.h"
//#include "system.h"


/* ------------------------------------------------------------------------- */
/* HCLK_uL                                                                   */
/*      Definition of the HCLK is via a global variable which                */
/*      is suppied by the application (Hz)                                   */
/*                                                                           */

extern unsigned int HCLK_uL;


/* ------------------------------------------------------------------------- */
/* LIN_Init                                                                  */
/*      Initialise the SCI control registers.                                */
/*                                                                           */
/*      IN: port         - SCI port number                                   */
/*          LIN_GCR1_uL  - Initialize register GCR1                          */
/*                                                                           */
/*          LIN_INT0_ul  - Initialize register INT0                          */
/*                                                                           */
/*          CharSize     - number of bits in on character                    */
/*                                                                           */
/*          BaudRate     - desired baud rate in Hz                           */
/*                                                                           */
/* ------------------------------------------------------------------------- */

void LIN_Reset(LIN_ST *ptr)
{
    ptr->SCIGR0_UN.SCIGR0_ST.RESET_B1 = 0;  //reset SCI
    ptr->SCIGR0_UN.SCIGR0_ST.RESET_B1 = 1;  //release from reset
}    


unsigned int LIN_Init(	LIN_ST *ptr,
						unsigned int SCIGR1_uL,
						unsigned int SCISETINT_uL, 
						unsigned int FrameSize,   //frame size for the LIN mode
						unsigned int CharSize,
						unsigned int BaudRate)
{

    unsigned int  baud;
    unsigned int vclk;
    unsigned int brr;
//	unsigned int vclk_ratio = e_SYSTEM_ST.CLKCNTL_UN.CLKCNTL_ST.VCLKR_B4;
    unsigned int vclk_ratio = 1;
    ptr->SCIGR0_UN.SCIGR0_ST.RESET_B1 = 0;  //reset SCI
    ptr->SCIGR0_UN.SCIGR0_ST.RESET_B1 = 1;  //release from reset

    /* set the SCI baud rate */
	if(SCIGR1_uL & LIN_LINMode) ptr->SCIGR1_UN.SCIGR1_ST.LINMODE_B1 = 1;
		
	ptr->SCIGR1_UN.SCIGR1_UL = SCIGR1_uL;  //setup SCIGR1
	        
//	if(vclk_ratio == 0x0)
//		vclk = HCLK_uL / 2;
//	else
		vclk = HCLK_uL / (vclk_ratio + 1);

    /* vclk here is in Hz */

    if (ptr->SCIGR1_UN.SCIGR1_ST.TIMING_MODE_B1 == 1 | ptr->SCIGR1_UN.SCIGR1_ST.LINMODE_B1 == 1)
    {
        brr  = (vclk / (16*BaudRate)) - 1;
        if(brr ==0) brr = 1;
        baud = vclk / (16*(brr+1)); 
    }
    else
    {
        brr  = (vclk / BaudRate) - 1;
        if(brr == 0) brr = 1;
        baud = vclk / (brr+1); 
    }
    ptr->SCIBRSR_UN.SCIBRSR_UL = brr;        
    
    /* set the SCI character size */
    
    ptr->SCIFORMAT_UN.SCIFORMAT_ST.CHAR_B3 = CharSize - 1;
	if(FrameSize > 0) ptr->SCIFORMAT_UN.SCIFORMAT_ST.LENGTH_B3 = FrameSize - 1;
  
    ptr->SCIPIO0_UN.SCIPIO0_UL= 7;  //TX and RX pins are SCI pins
//	ptr->SCIPIO7_UN.SCIPIO7_UL= 7;  //disable pull control

	ptr->SCISETINT_UN.SCISETINT_UL = SCISETINT_uL; //setup SCIIT0
	
	ptr->MBRSR_UN.MBRSR_UL = vclk / 20000;
    
    ptr->SCIGR1_UN.SCIGR1_ST.SWnRST_B1 = 0x1; //exit from S/W reset
    while(ptr->SCIFLR_UN.SCIFLR_ST.IDLE_B1 == 1);

    return baud;
}

void LIN_Setup(	LIN_ST *ptr,
						unsigned char RxMask,
						unsigned char TxMask, 
						unsigned char LINID)
{
	/* place LIN into software reset mode before we change things */
	ptr->SCIGR1_UN.SCIGR1_ST.SWnRST_B1 = 0;
	
    ptr->LINMASK_UN.LINMASK_ST.RXIDMASK_UC = RxMask;
	ptr->LINMASK_UN.LINMASK_ST.TXIDMASK_UC = TxMask;
	if(ptr->SCIGR1_UN.SCIGR1_ST.CLOCK_B1 == 0)
	{
		ptr->LINID_UN.LINID_ST.IDBYTE_UC = LINID;
	}

	/* place LIN out of software reset mode */
	ptr->SCIGR1_UN.SCIGR1_ST.SWnRST_B1 = 1;
}		
