#include <ti/devices/msp432p4xx/driverlib/driverlib.h>
#include "main_HAL.h"
#include "myGPIO.h"
#include "myTimer32.h"
#include "myTimerA.h"
#include "myJoystick.h"
unsigned int i=0;
/* Application Defines */
#define TIMER_PERIOD 2000
#define DUTY_CYCLE1 28//LED
#define DUTY_CYCLE2 TIMER_PERIOD/28000//Buzzer
static uint16_t resultsBuffer[2];
char X_flag = 0,y_flag=0;
unsigned int x_numb=0,y_numb=0;
void led_bezzer_dealwith(void);
/* Timer_A UpDown Configuration Parameter */
 Timer_A_UpDownModeConfig upDownConfig =
{
        TIMER_A_CLOCKSOURCE_SMCLK,              // SMCLK Clock SOurce
        TIMER_A_CLOCKSOURCE_DIVIDER_1,          // SMCLK/1 = 3MHz
        TIMER_PERIOD,                           // 127 tick period
        TIMER_A_TAIE_INTERRUPT_DISABLE,         // Disable Timer interrupt
        TIMER_A_CCIE_CCR0_INTERRUPT_DISABLE,    // Disable CCR0 interrupt
        TIMER_A_DO_CLEAR                        // Clear value
};

/* Timer_A Compare Configuration Parameter  (PWM1) */
 Timer_A_CompareModeConfig compareConfig_PWM1 =
{
        TIMER_A_CAPTURECOMPARE_REGISTER_3,          // Use CCR1
        TIMER_A_CAPTURECOMPARE_INTERRUPT_DISABLE,   // Disable CCR interrupt
        TIMER_A_OUTPUTMODE_TOGGLE_SET,              // Toggle output but
        DUTY_CYCLE1                          // 32 Duty Cycle
};

/* Timer_A Compare Configuration Parameter (PWM2) */
Timer_A_CompareModeConfig compareConfig_PWM2 =
{
        TIMER_A_CAPTURECOMPARE_REGISTER_4,          // Use CCR2
        TIMER_A_CAPTURECOMPARE_INTERRUPT_DISABLE,   // Disable CCR interrupt
        TIMER_A_OUTPUTMODE_TOGGLE_SET,              // Toggle output but
        DUTY_CYCLE2                                 // 96 Duty Cycle
};
int main(void)
{
    initBoard();
    // TODO: Declare the variables to represent button histories for Boosterpack Buttons 1 and 2.
    //       You did this in Homework 3.

    // TODO: Declare the variables that main uses to interact with your button state machines.
    //       You did this in Homework 3.

    // TODO: Declare a variable for the main system state.

    // TODO: Declare variables to hold the values for the x and y values.

    // TODO: Declare a variable to hold the note period.

    // Stops the Watchdog timer.


    // TODO: Configure TA0 in Up Mode.
    //       Write this function in myTimerA.c.

    // TODO: Configure the Piezo Buzzer as a PWM output.
    //       Write this function in myTimerA.c.

    // TODO: Configure the Red Boosterpack LED as a PWM output.
    //       Write this function in myTimerA.c.

    // TODO: Initialize the ADC.
    //       Initialize the joystick pins to interface with the ADC.
    //       Start the ADC.
    //       Write these functions in myJoystick.c.

    // TODO: Configure Timer32_0 to have a 1 millisecond period.
    //       You did this in Homework 3.

    // TODO: Start TimerA_0 in UP mode.
    //       Write this function in myTimerA.c
//----------------------------------------------------------

   /* Configuring ADC Memory (ADC_MEM0 - ADC_MEM1 (A0 - A2)  with no repeat)
    * with internal 2.5v reference */
    ADC14_configureMultiSequenceMode(ADC_MEM0, ADC_MEM1, true);
   // ADC14_configureSingleSampleMode ( ADC_MEM0, ADC_MEM1, bool repeatMode );
    ADC14_configureConversionMemory(ADC_MEM0,ADC_VREFPOS_AVCC_VREFNEG_VSS,ADC_INPUT_A15, ADC_NONDIFFERENTIAL_INPUTS);
    ADC14_configureConversionMemory(ADC_MEM1,ADC_VREFPOS_AVCC_VREFNEG_VSS,ADC_INPUT_A9, ADC_NONDIFFERENTIAL_INPUTS);
    /* Setting up the sample timer to automatically step through the sequence
     * convert.*/
    ADC14_enableSampleTimer(ADC_AUTOMATIC_ITERATION);

  //
    /* Initializing ADC (MCLK/1/1) */
     ADC14_enableModule();
     ADC14_initModule(ADC_CLOCKSOURCE_MCLK, ADC_PREDIVIDER_1, ADC_DIVIDER_1,0);
    /* Enabling the interrupt when a conversion on channel 1 (end of sequence)
     *  is complete and enabling conversions */
    ADC14_enableInterrupt(ADC_INT1);
    /* Enabling Interrupts */
    Interrupt_enableInterrupt(INT_ADC14);

//    /* Triggering the start of the sample */
    ADC14_enableConversion();

   // ADC14_setSampleHoldTriggerMultipleInstance(a,b);
    // TODO: Initialize the GPIO.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
       /* Setting P7.7 and P7.6 and peripheral outputs for CCR */
        MAP_GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_P2,
        GPIO_PIN6 + GPIO_PIN7, GPIO_PRIMARY_MODULE_FUNCTION);

       /* Configuring Timer_A1 for UpDown Mode and starting */
       MAP_Timer_A_configureUpDownMode(TIMER_A0_BASE, &upDownConfig);
       MAP_Timer_A_startCounter(TIMER_A0_BASE, TIMER_A_UPDOWN_MODE);

      /* Initialize compare registers to generate PWM1 */
       MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM1);

       /* Initialize compare registers to generate PWM2 */
       MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM2);
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    /* Configuring P1.1 as an input and enabling interrupts */
    MAP_GPIO_setAsInputPinWithPullUpResistor(GPIO_PORT_P3, GPIO_PIN5);
    MAP_GPIO_setAsInputPinWithPullUpResistor(GPIO_PORT_P5, GPIO_PIN1);
    // To set P6.0 AND P4.4 to work as an analog input, we use:
    GPIO_setAsPeripheralModuleFunctionInputPin(GPIO_PORT_P6,GPIO_PIN0,GPIO_PRIMARY_MODULE_FUNCTION);
    GPIO_setAsPeripheralModuleFunctionInputPin(GPIO_PORT_P4,GPIO_PIN4,GPIO_PRIMARY_MODULE_FUNCTION);
    GPIO_clearInterruptFlag(GPIO_PORT_P3, GPIO_PIN5);
    GPIO_clearInterruptFlag(GPIO_PORT_P5, GPIO_PIN1);
    GPIO_enableInterrupt(GPIO_PORT_P3, GPIO_PIN5);
    GPIO_enableInterrupt(GPIO_PORT_P5, GPIO_PIN1);
    Interrupt_enableInterrupt(INT_PORT3);
    Interrupt_enableInterrupt(INT_PORT5);

    /* Enabling MASTER interrupts */

      Interrupt_setPriority(INT_TA0_0 ,0x77);
      Interrupt_setPriority(INT_PORT3,0x00);
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

     // ADC14_setSampleHoldTrigger(ADC_TRIGGER_SOURCE6, false);//false
      // ADC14_toggleConversionTrigger();
      Interrupt_enableMaster();

    while(1)
    {
//          if(GPIO_getInputPinValue(GPIO_PORT_P5,GPIO_PIN1)==GPIO_INPUT_PIN_LOW)
//              {
//              compareConfig_PWM1.compareValue=28;
//              compareConfig_PWM2.compareValue=TIMER_PERIOD*10;
//              MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM1);
//              MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM2);
//              }
//          if(GPIO_getInputPinValue(GPIO_PORT_P3,GPIO_PIN5)==GPIO_INPUT_PIN_LOW)
//              {
//              compareConfig_PWM1.compareValue=TIMER_PERIOD;
//              compareConfig_PWM2.compareValue=28;
//              MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM1);
//              MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM2);
//              }
        // If Timer0 has expired, update the Boosterpack pushbutton histories.

        // Call the button FSMs and determine whether either button was pressed.

        // Change the main system state based on which button was pressed.

        // Get the joystick values

        // Use the system state and the joystick values to change the values of TA0CCR0, TA0CCR3, and TA0CCR4.

    }
}
//..........................................................................
void led_bezzer_dealwith()
{
   // X_numb
    //.........y axle deal with..................................

              y_numb=TIMER_PERIOD* abs(resultsBuffer[1]-2500)/(16280);
              y_numb=TIMER_PERIOD-y_numb;
              compareConfig_PWM2.compareValue= y_numb*0.005;

              x_numb=TIMER_PERIOD* abs(resultsBuffer[0]-2500)/(16280-3500);
              x_numb=TIMER_PERIOD-x_numb;
              if(x_numb>1800) {x_numb=1900;compareConfig_PWM1.compareValue= x_numb ; }//led
              else
             compareConfig_PWM1.compareValue= x_numb*0.7;//LED
  // uppwm value
    MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM1);
    MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM2);
}
/* This interrupt is fired whenever a conversion is completed and placed in
 * ADC_MEM7. This signals the end of conversion and the results array is
 * grabbed and placed in resultsBuffer */
void ADC14_IRQHandler(void)
{
    uint64_t status;

    status = MAP_ADC14_getEnabledInterruptStatus();
    MAP_ADC14_clearInterruptFlag(status);

    if(status & ADC_INT1)
    {
        MAP_ADC14_getMultiSequenceResult(resultsBuffer);
    }
    led_bezzer_dealwith();
}
/* GPIO ISR */
void PORT3_IRQHandler(void)
{
    uint32_t status;

    status = GPIO_getEnabledInterruptStatus(GPIO_PORT_P3);
    GPIO_clearInterruptFlag(GPIO_PORT_P3, status);
    compareConfig_PWM1.compareValue=TIMER_PERIOD;
    compareConfig_PWM2.compareValue=28;
    Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM1);
    Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM2);

}
/* GPIO ISR */
void PORT5_IRQHandler(void)
{
    uint32_t status;

    status = MAP_GPIO_getEnabledInterruptStatus(GPIO_PORT_P5);
    MAP_GPIO_clearInterruptFlag(GPIO_PORT_P5, status);
    compareConfig_PWM1.compareValue=28;
    compareConfig_PWM2.compareValue=TIMER_PERIOD*10;
    MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM1);
    MAP_Timer_A_initCompare(TIMER_A0_BASE, &compareConfig_PWM2);

}
