/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
#include "system.h"
#include "gio.h"
#include "het.h"
#include "mibspi.h"
#include "sys_vim.h"
#include "pinmux.h"
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "sys_core.h"  /* 包含中断使能函数声明 */

#define TG0 0
#define TG1 1
#define TG2 2
#define TG3 3
#define TG4 4
#define TG5 5
#define TG6 6
#define TG7 7

/* 传输数据准备 - 修正：使用uint16类型 */
uint16 TG0_TX_Data_Master[8] = {0x1111, 0x2222, 0x3333, 0x4444, 0x5555, 0x6666, 0x7777, 0x8888};
uint16 TG1_TX_Data_Master[8] = {0x1112, 0x2223, 0x3334, 0x4445, 0x5556, 0x6667, 0x7778, 0x8889};
uint16 TG2_TX_Data_Master[8] = {0x1113, 0x2224, 0x3335, 0x4446, 0x5557, 0x6668, 0x7779, 0x8880};
uint16 TG3_TX_Data_Master[8] = {0x1114, 0x2225, 0x3336, 0x4447, 0x5558, 0x6669, 0x7770, 0x8881};

/* 从机发送数据准备 - 使用uint16类型 */
uint16 TG0_TX_Data_Slave[8] = {0xAAAA, 0xBBBB, 0xCCCC, 0xDDDD, 0xEEEE, 0xFFFF, 0x0000, 0x1234};
uint16 TG1_TX_Data_Slave[8] = {0xAABB, 0xBBCC, 0xCCDD, 0xDDEE, 0xEEFF, 0xFF00, 0x0011, 0x1235};
uint16 TG2_TX_Data_Slave[8] = {0xAACC, 0xBBDD, 0xCCEE, 0xDDFF, 0xEE00, 0xFF11, 0x0022, 0x1236};
uint16 TG3_TX_Data_Slave[8] = {0xAADD, 0xBBEE, 0xCCFF, 0xDD00, 0xEE11, 0xFF22, 0x0033, 0x1237};

/* 接收数据缓冲区 */
uint16 TG0_RX_Data_Master[8] = {0};
uint16 TG1_RX_Data_Master[8] = {0};
uint16 TG2_RX_Data_Master[8] = {0};
uint16 TG3_RX_Data_Master[8] = {0};

/* 传输完成标志 - 初始化为0 */
static volatile uint32 TG3_IS_Complete = 0;
/* 传输错误标志 */
volatile uint32 transfer_error = 0;
/* 传输成功计数 */
volatile uint32 transfer_success_count = 0;

void verify_transfer_data(void);

/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    uint32 i = 0;

    /* 系统初始化 */
    systemInit();
    muxInit();
    vimInit();
    gioInit();
    hetInit();
    mibspiInit();


    /* 使能全局中断 */
    _enable_IRQ();

    /* 配置MibSPI传输组 */
    /* 注意：如果要使用数字回环测试，取消下面的注释 */
    //mibspiEnableLoopback(mibspiREG1, Digital_Lbk);

    /* LED指示 - 设置HET1[0]为输出 */
    gioSetDirection(hetPORT1, 0x01);


    mibspiSetData(mibspiREG1, TG0, TG0_TX_Data_Master);
    mibspiSetData(mibspiREG1, TG1, TG1_TX_Data_Master);
    mibspiSetData(mibspiREG1, TG2, TG2_TX_Data_Master);
    mibspiSetData(mibspiREG1, TG3, TG3_TX_Data_Master);


    mibspiEnableGroupNotification(mibspiREG1, TG0, 1);
    mibspiEnableGroupNotification(mibspiREG1, TG1, 1);
    mibspiEnableGroupNotification(mibspiREG1, TG2, 1);
    mibspiEnableGroupNotification(mibspiREG1, TG3, 1);

    //mibspiTransfer(mibspiREG1, TG0);

    /* 延时，等待从机完成初始化（如果有从机） */
    //for(i = 0; i < 20000000; i++);  /* 延时约2秒 */

    /* LED闪烁3次表示主机准备就绪 */
    //for(j = 0; j < 3; j++)
    //{
       // gioSetBit(hetPORT1, 0x00, 1);
       // for(i = 0; i < 1000000; i++);
       // gioSetBit(hetPORT1, 0x00, 0);
       // for(i = 0; i < 1000000; i++);
    //}

    /* ✅ 主循环：重复传输 */
    while(1)
    {
        /* LED亮起，表示准备传输 */
        gioSetBit(hetPORT1, 0x00, 1);

        /* 延时稳定 */
       for(i = 0; i < 10000000; i++);

        /* 重置完成标志 */
        TG3_IS_Complete = 0;

        /* ✅ 每次循环都重新设置要发送的数据 */
       // mibspiSetData(mibspiREG1, TG0, TG0_TX_Data_Master);
       // mibspiSetData(mibspiREG1, TG1, TG1_TX_Data_Master);
       // mibspiSetData(mibspiREG1, TG2, TG2_TX_Data_Master);
       // mibspiSetData(mibspiREG1, TG3, TG3_TX_Data_Master);

        /* 启动传输 - 依次传输TG0-TG3 */
        mibspiTransfer(mibspiREG1, TG0);
        while (TG3_IS_Complete != 0xA5A5A5A5);
        //while(!mibspiIsTransferComplete(mibspiREG1, TG0));

        //mibspiTransfer(mibspiREG1, TG1);
        //while(!mibspiIsTransferComplete(mibspiREG1, TG1));

       // mibspiTransfer(mibspiREG1, TG2);
       // while(!mibspiIsTransferComplete(mibspiREG1, TG2));

        //mibspiTransfer(mibspiREG1, TG3);
       // while(!mibspiIsTransferComplete(mibspiREG1, TG3));

        /* 读取接收数据 */
        mibspiGetData(mibspiREG1, TG0, TG0_RX_Data_Master);
        mibspiGetData(mibspiREG1, TG1, TG1_RX_Data_Master);
        mibspiGetData(mibspiREG1, TG2, TG2_RX_Data_Master);
        mibspiGetData(mibspiREG1, TG3, TG3_RX_Data_Master);

        /* 验证数据 */
        verify_transfer_data();


        mibspiSetData(mibspiREG1, TG0, TG0_TX_Data_Master);
        mibspiSetData(mibspiREG1, TG1, TG1_TX_Data_Master);
        mibspiSetData(mibspiREG1, TG2, TG2_TX_Data_Master);
        mibspiSetData(mibspiREG1, TG3, TG3_TX_Data_Master);


        /* LED熄灭 */
        //gioSetBit(hetPORT1, 0x00, 0);

        /* 延时后进行下次传输 */
        for(i = 0; i < 5000000; i++);
    }

    /* 可以在这里添加数据验证代码 */

/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
/* MibSPI传输组完成中断回调函数 */
void mibspiGroupNotification(mibspiBASE_t *mibspi, uint32 group)
{
    switch (group)
    {
        case 0:
            /* TG0完成，触发TG1 */
            mibspiTransfer(mibspiREG1, TG1);
            break;

        case 1:
            /* TG1完成，触发TG2 */
            mibspiTransfer(mibspiREG1, TG2);
            break;

        case 2:
            /* TG2完成，触发TG3 */
            mibspiTransfer(mibspiREG1, TG3);
            break;

        case 3:
            /* TG3完成，设置完成标志 */
            TG3_IS_Complete = 0xA5A5A5A5;
            break;

        default:
            /* 异常情况处理 */
            while(1);
            break;
    }
}

/*=============================================================================
 * 函数名称: verify_transfer_data
 * 功能描述: 验证接收数据是否与发送数据一致
 * 参数说明: 无
 * 返回值:   无
 *
 * 说明:
 *   验证主机接收到的数据是否与从机发送的数据一致
 *   本函数用于验证传输的正确性
 *============================================================================*/
void verify_transfer_data(void)
{
    uint32 i;
    uint32 j;
    uint32 error_count = 0;

    /* 验证 TG0 数据 */
    for(i = 0; i < 8; i++)
    {
        if(TG0_RX_Data_Master[i] != TG0_TX_Data_Slave[i])
        {
            error_count++;
        }
    }

    /* 验证 TG1 数据 */
    for(i = 0; i < 8; i++)
    {
        if(TG1_RX_Data_Master[i] != TG1_TX_Data_Slave[i])
        {
            error_count++;
        }
    }

    /* 验证 TG2 数据 */
    for(i = 0; i < 8; i++)
    {
        if(TG2_RX_Data_Master[i] != TG2_TX_Data_Slave[i])
        {
            error_count++;
        }
    }

    /* 验证 TG3 数据 */
    for(i = 0; i < 8; i++)
    {
        if(TG3_RX_Data_Master[i] != TG3_TX_Data_Slave[i])
        {
            error_count++;
        }
    }

    /* 设置验证结果标志 */
    if(error_count == 0)
    {
        /* 数据验证成功 */
        transfer_success_count++;

        /* LED快闪表示成功 */
        for(j = 0; j < 10; j++)
        {
            gioSetBit(hetPORT1, 0x00, 0);  /* 熄灭LED */
            for(i = 0; i < 300000; i++);
            gioSetBit(hetPORT1, 0x00, 1);  /* 点亮LED */
            for(i = 0; i < 300000; i++);
        }
    }
    else
    {
        /* 数据验证失败 */
        gioSetBit(hetPORT1, 0x00, 0);  /* 熄灭LED */
        transfer_error = error_count;  /* 记录错误数量 */
        //while(1);  /* 停止，便于调试 */
    }
}

/* USER CODE END */
