/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "sys_core.h"  /* жʹܺ */
#include "system.h"
#include "gio.h"
#include "het.h"
#include "mibspi.h"
#include "sys_vim.h"
#include "pinmux.h"

#define TG0 0
#define TG1 1
#define TG2 2
#define TG3 3
#define TG4 4
#define TG5 5
#define TG6 6
#define TG7 7

/* ӻ׼ - ʹuint16 */
uint16 TG0_TX_Data_Slave[8] = {0xAAAA, 0xBBBB, 0xCCCC, 0xDDDD, 0xEEEE, 0xFFFF, 0x0000, 0x1234};
uint16 TG1_TX_Data_Slave[8] = {0xAABB, 0xBBCC, 0xCCDD, 0xDDEE, 0xEEFF, 0xFF00, 0x0011, 0x1235};
uint16 TG2_TX_Data_Slave[8] = {0xAACC, 0xBBDD, 0xCCEE, 0xDDFF, 0xEE00, 0xFF11, 0x0022, 0x1236};
uint16 TG3_TX_Data_Slave[8] = {0xAADD, 0xBBEE, 0xCCFF, 0xDD00, 0xEE11, 0xFF22, 0x0033, 0x1237};

/* Ԥڷ͵ - ֤ */
uint16 TG0_TX_Data_Master[8] = {0x1111, 0x2222, 0x3333, 0x4444, 0x5555, 0x6666, 0x7777, 0x8888};
uint16 TG1_TX_Data_Master[8] = {0x1112, 0x2223, 0x3334, 0x4445, 0x5556, 0x6667, 0x7778, 0x8889};
uint16 TG2_TX_Data_Master[8] = {0x1113, 0x2224, 0x3335, 0x4446, 0x5557, 0x6668, 0x7779, 0x8880};
uint16 TG3_TX_Data_Master[8] = {0x1114, 0x2225, 0x3336, 0x4447, 0x5558, 0x6669, 0x7770, 0x8881};

/* ӻݻ */
uint16 TG0_RX_Data_Slave[8] = {0};
uint16 TG1_RX_Data_Slave[8] = {0};
uint16 TG2_RX_Data_Slave[8] = {0};
uint16 TG3_RX_Data_Slave[8] = {0};

/* ɱ־ */
static volatile uint32 RX_Complete_Count = 0;
static volatile uint32 TG3_IS_Complete = 0;
static volatile uint32 transfer_error = 0;
static volatile uint32 transfer_success_count = 0;
volatile uint32 debug_isr_entry = 0;

void verify_transfer_data(void);
void prepare_next_transfer(void);

/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    uint32 i;
    uint32 j;

    /* ʼ */
    systemInit();
    muxInit();
    vimInit();
    gioInit();
    hetInit();
    mibspiInit();


    /* LEDָʾ - HET1[0]Ϊ */
    gioSetDirection(hetPORT1, 0x01);
    gioSetBit(hetPORT1, 0x00, 1);  /* LEDʾӻ׼ */
    for(i = 0; i < 10000000; i++);

    /* ʹȫж */
    _enable_IRQ();


    /* ʹ MibSPI Ӳ롰ȴա״̬ */
    //mibspiTransfer(mibspiREG1, TG0);
   // mibspiTransfer(mibspiREG1, TG1);
    //mibspiTransfer(mibspiREG1, TG2);
    //mibspiTransfer(mibspiREG1, TG3);

    /* ʹж֪ͨ */
    mibspiEnableGroupNotification(mibspiREG1, TG0, 1);
    mibspiEnableGroupNotification(mibspiREG1, TG1, 1);
    mibspiEnableGroupNotification(mibspiREG1, TG2, 1);
    mibspiEnableGroupNotification(mibspiREG1, TG3, 1);

    /* ӻģʽ׼ */
    prepare_next_transfer();

    /* ʹ MibSPI Ӳ롰ȴա״̬ */
    mibspiTransfer(mibspiREG1, TG0);
   // mibspiTransfer(mibspiREG1, TG1);
   // mibspiTransfer(mibspiREG1, TG2);
   // mibspiTransfer(mibspiREG1, TG3);



    /* LEDʾ׼ȴ */
   // for(j = 0; j < 3; j++)
   //{
   //    gioSetBit(hetPORT1, 0x00, 0);
   //   for(i = 0; i < 5000000; i++);
   //    gioSetBit(hetPORT1, 0x00, 1);
   //   for(i = 0; i < 5000000; i++);
   //}

    /* ʱȶ */
    while(1)
    {
        /* ӻ׼ȴ */
       // gioSetBit(hetPORT1, 0x00, 1);

        /* ȴд */
        uint32 timeout = 0;
        //mibspiTransfer(mibspiREG1,0);
        //mibspiTransfer(mibspiREG1,1);
        //mibspiTransfer(mibspiREG1,2);
        //mibspiTransfer(mibspiREG1,3);
        while (TG3_IS_Complete != 0xA5A5A5A5)
       {
          timeout++;
            if(timeout > 5000000)  /* ʱԼ5 */
           {
                /* δLEDȴ */
               gioToggleBit(hetPORT1, 0x00);
               timeout = 0;
            }
            mibspiTransfer(mibspiREG1, TG0);
       }

        /* ɣȡ */
        mibspiGetData(mibspiREG1, TG0, TG0_RX_Data_Slave);
        mibspiGetData(mibspiREG1, TG1, TG1_RX_Data_Slave);
        mibspiGetData(mibspiREG1, TG2, TG2_RX_Data_Slave);
        mibspiGetData(mibspiREG1, TG3, TG3_RX_Data_Slave);

        /* ֤ */
        verify_transfer_data();

        /* ׼´δ */
        prepare_next_transfer();


       mibspiTransfer(mibspiREG1, TG0);
       //mibspiTransfer(mibspiREG1, TG1);
       //mibspiTransfer(mibspiREG1, TG2);
       //mibspiTransfer(mibspiREG1, TG3);

        /* ɱ־ */
        TG3_IS_Complete = 0;
        RX_Complete_Count = 0;

        /* LED˸ʾɹ */
        gioSetBit(hetPORT1, 0x00, 0);
        for(i = 0; i < 1000000; i++);
    }

    /* ֤ */
    /* ֤յǷ͵һ */

/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
/*=============================================================================
 * : prepare_next_transfer
 * : ׼´δķ
 * ˵: 
 * ֵ:   
 *
 * ˵:
 *   ӻÿδǰ׼Ҫ͵
 *   ڶμʱӻ͵Ǿݻ
 *============================================================================*/
void prepare_next_transfer(void)
{
    /* ôӻҪ͸ */
    mibspiSetData(mibspiREG1, TG0, TG0_TX_Data_Slave);
    mibspiSetData(mibspiREG1, TG1, TG1_TX_Data_Slave);
    mibspiSetData(mibspiREG1, TG2, TG2_TX_Data_Slave);
    mibspiSetData(mibspiREG1, TG3, TG3_TX_Data_Slave);

    /* ѡҪ̬޸ķݣ޸ */
    /* 磺TG0_TX_Data_Slave[0]++; */
}

/* MibSPIжϻص */
void mibspiGroupNotification(mibspiBASE_t *mibspi, uint32 group)
{
    debug_isr_entry++;
    switch (group)
    {
        case 0:
            /* TG0 */
            RX_Complete_Count++;
            TG3_IS_Complete = 0xA5A5A5A1;
           mibspiTransfer(mibspiREG1, TG1);
            break;

        case 1:
            /* TG1 */
            RX_Complete_Count++;
            TG3_IS_Complete = 0xA5A5A5A2;
          mibspiTransfer(mibspiREG1, TG2);
            break;

        case 2:
            /* TG2 */
            RX_Complete_Count++;
            TG3_IS_Complete = 0xA5A5A5A3;
          mibspiTransfer(mibspiREG1, TG3);
            break;

        case 3:
            /* TG3ɣд */
            RX_Complete_Count++;
          //  mibspiTransfer(mibspiREG1, TG3);
            TG3_IS_Complete = 0xA5A5A5A5;
            break;

        default:
            /* 쳣 */
            while(1);
            break;
    }
}

/*=============================================================================
 * : verify_transfer_data
 * : ֤Ƿ뷢һ
 * ˵: 
 * ֵ:   
 *
 * ˵:
 *   ֤ӻյǷ͵һ
 *   ֤ȷ
 *============================================================================*/
void verify_transfer_data(void)
{
    uint32 i;
    uint32 j;
    uint32 error_count = 0;

    /* ֤ TG0  */
    for(i = 0; i < 8; i++)
    {
        if(TG0_RX_Data_Slave[i] != TG0_TX_Data_Master[i])
        {
            error_count++;
        }
    }

    /* ֤ TG1  */
    for(i = 0; i < 8; i++)
    {
        if(TG1_RX_Data_Slave[i] != TG1_TX_Data_Master[i])
        {
            error_count++;
        }
    }

    /* ֤ TG2  */
    for(i = 0; i < 8; i++)
    {
        if(TG2_RX_Data_Slave[i] != TG2_TX_Data_Master[i])
        {
            error_count++;
        }
    }

    /* ֤ TG3  */
    for(i = 0; i < 8; i++)
    {
        if(TG3_RX_Data_Slave[i] != TG3_TX_Data_Master[i])
        {
            error_count++;
        }
    }

    /* ֤־ */
    if(error_count == 0)
    {
        /* ֤ɹ */
        transfer_success_count++;

        /* LED5αʾ֤ɹ */
        for(j = 0; j < 5; j++)
        {
            gioSetBit(hetPORT1, 0x00, 0);  /* ϨLED */
            for(i = 0; i < 500000; i++);
            gioSetBit(hetPORT1, 0x00, 1);  /* LED */
            for(i = 0; i < 500000; i++);
        }
    }
    else
    {
        /* ֤ʧ */
        gioSetBit(hetPORT1, 0x00, 0);  /* ϨLED */
        transfer_error = error_count;  /* ¼ */
        //while(1);  /* ֹͣ򣬱ڵ */
    }
}

/* USER CODE END */
