/*
 * clock.c
 *
 *  Created on: 202113
 *      Author: 75922
 */
#include <msp432.h>

void clock_init()
{
    P4->DIR |= BIT3 | BIT4;
    P4->SEL0 |=BIT3 | BIT4;                 // Output MCLK
    P4->SEL1 &= ~(BIT3 | BIT4);

    volatile uint32_t i;
    uint32_t currentPowerState;
    /* NOTE: This example assumes the default power state is AM0_LDO.
         * Refer to  msp432p401x_pcm_0x code examples for more complete PCM operations
         * to exercise various power state transitions between active modes.
         */

        /* Step 1: Transition to VCORE Level 1: AM0_LDO --> AM1_LDO */

        /* Get current power state, if it's not AM0_LDO, error out */
        currentPowerState = PCM->CTL0 & PCM_CTL0_CPM_MASK;
        if (currentPowerState != PCM_CTL0_CPM_0)
            ;

    while ((PCM->CTL1 & PCM_CTL1_PMR_BUSY));
    PCM->CTL0 = PCM_CTL0_KEY_VAL | PCM_CTL0_AMR_1;
    while ((PCM->CTL1 & PCM_CTL1_PMR_BUSY));
    if (PCM->IFG & PCM_IFG_AM_INVALID_TR_IFG)
        ;                            // Error if transition was not successful
    if ((PCM->CTL0 & PCM_CTL0_CPM_MASK) != PCM_CTL0_CPM_1)
        ;                            // Error if device is not in AM1_LDO mode

    /* Step 2: Configure Flash wait-state to 1 for both banks 0 & 1 */
    FLCTL->BANK0_RDCTL = (FLCTL->BANK0_RDCTL & ~(FLCTL_BANK0_RDCTL_WAIT_MASK)) |
            FLCTL_BANK0_RDCTL_WAIT_1;
    FLCTL->BANK1_RDCTL = (FLCTL->BANK0_RDCTL & ~(FLCTL_BANK1_RDCTL_WAIT_MASK)) |
            FLCTL_BANK1_RDCTL_WAIT_1 ;

    /* Step 3: Configure HFXT to use 48MHz crystal, source to MCLK & HSMCLK*/


    PJ->SEL0 |= BIT2 | BIT3;                // Configure PJ.2/3 for HFXT function
    PJ->SEL1 &= ~(BIT2 | BIT3);

    CS->KEY = CS_KEY_VAL ;                  // Unlock CS module for register access
    CS->CTL2 |= CS_CTL2_HFXT_EN | CS_CTL2_HFXTFREQ_6 | CS_CTL2_HFXTDRIVE;
    while(CS->IFG & CS_IFG_HFXTIFG)
        CS->CLRIFG |= CS_CLRIFG_CLR_HFXTIFG;

    /* Select MCLK & HSMCLK = HFXT, no divider */
    CS->CTL1 = CS_CTL1_SELA_2;
    CS->CTL1 = (CS->CTL1 & ~(CS_CTL1_SELM_MASK | CS_CTL1_DIVM_MASK | CS_CTL1_SELS_MASK | CS_CTL1_DIVHS_MASK)) |
            CS_CTL1_SELM__HFXTCLK | CS_CTL1_SELS__DCOCLK;

    CS->KEY = 0;                            // Lock CS module from unintended accesses
}

