/*
 * io_in.c
 *
 *  Created on: 202116
 *      Author: 75922
 */
#include <msp432.h>
#include <project.h>
void io_in_init()
{
    P1->DIR = ~(BIT1 + BIT4);
    P1->OUT = BIT1 + BIT4;
    P1->REN = BIT1 + BIT4;                          // Enable pull-up resistor (P1.1 output high)
    P1->IES = BIT1 + BIT4;                          // Interrupt on high-to-low transition
    P1->IFG = 0;                                    // Clear all P1 interrupt flags
    P1->IE = BIT1 + BIT4;                           // Enable interrupt for P1.1
    P2->DIR &= ~BIT4;                               // Echo Pin
    P2->SEL0 |= BIT4;


    NVIC->ISER[1] = 1 << ((PORT1_IRQn) & 31);

}
void PORT1_IRQHandler(void)
{
    if(P1->IFG & BIT1)
    {
        if (PWM_VALUE < 7000)
        {
            //P1->OUT ^= BIT0;
            PWM_VALUE += 50;
        }
    }
    if(P1->IFG & BIT4)
    {

        if (PWM_VALUE > 4000)
        {
            P2->OUT ^= BIT2;
            PWM_VALUE -= 50;
        }
    }
    P1->IFG &= ~BIT1;
    P1->IFG &= ~BIT4;
}


