/*
 * timer.c
 *
 *  Created on: 202113
 *      Author: 75922
 */
#include <msp432.h>
#include <stdint.h>
#include <project.h>
volatile uint16_t times = 0;
volatile uint8_t Edge = 1;                      //Echo/½ز״̬
volatile uint32_t uwTick = 0;                   //ÿ11
volatile uint16_t start_time = 0;               //Echoزʱ
volatile float delay_time = 0;                  //EchoŸߵƽʱ

//˴ҪעHAL_GetTick()ص޷Ҫ뵱ǰCPUλһ¡
uint32_t hal_get_tick()
{
    return uwTick;
}

void hal_delay(uint32_t Delay)
{
    volatile uint32_t tickstart = hal_get_tick();
    volatile uint32_t wait = Delay;

    while((hal_get_tick() - tickstart) < wait)
    {

    }
}
void delay_ms (uint16_t delay_time)
{
    Time_Start = 1;
    Delay_Time = delay_time;
    while (Time_OK == 0);
    Time_OK = 0;
    return;
}

void TA0_0_IRQHandler(void)
{
    TIMER_A0->CCTL[0] &= ~TIMER_A_CCTLN_CCIFG;
    P2->OUT ^= BIT0;
    uwTick ++;

    //-------------------------------------------------
    //ʱ
    if (Time_Start == 1)
    {
        if (times >= Delay_Time)
        {
            Time_Start = 0;
            times = 0;
            Time_OK = 1;
        }
        else
            times ++;
    }
}
//ģʽ
void TA3_N_IRQHandler(void)
{
    TIMER_A3->CCTL[1] &= ~TIMER_A_CCTLN_CCIFG;
    P2->OUT ^= BIT1;
    if (Edge == RISE)
    {
        start_time = TIMER_A3->CCR[1];
        TIMER_A3->CCTL[1] |= TIMER_A_CCTLN_CM_2;                        //½
        Edge = FALL;                                                    //Ĳ״̬
    }
    else
    {
        delay_time = TIMER_A3->CCR[1] - start_time;                     //
        Height = delay_time/1516.0*340;
        TIMER_A3->CCTL[1] |= TIMER_A_CCTLN_CM_1;                        //
        Edge = RISE;                                                    //Ĳ״̬
    }


}
void timer_init()
{
    //ʱA1,PWM
    TIMER_A1->CCR[0] = 8000;                                            // PWM 380hz

    TIMER_A1->CCTL[1] = TIMER_A_CCTLN_OUTMOD_7;                         // CCR1 reset/set
    TIMER_A1->CCR[1] = PWM_VALUE;                                       // CCR1 PWM duty cycle

    TIMER_A1->CCTL[2] = TIMER_A_CCTLN_OUTMOD_7;                         // CCR2 reset/set
    TIMER_A1->CCR[2] = 1000;                                            // г

    TIMER_A1->CTL = TIMER_A_CTL_SSEL__SMCLK |                           // SMCLK
            TIMER_A_CTL_MC__UP |                                        // Up mode
            TIMER_A_CTL_CLR;                                            // Clear TAR

    //ʱA0,ڲ1msһεжϣʱ
    TIMER_A0->CCTL[0] = TIMER_A_CCTLN_CCIE;                             // TACCR0 interrupt enabled
    TIMER_A0->CCR[0] = 1516;                                            //1msһж
    TIMER_A0->CTL = TIMER_A_CTL_SSEL__SMCLK |
            TIMER_A_CTL_MC__UP |
            TIMER_A_CTL_CLR;

    //ʱA3,EchoŸߵƽʱ
    TIMER_A3->CCTL[1] = TIMER_A_CCTLN_CM_1 |                            // Capture rising edge,
            TIMER_A_CCTLN_CCIS_0 |                                      // Use CCI2A=ACLK,
            TIMER_A_CCTLN_CCIE |                                        // Enable capture interrupt
            TIMER_A_CCTLN_CAP |                                         // Enable capture mode,
            TIMER_A_CCTLN_SCS;                                          // Synchronous capture

    TIMER_A3->CTL |= TIMER_A_CTL_TASSEL_2 |                             // Use SMCLK as clock source,
                TIMER_A_CTL_MC__CONTINUOUS |                            // Start timer in continuous mode
                TIMER_A_CTL_CLR;                                        // clear TA3R

    SCB->SCR |= SCB_SCR_SLEEPONEXIT_Msk;                                // Enable sleep on exit from ISR

    // Ensures SLEEPONEXIT takes effect immediately
    __DSB();


    NVIC->ISER[0] = 1 << ((TA0_0_IRQn) & 31);
    NVIC->ISER[0] = 1 << ((TA3_N_IRQn) & 31);

}


