/*
 * uart.c
 *
 *  Created on: 202119
 *      Author: 75922
 */
#include <msp432.h>
#include <stdint.h>
uint8_t TXData = 1;
void uart_init()
{

    // Configure UART pins
    P1->SEL0 |= BIT2 | BIT3;                // set 2-UART pin as second function

    // Configure UART
    EUSCI_A0->CTLW0 |= EUSCI_A_CTLW0_SWRST; // Put eUSCI in reset
    EUSCI_A0->CTLW0 = EUSCI_A_CTLW0_SWRST | // Remain eUSCI in reset
            EUSCI_B_CTLW0_SSEL__SMCLK;      // Configure eUSCI clock source for SMCLK
    // Baud Rate calculation
    EUSCI_A0->BRW = 1;                      // Using baud rate calculator
    EUSCI_A0->MCTLW = (10 << EUSCI_A_MCTLW_BRF_OFS) |
            EUSCI_A_MCTLW_OS16;
    EUSCI_A0->CTLW0 &= ~EUSCI_A_CTLW0_SWRST;// Initialize eUSCI
    EUSCI_A0->IE |= EUSCI_A_IE_RXIE;        // Enable USCI_A0 RX interrupt

    SCB->SCR &= ~SCB_SCR_SLEEPONEXIT_Msk;   // Wake up on exit from ISR
    // Ensures SLEEPONEXIT occurs immediately
    __DSB();

    // Enable eUSCIA0 interrupt in NVIC module
    NVIC->ISER[0] = 1 << ((EUSCIA0_IRQn) & 31);
}
// UART interrupt service routine
void EUSCIA0_IRQHandler(void)
{
    uint8_t RXData;

    if (EUSCI_A0->IFG & EUSCI_A_IFG_RXIFG)
    {
        EUSCI_A0->IFG &=~ EUSCI_A_IFG_RXIFG;// Clear interrupt
        RXData = EUSCI_A0->RXBUF;           // Clear buffer
        if(RXData != TXData)                // Check value
        {
            P1->OUT |= BIT0;                // If incorrect turn on P1.0
            while(1);                       // trap CPU
        }
        TXData++;                           // increment data byte
    }
}
