/********************************************************************************************************
*
* bl_main.c      : The main filefor the boot loader.
* Author         : QJ Wang. qjwang@ti.com
* Date           : 2-18-2016
*
* Copyright (c) 2006-2011 Texas Instruments Incorporated.  All rights reserved.
* Software License Agreement
*
* Texas Instruments (TI) is supplying this software for use solely and
* exclusively on TI's microcontroller products. The software is owned by
* TI and/or its suppliers, and is protected under applicable copyright
* laws. You may not combine this software with "viral" open-source
* software in order to form a larger program.
*
* THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
* NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
* NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
* A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
* CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
* DAMAGES, FOR ANY REASON WHATSOEVER.
*
* Author:  Qingjun Wang  (qjwang@ti.com)
*---------------------------------------------------------------------------------------------------------------------
* Revision History
*---------------------------------------------------------------------------------------------------------------------
* Version          Date        Author         Description
*---------------------------------------------------------------------------------------------------------------------
*/

#include "bl_config.h"
#include "bl_uart.h"
#include "HL_system.h"
#include "bl_check.h"
#include "sci_common.h"
//#include "HL_rti.h"
#include "HL_gio.h"

/*****************************************************************************
* bl_main
******************************************************************************/
/*****************************************************************************
*
* This holds the current remaining size in bytes to be downloaded.
*
******************************************************************************/
uint32_t g_ulTransferSize;

/*****************************************************************************
*
* This holds the current address that is being written to during a download
* command.
*
******************************************************************************/
uint32_t g_ulTransferAddress;

/*****************************************************************************
*
* This is the data buffer used during transfers to the boot loader.
*
******************************************************************************/
uint32_t g_pulDataBuffer[BUFFER_SIZE];

/*****************************************************************************
*
* This is the data buffer used for update status.
*
* g_pulUpdateSuccess[] are used to store application update status and application
* image's version etc
******************************************************************************/

uint32_t g_pulUpdateSuccess[] = {0x5A5A5A5A, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0};
uint32_t g_ulUpdateStatusAddr = APP_STATUS_ADDRESS;

uint32_t g_ulUpdateBufferSize = 32; /*32 bytes or 8 32-bit words*/

#define E_PASS     		0
#define E_FAIL     		0x1U
#define E_TIMEOUT  		0x2U

/*****************************************************************************
*
* This is an specially aligned buffer pointer to g_pulDataBuffer to make
* copying to the buffer simpler.  It must be offset to end on an address that
* ends with 3.
*
******************************************************************************/
uint8_t *g_pucDataBuffer;

extern unsigned int apiLoadStart;
extern unsigned int apiLoadSize;
extern unsigned int apiRunStart;

/*****************************************************************************
*
* This holds the current address that is being written to during a download
* command.
*
******************************************************************************/
void delay(unsigned int delayval)
{
	while (delayval--);
}


void bl_main(void)
{
	uint32_t fnRetValue;

    /* Copy the flash APIs to SRAM*/
    memcpy(&apiRunStart, &apiLoadStart, (uint32)&apiLoadSize);

	/* Initialize RTI driver */
	gioInit();
	gioSetDirection(gioPORTB, 0xFFFF);

	/* Initialize SCI Routines to receive Command and transmit data */
//	sciInit();
//	UART_putString(UART, "\r Hercules MCU UART BootLoader ");
//
//	UART_putString(UART, "\r TI Safety MCU Application Team, qjwang@ti.com \r\r");

	//
	//  See if an update should be performed.
	//
	fnRetValue = CheckForceUpdate();

	//fnRetValue = 0;  //1-update, 0-jump to application
	if (!fnRetValue)
	{
		#ifdef DEBUG_MSG
		UART_putString(UART, "\r Jump to application...  ");
		#endif
		g_ulTransferAddress = (uint32_t)APP_START_ADDRESS;
		((void (*)(void))g_ulTransferAddress)();
	}

	UpdaterUART();
}

