/*----------------------------------------------------------------------------*/
/* sys_link_freeRTOS.cmd                                                      */
/*                                                                            */
/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com  
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

/*                                                                            */
/*----------------------------------------------------------------------------*/
/* USER CODE BEGIN (0) */
ECC
{
    algoL2R5F021 : address_mask = 0xfffffff8   /* ַλ 31:3   */
                   hamming_mask  = R4            /* ʹ R4/R5    */
                   parity_mask   = 0x0c          /* ż/Уλ       */
                   mirroring     = F021         /* ʹ F021     */
}
/* USER CODE END */
/*----------------------------------------------------------------------------*/
/* Linker Settings                                                            */

--retain="*(.intvecs)"

/* USER CODE BEGIN (1) */
/*--retain="*(.sl_stflash_SRAM)"
//"${CG_TOOL_ROOT}/bin/armobjcopy" -O binary "${BuildArtifactFileName}" "${BuildArtifactFileBaseName}.bin" --only-section=.intvecs --only-section=.kernelTEXT --only-section=.text --only-section=.const --only-section=.cinit --only-section=.pinit
/* USER CODE END */

/*----------------------------------------------------------------------------*/
/* Memory Map                                                                 */

MEMORY
{
    VECTORS (X)  : origin=0x00000000 length=0x00000020
    KERNEL  (RX) : origin=0x00000020 length=0x00008000 
    FLASH0  (RX) : origin=0x00008020 length=0x001F7FE0
    FLASH1  (RX) : origin=0x00200000 length=0x00200000
    STACKS  (RW) : origin=0x08000000 length=0x00000800
    KRAM    (RW) : origin=0x08000800 length=0x00000800
    RAM     (RW) : origin=(0x08000800+0x00000800) length=(0x0007f800 - 0x00000800)
    
/* USER CODE BEGIN (2) */
/*
	ECC_VEC  (R) : origin=(0xf0400000 + (start(VECTORS) >> 3))
                   length=(size(VECTORS) >> 3)
                   ECC={algorithm=algoL2R5F021, input_range=VECTORS}

	ECC_KER  (R) : origin=(0xf0400000 + (start(KERNEL) >> 3))
                   length=(size(KERNEL) >> 3)
                   ECC={algorithm=algoL2R5F021, input_range=KERNEL}

   	ECC_API  (R) : origin=(0xf0400000 + (start(FLASH_API) >> 3))
                   length=(size(FLASH_API) >> 3)
                   ECC={algorithm=algoL2R5F021, input_range=FLASH_API}


  	ECC_FLA0 (R) : origin=(0xf0400000 + (start(FLASH0)  >> 3))
                   length=(size(FLASH0)  >> 3)
                   ECC={algorithm=algoL2R5F021, input_range=FLASH0 }

    ECC_FLA1 (R) : origin=(0xf0400000 + (start(FLASH1)  >> 3))
                   length=(size(FLASH1)  >> 3)
                   ECC={algorithm=algoL2R5F021, input_range=FLASH1 }

*/
/* Bank 7 ECC */

}
/* USER CODE END */


/* USER CODE BEGIN (3) */

/* USER CODE END */

/*----------------------------------------------------------------------------*/
/* Section Configuration                                                      */

SECTIONS
{
    .intvecs : {} > VECTORS
    /* FreeRTOS Kernel in protected region of Flash */
    .kernelTEXT  align(32) : {} > KERNEL
    .cinit       align(32) : {} > KERNEL
    .pinit       align(32) : {} > KERNEL
    /* Rest of code to user mode flash region */
    .text        align(32) : {} > FLASH0 | FLASH1
    .const       align(32) : {} > FLASH0 | FLASH1  run = RAM, LOAD_START(constLoadStart), RUN_START(constRunStart), SIZE(constLoadSize)
    /* FreeRTOS Kernel data in protected region of RAM */
    .kernelBSS    : {} > KRAM
    .kernelHEAP   : {} > RAM
    .bss          : {} > RAM
    .data         : {} > RAM    
	.sysmem        : {} > RAM
/* USER CODE BEGIN (4) */
/*
 	.App_Flash_Erase_API_Section :  RUN = RAM, LOAD = FLASH0 | FLASH1
						LOAD_START(App_Flash_Erase_API_LoadStart), LOAD_END(App_Flash_Erase_API_LoadEnd), LOAD_SIZE(App_Flash_Erase_API_Size),
						RUN_START(App_Flash_Erase_API_StartAddr), RUN_END(App_Flash_Erase_API_EndAddr)


	.App_Flash_Program_API_Section :  RUN = RAM, LOAD = FLASH0 | FLASH1
						LOAD_START(App_Flash_Program_API_LoadStart), LOAD_END(App_Flash_Program_API_LoadEnd), LOAD_SIZE(App_Flash_Program_API_Size),
						RUN_START(App_Flash_Program_API_StartAddr), RUN_END(App_Flash_Program_API_EndAddr)

						*/
/*
    	flashAPI:
	{
     .\Boot\Fapi_UserDefinedFunctions.obj (.text, .data)
     .\Boot\bl_flash.obj (.text, .data)
      --library = F021_API_CortexR4_BE_L2FMC.lib (.text, .data)
	} palign=8 LOAD = FLASH0|FLASH1, RUN = RAM, LOAD_START(apiLoadStart), RUN_START(apiRunStart), SIZE(apiLoadSize)

	flashAPI:
	{
     ../Debug/Boot/Fapi_UserDefinedFunctions.obj (.text, .data)
     ../Debug/Boot/bl_flash.obj (.text, .data)
      --library = F021_API_CortexR4_BE_L2FMC.lib (.text, .data)
	} palign=8 LOAD = KERNEL, RUN = RAM, LOAD_START(apiLoadStart), RUN_START(apiRunStart), SIZE(apiLoadSize)
*/

/* USER CODE END */
}

/* USER CODE BEGIN (5) */

/* USER CODE END */

/*----------------------------------------------------------------------------*/
/* Misc                                                                       */

/* USER CODE BEGIN (6) */
/*
    .intvecs : {} > VECTORS

    .kernelTEXT  align(32) : {} > KERNEL
    .cinit       align(32) : {} > KERNEL
    .pinit       align(32) : {} > KERNEL

    .text        align(32) : {} > FLASH0|FLASH1
    //ãconstLoadStartconstRunStartconstLoadSize3⡣
//    .const       align(32) : {} > FLASH0 | FLASH1  run = RAM, LOAD_START(constLoadStart), RUN_START(constRunStart), SIZE(constLoadSize)
	.const       align(32) : {} > FLASH0|FLASH1

    .kernelBSS    : {} > KRAM
    .kernelHEAP   : {} > RAM
    .bss          : {} > RAM
    .data         : {} > RAM
	flashAPI:
	{
     .\Boot\Fapi_UserDefinedFunctions.obj (.text)
      .\Boot\bl_flash.obj (.text)
      --library = F021_API_CortexR4_BE_L2FMC.lib (.text)
	} palign=8 load = FLASH0|FLASH1, run = RAM, LOAD_START(apiLoadStart), RUN_START(apiRunStart), SIZE(apiLoadSize)

	LOG_DATA          : START( ulLOGStartAddr ), END( ulLOGEndAddr ) > RAM
	.sl_stflash_SRAM  : RUN = RAM, LOAD = FLASH0|FLASH1, LOAD_START(ulHighHandlerLoadStart), LOAD_END(ulHighHandlerLoadEnd), LOAD_SIZE(ulHighHandlerSize), RUN_START( ulHighHandlerStartAddr ), RUN_END( ulHighHandlerEndAddr )

*/
/* USER CODE END */

/*----------------------------------------------------------------------------*/
