/*
 * test.c
 *
 *  Created on: 2025917
 *      Author: ADMINJxy
 */

/* ͷļĴ Halcogen ɵ sys_common.h  system.h */
#include "HL_system.h"
#include "HL_esm.h"

#include "test.h"

// ʼ֡
void frame_parser_init(FrameParser *parser) {
    memset(parser, 0, sizeof(FrameParser));
    parser->state = STATE_HEADER1;
}

// ֡״̬
void frame_parser_reset(FrameParser *parser) {
    parser->state = STATE_HEADER1;
    parser->buffer_len = 0;
    parser->expected_len = 0;
    parser->checksum = 0;
}




// ֡
// سɹ֡
int parse_frame_data(FrameParser *parser, const uint8_t *data, uint16_t len,
                    FrameCallback callback, void *user_data) {
    int frame_count = 0;

    for (uint16_t i = 0; i < len; i++) {
        uint8_t byte = data[i];

        switch (parser->state) {
            case STATE_HEADER1:
                if (byte == 0xEB) {
                    // ҵ֡ͷһֽ
                    parser->buffer[0] = byte;
                    parser->buffer_len = 1;
                    parser->checksum = byte;
                    parser->state = STATE_HEADER2;
                }
                break;

            case STATE_HEADER2:
                if (byte == 0x90) {
                    // ҵ֡ͷڶֽ
                    parser->buffer[1] = byte;
                    parser->buffer_len = 2;
                    parser->checksum += byte;
                    parser->state = STATE_TYPE;
                } else {
                    // ֡ͷƥ䣬Ѱ
                    frame_parser_reset(parser);
                    // ¼鵱ǰֽڣһ֡ͷĿʼ
                    if (byte == 0xEB) {
                        parser->buffer[0] = byte;
                        parser->buffer_len = 1;
                        parser->checksum = byte;
                        parser->state = STATE_HEADER2;
                    }
                }
                break;

            case STATE_TYPE:
                // ͱʶ
                parser->buffer[2] = byte;
                parser->buffer_len = 3;
                parser->checksum += byte;
                parser->state = STATE_COUNT;
                break;

            case STATE_COUNT:
                // м
                parser->buffer[3] = byte;
                parser->buffer_len = 4;
                parser->checksum += byte;
                parser->state = STATE_LENGTH;
                break;

            case STATE_LENGTH:
                // ָ
                parser->buffer[4] = byte;
                parser->buffer_len = 5;
                parser->checksum += byte;
                parser->data_len = byte;
                parser->expected_len = 5 + byte + 1 + 1; // ͷ5ֽ + ݳ+1 + У

                if (parser->data_len == 0) {
                    // ûֱӽУ״̬
                    parser->state = STATE_CHECKSUM;
                } else {
                    parser->state = STATE_DATA;
                }
                break;

            case STATE_DATA:
                // ָ
                if (parser->buffer_len < parser->expected_len - 1) {
                    parser->buffer[parser->buffer_len] = byte;
                    parser->checksum += byte;
                    parser->buffer_len++;

                    // Ƿ
                    if (parser->buffer_len == parser->expected_len - 1) {
                        parser->state = STATE_CHECKSUM;
                    }
                }
                break;

            case STATE_CHECKSUM:
                // У
                uint8_t calculated_checksum = parser->checksum & 0xFF;

                if (calculated_checksum == byte) {
                    // Уɹ֡
                    FrameData frame;
                    frame.type = parser->buffer[2];
                    frame.count = parser->buffer[3];
                    frame.data_len = parser->buffer[4];
                    frame.checksum = byte;

                    // ڴ沢ָ
                    if (frame.data_len > 0) {
                        frame.data = (uint8_t*)pvPortMalloc(frame.data_len);
                        if (frame.data) {
                            memcpy(frame.data, &parser->buffer[5], frame.data_len);
                        }
                    } else {
                        frame.data = NULL;
                    }

                    // ûص
                    if (callback) {
                        callback(&frame, user_data);
                    }

                    // ͷڴ
                    if (frame.data) {
                        vPortFree(frame.data);
                    }//еʱͷ

                    frame_count++;
                } else {
                    // УʧܣԼ¼־
                    printf("Checksum error: expected 0x%02X, got 0x%02X\n",
                           calculated_checksum, byte);
                }

                // УǷɹ״̬Ѱһ֡
                frame_parser_reset(parser);
                break;
        }

        // ֹ
        if (parser->buffer_len >= sizeof(parser->buffer)) {
            frame_parser_reset(parser);
        }
    }

    return frame_count;
}





