#include <stdio.h>
#include <string.h>
#include "user_list.h"

static   St_RxTC_pkt    g_stTCRawData[8];
volatile St_RxTC_pkt      *g_pstTc_RawData_Wr = g_stTCRawData;

xQueueHandle    g_hQTCFrm;                /*-ң֡սڵ--*/

void TC_RawData_Init(void)
{
    if(!(g_hQTCFrm = xQueueCreate(8, sizeof(St_RxTC_pkt*))))
    {
       while(1);
    }
    uint32_t i;
    uint32_t nCnt = sizeof(g_stTCRawData)/sizeof(g_stTCRawData[0]);

    for (i=0; i<nCnt; ++i)
    {
        g_stTCRawData[i].nLen = 0;

        g_stTCRawData[i].pNext = ((nCnt - 1)==i)? (g_stTCRawData) : (&g_stTCRawData[i+1]);
    }
    g_pstTc_RawData_Wr = g_stTCRawData;
}


void TC_Get_Data(uint8_t *pdata,uint16_t nLen)
{
    if((pdata == NULL) || (nLen == 0)) return;
    portBASE_TYPE xHigherPriorityTaskWoken = pdFALSE;
    g_pstTc_RawData_Wr->nLen = nLen;
    memcpy(&(g_pstTc_RawData_Wr->mBuff),pdata,g_pstTc_RawData_Wr->nLen);
//    xQueueSendToBack(g_hQTCFrm, &(g_pstTc_RawData_Wr),&xHigherPriorityTaskWoken);
    xQueueSendToBack(g_hQTCFrm, &(g_pstTc_RawData_Wr),0);
    TC_RawData_IncWr();
}

void TC_Get_DataFromeISR(uint8_t *pdata,uint16_t nLen)
{
    if((pdata == NULL) || (nLen == 0)) return;
    portBASE_TYPE xHigherPriorityTaskWoken = pdFALSE;
    g_pstTc_RawData_Wr->nLen = nLen;
    memcpy(&(g_pstTc_RawData_Wr->mBuff),pdata,g_pstTc_RawData_Wr->nLen);
    xQueueSendToBackFromISR(g_hQTCFrm, &(g_pstTc_RawData_Wr),&xHigherPriorityTaskWoken);
    TC_RawData_IncWr();
}

