/*
 * arthmetric_api.c
 *
 *  Created on:
 *      Author:
 */

#include "arthmetric_api.h"
#include "math.h"
#include "sys_config.h"
#include "fcr_ctrl_api.h"


ToffDef  ToffDeltau_tStu={
	.u32TmrNum=6000U,
	.u32Delay=0U,
	.u32Out=0U
};

ExcPIDCtrlDef ExcUIPIDCtrlStu={
	.f32avr_setp = 1.0F,
	.f32If_ExiSetp_en = 0U,
	.u32navr_avr_uc_sel=0U,
};


float32_t DealteU_DeltaT_Reset(float32_t f32Ug_rel,float32_t f32If_rel,float32_t f32up_limt,IIRFormIIDef *iirInfor,IIR1ParamDef *iir1Param)
{
	uint32_t u32CtrlBit=0U;
	float32_t f32uplim=0.0F;
	float32_t f32Res=0.0F;
	Filter_IIR1_FormII(f32Ug_rel,iirInfor,iir1Param);
	if(iirInfor->f32Result < -0.5F)
	{
		u32CtrlBit = bTrue;
	}
	Toff(u32CtrlBit,&ToffDeltau_tStu);
	if(ToffDeltau_tStu.u32Out == bTrue)
	{
		f32uplim = 0.5F*f32up_limt;
	}
	else
	{
		f32uplim = 1.5F*f32up_limt;
	}
	f32Res = f32If_rel;
	if(f32Res > f32uplim)
	{
		f32Res = f32uplim;
	}
	if(f32Res < -1000.0F)
	{
		f32Res = -1000.0F;
	}
	return f32Res;
}

void Toff(uint32_t u32In,ToffDef *ToffInfor)
{
	uint32_t u32Temp=0U;
	if(u32In == 0U)
	{
		ToffInfor->u32Delay++;
	}
	else
	{
		ToffInfor->u32Delay = 0U;
	}
	if(ToffInfor->u32Delay >= 65530U)
	{
		ToffInfor->u32Delay = 65530U;
	}
	if(ToffInfor->u32Delay > ToffInfor->u32TmrNum)
	{
		u32Temp = bTrue;
	}
	ToffInfor->u32Out = ~u32Temp;
}



void ExcAdjustPID(uint32_t u32Exc_on_cmd,float32_t f32Ug_rel,float32_t f32If_rel,fcrCtrlDef *fcrCtrl,ExcPIDCtrlDef *ExcUIPIDCtrl,fcrParamDef *fcrCtrlParam)
{
	float32_t f32Result=0.0F,f32DataTemp=0.0F;
	float32_t f32IfLb1=0.0F,f32IfLb2=0.0F,f32IfLb=0.0F;
	float32_t f32avr_uc=0.0F,f32AvrUcTmp=0.0F;
	//static float32_t f32AvrUcDdelay=0.0F;
	float32_t f32Va2=0.0F;


	f32Result = DealteU_DeltaT_Reset(f32Ug_rel,f32If_rel,fcrCtrlParam->f32If_up_limit,&IIR1_Deltau_tStu,&IIR1_Deltau_tParamStu);

}
