/*
 * filter_iir_api.c

 */

#include "filter_iir_api.h"
#include "sys_param.h"

IIRFormIIDef IIR1_Deltau_tStu={
	.f32input=0.0F,
	.f32delay0=0.0F,
	.f32delay1=0.0F,
	.f32delay2=0.0F,
	.f32Result=0.0F
};

void Filter_IIR1_FormII(float32_t f32inPut,IIRFormIIDef *iirInfor,IIR1ParamDef *iir1Param)
{
	float32_t f32DataTemp=0.0F;
	iirInfor->f32input = f32inPut;
	f32DataTemp = f32inPut - iirInfor->f32delay1*iir1Param->f32a1;
	if(fabs(iir1Param->f32a0) > ZERO_AREA)
	{
		iirInfor->f32delay0 = f32DataTemp/iir1Param->f32a0;
		iirInfor->f32Result = iirInfor->f32delay0*iir1Param->f32b0 + iirInfor->f32delay1*iir1Param->f32b1;
	}
	else
	{
		iirInfor->f32delay0 = f32inPut;
		iirInfor->f32Result = 0.0F;
	}
	iirInfor->f32delay1 = iirInfor->f32delay0;

}
