/*********************************************************************
* Author:	Miguel Hernandez IV
* Filename: cf.h
* Date:		7-2-01
*********************************************************************/

/*====================================================================
	I/O Space Addresses (IDE Mode Transfer Function)
====================================================================*/

/*---- Control Block Registers ----*/
/*
ioport unsigned portA806;
ioport unsigned portA807;
*/
/*---- Command Block Registers ----*/
/*
ioport unsigned portB000;
ioport unsigned portB001;
ioport unsigned portB002;
ioport unsigned portB003;
ioport unsigned portB004;
ioport unsigned portB005;
ioport unsigned portB006;
ioport unsigned portB007;
*/
/*---- Control Block Registers ----*/
/*
#define AlternateStatusRegister portA806
#define ControlRegister 		portA806
#define DriveAddressRegister 	portA807
*/
/*---- Command Block Registers ----*/
/*
#define DataRegister 			portB000
#define ErrorRegister 			portB001
#define FeaturesRegister 		portB001
#define SectorCountRegister 	portB002
#define SectorNumberRegister 	portB003
#define CylinderLowRegister 	portB004
#define CylinderHighRegister 	portB005
#define CardHeadRegister 		portB006
#define StatusRegister 			portB007
#define CommandRegister 		portB007 
*/
/*==================================================================*/

/*====================================================================
	ATA Commands
====================================================================*/

/*#define CIdentifyDrive 				0xEC
#define CExecuteDriveDiagnostics 	0x90
#define CReadSectors                0x20
#define CSetFeatures                0xEF
#define CRecalibrate                0x10
#define CWriteSectors               0x30*/

extern unsigned short CReadSectors;
extern unsigned short CWriteSectors;
extern unsigned short CIdentifyDrive;

/*==================================================================*/ 

/*====================================================================
	Drive/Card Number
====================================================================*/
/*
#define Drive_0 0xE0
*/
/*==================================================================*/

/*====================================================================
	Function Prototypes
====================================================================*/

/*---- CompactFlash Status Checks ----*/
void CF_CheckReadyStatus();
void CF_CheckBusyStatus();
void CF_CheckDrqStatus();
void CheckErrorStatus();
/*---- Reset ----*/
void CF_HardwareReset();
/*---- Initialize C54x ----*/
void DSP_Init();
/*---- Commands ----*/
void CF_IssueCommand(unsigned long PhysicalSector, 
                  unsigned short SectorCount, unsigned short Command);
void CF_IdentifyDrive();
/*---- CF Read/Write -----*/                      
void ReadCF(unsigned long PhysicalSector, 
           unsigned short SectorCount);
void WriteCF(unsigned long PhysicalSector, 
           unsigned short SectorCount);

/*==================================================================*/    
/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted 
* by Texas Instruments is distributed as "freeware".  You may, 
* only under TI's copyright in the Program, use and modify the 
* Program without any charge or restriction.  You may 
* distribute to third parties, provided that you transfer a 
* copy of this license to the third party and the third party 
* agrees to these terms by its first use of the Program. You 
* must reproduce the copyright notice and any other legend of 
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains 
* copyrighted material, trade secrets and other TI proprietary 
* information and is protected by copyright laws, 
* international copyright treaties, and trade secret laws, as 
* well as other intellectual property laws.  To protect TI's 
* rights in the Program, you agree not to decompile, reverse 
* engineer, disassemble or otherwise translate any object code 
* versions of the Program to a human-readable form.  You agree 
* that in no event will you alter, remove or destroy any 
* copyright notice included in the Program.  TI reserves all 
* rights not specifically granted under this license. Except 
* as specifically provided herein, nothing in this agreement 
* shall be construed as conferring by implication, estoppel, 
* or otherwise, upon you, any license or other right under any 
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */


