**********************************************************************
* This file contains CompactFlash Memory Card Register values and 
* defines the ATA commands
* Author:	Miguel Hernandez IV
* Filename:	cf_io_space.inc
* Date:		08-01-01
**********************************************************************
			
**********************************************************************
* I/0 Space Addresses (IDE Mode Transfer Function)
**********************************************************************

***** Alternate Status Register / Device Control Register

AltStatReg	.set	0xA806	;Alt Status (Read Only)
ControlReg	.set	0xA806  ;Control (Write Only)

***** Data Register

WrdDataReg	.set	0xB000	;Data Register (Read/Write)

***** Task File Registers

ErrorReg	.set	0xB001	;Error Register (Read Only)
FeatureReg  .set	0xB001	;Features Register (Write Only)
SectCntReg	.set	0xB002	;Sector Count Register (Read/Write)
SectNumReg	.set	0xB003	;Sector Number Register (Read/Write)
CylnLowReg	.set	0xB004	;Cylinder Low Register (Read/Write)
CylnHighReg	.set	0xB005	;Cylinder High Register (Read/Write)
CrdHeadReg	.set	0xB006	;Card and Head Register (Read/Write)
StatusReg	.set	0xB007	;Status Register (Read Only)
CommandReg	.set	0xB007	;Command Register (Write Only)

**********************************************************************
* Commands
**********************************************************************

	.data
		
_CIdentifyDrive	.uint	0xEC	;Identify Drive
_CReadSectors	.uint	0x20	;Read Sector(s)
_CWriteSectors	.uint	0x30	;Write Sector(s)

    .global _CIdentifyDrive
    .global _CReadSectors
    .global _CWriteSectors
/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted 
* by Texas Instruments is distributed as "freeware".  You may, 
* only under TI's copyright in the Program, use and modify the 
* Program without any charge or restriction.  You may 
* distribute to third parties, provided that you transfer a 
* copy of this license to the third party and the third party 
* agrees to these terms by its first use of the Program. You 
* must reproduce the copyright notice and any other legend of 
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains 
* copyrighted material, trade secrets and other TI proprietary 
* information and is protected by copyright laws, 
* international copyright treaties, and trade secret laws, as 
* well as other intellectual property laws.  To protect TI's 
* rights in the Program, you agree not to decompile, reverse 
* engineer, disassemble or otherwise translate any object code 
* versions of the Program to a human-readable form.  You agree 
* that in no event will you alter, remove or destroy any 
* copyright notice included in the Program.  TI reserves all 
* rights not specifically granted under this license. Except 
* as specifically provided herein, nothing in this agreement 
* shall be construed as conferring by implication, estoppel, 
* or otherwise, upon you, any license or other right under any 
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */