/**************************************************************************************************
  Filename:       mytest.c
  Revised:        
  Revision:       V0.1
  author:         tianlx1985,QQ 569225520 Email-tianlx1985@qq.com
  Description:    USB CDC DEMO
**************************************************************************************************/

#include "mytest.h"
#include "npi.h"
#include "OSAL.h"

#include<ioCC2540.h>

uint8 Mytest_TaskID;

#define LED1 P0_0    //P10ΪLED1ƶ ־Ƿ
#define LED0 P1_1    //P10ΪLED1ƶ ־ݽ״̬

//uint8 Test[] = "usb cdc demo tianlx1985\0x0d\0x0a";
uint8 RxBuf[512];//ջ
uint16 NumOfRx = 0;//ճ

//typedef void (*npiCBack_t) ( uint8 port, uint8 event );
void uartEvtCb(uint8 port,uint8 event)
{
  if(event & HAL_UART_RX_READY)
  {
    osal_set_event(Mytest_TaskID,MYTEST_RX_EVENT);

    //LED0 = ~LED0;
  }
}


void Mytest_Init( uint8 task_id )
{
  /* Register task ID */
  Mytest_TaskID = task_id;
  
  //set P1_1 output
  P0DIR |= 0x01;
  P1DIR |= 0x02;
  
  LED1 = 0;
  LED0 = 0;
  
  //ʼݽӿ
  //typedef void (*npiCBack_t) ( uint8 port, uint8 event );  
  NPI_InitTransport(uartEvtCb);
  
  //start 500ms delay for led toogle
  osal_set_event(Mytest_TaskID,MYTEST_LED_EVENT);

}


uint16 Mytest_ProcessEvent( uint8 task_id, uint16 events )
{
  uint8 *msgPtr;

  (void)task_id;  // Intentionally unreferenced parameter

  if ( events & SYS_EVENT_MSG )
  {
    msgPtr = osal_msg_receive(Mytest_TaskID);

    while (msgPtr)
    {
      /* Do something here - for now, just deallocate the msg and move on */

      /* De-allocate */
      osal_msg_deallocate( msgPtr );
      /* Next */
      msgPtr = osal_msg_receive( Mytest_TaskID );
    }
    
    return events ^ SYS_EVENT_MSG;
  }
    
  if(events & MYTEST_USB_EVENT)
  {
    return events ^ MYTEST_USB_EVENT;
  }
  
  if(events & MYTEST_LED_EVENT)
  {
    LED1 = ~LED1;
    
    osal_start_timerEx(Mytest_TaskID,MYTEST_LED_EVENT,500);
    
//    NumOfRx = NPI_RxBufLen();
//    
//    if(NumOfRx)
//    {
//        NPI_ReadTransport(RxBuf,NumOfRx);
//        
//        osal_set_event(Mytest_TaskID,MYTEST_TX_EVENT);
//    }
        
    return events ^ MYTEST_LED_EVENT;
  }
  
  if(events & MYTEST_TX_EVENT)
  {    
    LED0 = ~LED0;
    
    NPI_WriteTransport(RxBuf,NumOfRx); 
    
    NumOfRx = 0;
    
    return events ^ MYTEST_TX_EVENT;
  }
  
  if(events & MYTEST_RX_EVENT)
  {    
    NumOfRx = NPI_RxBufLen();
    
    NPI_ReadTransport(RxBuf,NumOfRx);
    
    osal_set_event(Mytest_TaskID,MYTEST_TX_EVENT);
    
    return events ^ MYTEST_RX_EVENT;
  }
    
  return 0;
}

