#include "hal_net.h"
#include "hal_spi.h"
#include "uip.h"
#include "hal_drivers.h"
#include "OSAL.h"
#include "uip_arp.h"
XDATA uint8 Enc28j60Bank;
XDATA uint16 NextPacketPtr;
XDATA uint8 arptimer;
#define  BUF ((struct uip_eth_hdr *)&uip_buf[0])
void delay_100ns()
{
     asm("nop");
     asm("nop");
     asm("nop");
     asm("nop");
}

void delay_ms(int t1)
{
     int i;
     while(t1--)
     {
	for(i=10;i;--i)
        {
           delay_100ns();
        }
     }
}

//*******************************************************************************************
//
// Function : enc28j60ReadOp
// Description :
//
//*******************************************************************************************
uint8 enc28j60ReadOp(uint8 op, uint8 address)
{
    uint8 dat1;
    // activate CS	
    CSN =0;
    // issue read command
    delay_100ns();
    WriteByte(op | (address & ADDR_MASK));	
    dat1 = ReadByte();
    // do dummy read if needed (for mac and mii, see datasheet page 29)
    if(address & 0x80) 	dat1 = ReadByte();
    // release CS
    CSN=1;
    return(dat1);
}
//*******************************************************************************************
//
// Function : enc28j60WriteOp
// Description :
//
//*******************************************************************************************
void enc28j60WriteOp(uint8 op, uint8 address, uint8 mydat)
{
    CSN=0;
    // issue write command
    delay_100ns();
    WriteByte( op | (address & ADDR_MASK));
    // write data
    WriteByte(mydat);
    CSN=1;
    delay_100ns();
}
//*******************************************************************************************
//
// Function : icmp_send_request
// Description : Send ARP request packet to destination.
//
//*******************************************************************************************
void enc28j60SetBank(uint8 address)
{
    // set the bank (if needed)
    if((address & BANK_MASK) != Enc28j60Bank)
    {
        // set the bank
        enc28j60WriteOp(ENC28J60_BIT_FIELD_CLR, ECON1, (ECON1_BSEL1|ECON1_BSEL0));
        enc28j60WriteOp(ENC28J60_BIT_FIELD_SET, ECON1, (address & BANK_MASK)>>5);
        Enc28j60Bank = (address & BANK_MASK);
    }
}
//*******************************************************************************************
//
// Function : icmp_send_request
// Description : Send ARP request packet to destination.
//
//*******************************************************************************************
uint8 enc28j60Read(uint8 address)
{
    // select bank to read
    enc28j60SetBank(address);	
    // do the read
    return enc28j60ReadOp(ENC28J60_READ_CTRL_REG, address);
}
//*******************************************************************************************
//
// Function : icmp_send_request
// Description : Send ARP request packet to destination.
//
//*******************************************************************************************
void enc28j60Write(uint8 address, uint8 mydat)
{
    // select bank to write
    enc28j60SetBank(address);
    // do the write
    enc28j60WriteOp(ENC28J60_WRITE_CTRL_REG, address, mydat);
}
//*******************************************************************************************
//
// Function : icmp_send_request
// Description : Send ARP request packet to destination.
//
//*******************************************************************************************
uint16 enc28j60_read_phyreg(uint8 address)
{
    uint16 mydat;
    // set the PHY register address
    enc28j60Write(MIREGADR, address);
    enc28j60Write(MICMD, MICMD_MIIRD);
    // Loop to wait until the PHY register has been read through the MII
    // This requires 10.24us
    while( (enc28j60Read(MISTAT) & MISTAT_BUSY) );

    // Stop reading Ӧ
    //enc28j60Write(MICMD, MICMD_MIIRD);
    enc28j60Write(MICMD, 0x0);
    // Obtain results and return
    mydat = enc28j60Read ( MIRDL );
    //PrintHex(mydat);
    //mydat |= enc28j60Read ( MIRDH ); //˵طԴ ĳ
    mydat |= (enc28j60Read ( MIRDH )<<8);
   // PrintHex(mydat);
    return mydat;
}
//*******************************************************************************************
//
// Function : icmp_send_request
// Description : Send ARP request packet to destination.
//
//*******************************************************************************************
void enc28j60PhyWrite(uint8 address, uint16 mydat)
{
	// set the PHY register address
    enc28j60Write(MIREGADR, address);
    // write the PHY data
    enc28j60Write(MIWRL, mydat & 0x00ff);
    enc28j60Write(MIWRH, mydat >> 8);
    // wait until the PHY write completes
    while(enc28j60Read(MISTAT) & MISTAT_BUSY);
}

void enc28j60ReadBuffer(uint16 len, uint8* dat)
{
    // assert CS
    CSN = 0;
    // issue read command
    delay_100ns();
    WriteByte(ENC28J60_READ_BUF_MEM);
    while(len--)
    {
       *dat++ = ReadByte();
    }	
    // release CS
    CSN = 1;
}

void enc28j60WriteBuffer(uint16 len, uint8* dat)
{
    // assert CS
    CSN = 0;
    // issue write command
    WriteByte(ENC28J60_WRITE_BUF_MEM);
    // while(!(SPSR & (1<<SPIF)));
    while(len--)
    {
       WriteByte(*dat++);
    }	
    // release CS
    CSN = 1;
}

#define ETHERNET_MIN_PACKET_LENGTH	0x3C
#define ETHERNET_HEADER_LENGTH		0x0E
#define IP_TCP_HEADER_LENGTH 40
#define TOTAL_HEADER_LENGTH (IP_TCP_HEADER_LENGTH+ETHERNET_HEADER_LENGTH)

void enc28j60PacketSend(uint16 len, uint8* packet)
{
    // Set the write pointer to start of transmit buffer area
    enc28j60Write(EWRPTL, TXSTART_INIT&0xff);
    enc28j60Write(EWRPTH, TXSTART_INIT>>8);
    // Set the TXND pointer to correspond to the packet size given
    enc28j60Write(ETXNDL, (TXSTART_INIT+len)&0xff);
    enc28j60Write(ETXNDH, (TXSTART_INIT+len)>>8);
    // write per-packet control byte
    enc28j60WriteOp(ENC28J60_WRITE_BUF_MEM, 0, 0x00);
    // TODO, fix this up
    if( uip_len <= TOTAL_HEADER_LENGTH )
    {
        // copy the packet into the transmit buffer
        enc28j60WriteBuffer(len, packet);
    }
    else
    {
        len -= TOTAL_HEADER_LENGTH;
        enc28j60WriteBuffer(TOTAL_HEADER_LENGTH, packet);
        enc28j60WriteBuffer(len, (unsigned char *)uip_appdata);
    }
    // send the contents of the transmit buffer onto the network
    enc28j60WriteOp(ENC28J60_BIT_FIELD_SET, ECON1, ECON1_TXRTS);
}

uint16 enc28j60PacketReceive(uint16 maxlen, uint8* packet)
{
    uint16 rxstat,len;
    if( !(enc28j60Read(EIR) & EIR_PKTIF) )
    {
      if (enc28j60Read(EPKTCNT) == 0)
      {
      return 0;
      }
    }
// Set the read pointer to the start of the received packet
    enc28j60Write(ERDPTL, (NextPacketPtr));
    enc28j60Write(ERDPTH, (NextPacketPtr)>>8);
// read the next packet pointer
    NextPacketPtr  = enc28j60ReadOp(ENC28J60_READ_BUF_MEM, 0);
    NextPacketPtr |= (enc28j60ReadOp(ENC28J60_READ_BUF_MEM, 0)<<8);
// read the packet length
    len  = enc28j60ReadOp(ENC28J60_READ_BUF_MEM, 0);
    len |= (enc28j60ReadOp(ENC28J60_READ_BUF_MEM, 0)<<8);
    len -= 4; //̫֡С46ֽ ȥ4ֽڵFCSУ ֡ͷ14ֽ 64ֽ
 //PrintHex(len);
// read the receive status
    rxstat  = enc28j60ReadOp(ENC28J60_READ_BUF_MEM, 0);
    rxstat |= enc28j60ReadOp(ENC28J60_READ_BUF_MEM, 0)<<8;
// limit retrieve length
    // (we reduce the MAC-reported length by 4 to remove the CRC)
    //PrintHex(len);
    len = MIN(len, maxlen);

// copy the packet from the receive buffer
    enc28j60ReadBuffer(len, packet);
// Errata workaround #13. Make sure ERXRDPT is odd
    uint16 rs,re;
    rs = enc28j60Read(ERXSTH);
    rs <<= 8;
    rs |= enc28j60Read(ERXSTL);
    re = enc28j60Read(ERXNDH);
    re <<= 8;
    re |= enc28j60Read(ERXNDL);
    if (NextPacketPtr - 1 < rs || NextPacketPtr - 1 > re)
    {
        enc28j60Write(ERXRDPTL, (re));
        enc28j60Write(ERXRDPTH, (re)>>8);
    }
    else
    {
        enc28j60Write(ERXRDPTL, (NextPacketPtr-1));
        enc28j60Write(ERXRDPTH, (NextPacketPtr-1)>>8);
    }
// decrement the packet counter indicate we are done with this packet
    enc28j60WriteOp(ENC28J60_BIT_FIELD_SET, ECON2, ECON2_PKTDEC);
    return len;
}

void HalNetInit(void)
{
    enc28j60_init();
}

void dev_send(void)
{
    enc28j60PacketSend(uip_len, uip_buf);
}

uint16 dev_poll(void)
{
    return enc28j60PacketReceive(UIP_BUFSIZE, uip_buf);
}

void enc28j60_init(void)
{
//SPI INIT
    //HalSpiInit();//HalDriverInit()н˳ʼ
// perform system reset
    enc28j60WriteOp(ENC28J60_SOFT_RESET, 0, ENC28J60_SOFT_RESET);

// check CLKRDY bit to see if reset is complete
    //while(!(enc28j60Read(ESTAT) & ESTAT_CLKRDY));
    // Errata workaround #2, CLKRDY check is unreliable, delay 1 mS instead
    delay_ms(5);
// lamp test
// enc28j60PhyWrite(PHLCON, 0x0AA2);

// do bank 0 stuff
    // initialize receive buffer
    // 16-bit transfers, must write low byte first
// set receive buffer start address
    NextPacketPtr = RXSTART_INIT;
    enc28j60Write(ERXSTL, RXSTART_INIT&0xFF);
    enc28j60Write(ERXSTH, RXSTART_INIT>>8);
// set receive pointer address
    enc28j60Write(ERXRDPTL, RXSTART_INIT&0xFF);
    enc28j60Write(ERXRDPTH, RXSTART_INIT>>8);
// set receive buffer end
    // ERXND defaults to 0x1FFF (end of ram)
    enc28j60Write(ERXNDL, RXSTOP_INIT&0xFF);
    enc28j60Write(ERXNDH, RXSTOP_INIT>>8);
// set transmit buffer start
   // uint8 data1;
   //data1 = enc28j60Read(ERXNDL);
   //PrintHex(data1);
    // ETXST defaults to 0x0000 (beginnging of ram)
    enc28j60Write(ETXSTL, TXSTART_INIT&0xFF);
    enc28j60Write(ETXSTH, TXSTART_INIT>>8);
// do bank 2 stuff
    // enable MAC receive
    enc28j60Write(MACON1, MACON1_MARXEN|MACON1_TXPAUS|MACON1_RXPAUS);
// bring MAC out of reset
    enc28j60Write(MACON2, 0x00);
// enable automatic padding and CRC operations
    enc28j60WriteOp(ENC28J60_BIT_FIELD_SET, MACON3, MACON3_PADCFG0|MACON3_TXCRCEN|MACON3_FRMLNEN);
// enc28j60Write(MACON3, MACON3_PADCFG0|MACON3_TXCRCEN|MACON3_FRMLNEN);
    // set inter-frame gap (non-back-to-back)
    enc28j60Write(MAIPGL, 0x12);
    enc28j60Write(MAIPGH, 0x0C);
// set inter-frame gap (back-to-back)
    enc28j60Write(MABBIPG, 0x12);
// Set the maximum packet size which the controller will accept
    enc28j60Write(MAMXFLL, MAX_FRAMELEN&0xFF);	
    enc28j60Write(MAMXFLH, MAX_FRAMELEN>>8);
// do bank 3 stuff
    // write MAC address
    // NOTE: MAC address in ENC28J60 is byte-backward
    enc28j60Write(MAADR5, UIP_ETHADDR0);
    enc28j60Write(MAADR4, UIP_ETHADDR1);
    enc28j60Write(MAADR3, UIP_ETHADDR2);
    enc28j60Write(MAADR2, UIP_ETHADDR3);
    enc28j60Write(MAADR1, UIP_ETHADDR4);
    enc28j60Write(MAADR0, UIP_ETHADDR5);
// no loopback of transmitted frames
    enc28j60PhyWrite(PHCON2, PHCON2_HDLDIS);
// switch to bank 0
    enc28j60SetBank(ECON1);
// enable interrutps
    enc28j60WriteOp(ENC28J60_BIT_FIELD_SET, EIE, EIE_INTIE|EIE_PKTIE);
// enable packet reception
    enc28j60WriteOp(ENC28J60_BIT_FIELD_SET, ECON1, ECON1_RXEN);
}

void HalNetDataPoll()
{
    uint8 i;
    uint16 j;
    uip_len = dev_poll();
    for(j=0;j<500;j++);
    if(uip_len==0)
    {
      for(i = 0; i < UIP_CONNS; i++)
      {
	uip_periodic(i);
        if(uip_len>0)
        {
          uip_arp_out();
          dev_send();
        }
      }
      if(++arptimer == 20)
      {
        uip_arp_timer();
        arptimer = 0;
      }
    }
    else
    {
      if(BUF->type == htons(UIP_ETHTYPE_IP))
      {
        uip_arp_ipin();
        uip_input();
        if(uip_len > 0)
        {
          uip_arp_out();
          dev_send();
        }
      }
      else if(BUF->type == htons(UIP_ETHTYPE_ARP))
      {
        uip_arp_arpin();
        if(uip_len>0)
        {
          dev_send();
        }
      }
    }
}
