/*******************************************************************************
writer ：on the way..

Port   ：P0_2,P0_3,P0_4,P0_5    这四个端口是用于UART0外设配置
         P1_0，P1_1            这两个端口是LED1和LED2
         P1_4,P1_5,P1_6,P1_7    这四个端口用于SPI通信
fuction：SPI通信-中断方式接收数据

*******************************************************************************/
/*--------------------------------------------------------------------------------
    Master                 Slave
-------------          -------------
|           |          |           |
|P1_4   SSN |--------->|SSN    P1_4|
|           |          |           |
|P1_5   SCK |--------->|SCK    P1_5|
|           |          |           |
|P1_6   MOSI|--------->|MOSI   P1_6|
|           |          |           |
|P1_7   MISO|<---------|MISO   P1_7|
|           |          |           |
-------------          -------------
--------------------------------------------------------------------------------*/
// Slave Mode

#include <iocc2530.h>
//#include "hal_cc8051.h"
#include "hal_uart.h"
#include "hal_spi.h"

#define SSN    P1_4
#define LOW    0
#define HIGH   1

void init_port(void)
{
   //IO_FUNC_PORT_PIN(1, 0, IO_FUNC_GIO);    //P1_0ΪͨIO
   //IO_DIR_PORT_PIN(1, 0, IO_OUT);          //Ϊ

   //IO_FUNC_PORT_PIN(1, 1, IO_FUNC_GIO);    //P1_1ΪͨIO
   //IO_DIR_PORT_PIN(1, 1, IO_OUT);          //Ϊ

   PERCFG |= 0x02;        // PERCFG.U1CFG = 1
   P1SEL |= 0xE0;         // P1_7, P1_6, and P1_5 are peripherals
   P1SEL &= ~0x10;        // P1_4 is GPIO (SSN)
   P1DIR |= 0x10;         // SSN is set as output
}

void init_Baudrate(void)
{
  // Set baud rate to max (system clock frequency / 8)
  // Assuming a 26 MHz crystal (CC1110Fx/CC2510Fx),
  // max baud rate = 26 MHz / 8 = 3.25 MHz.
  U1BAUD = 0x00;   // BAUD_M = 0
  U1GCR |= 0x11;   // BAUD_E = 17
}

void hal_spi_init(void)
{
  init_port();      //ʼ˿
  init_Baudrate();  //ʼ

  // SPI Master Mode
  U1CSR &= ~0xA0;   //ѡΪSPIΪMaster

  // Configure phase, polarity, and bit order
  U1GCR &= ~0xC0;      // CPOL = CPHA = 0
  U1GCR |= 0x20;       // ORDER = 1
}

void WriteByte( uint8 data )
{
  SSN = LOW;
  U1DBUF = data; //Ҫ͵
  while (!U1TX_BYTE);
  SSN = HIGH;
  U1TX_BYTE = 0;
}

uint8 ReadByte( void )
{
  uint8 data = 0;
  SSN = LOW;
  U1DBUF = 0xFF; //Ҫ͵
  while (!U1TX_BYTE);
  data = U1DBUF;
  SSN = HIGH;
  U1TX_BYTE = 0;
  return data;
}
