//*****************************************************************************
//
// Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/
//
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//    Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//
//    Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the
//    distribution.
//
//    Neither the name of Texas Instruments Incorporated nor the names of
//    its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
//  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
//  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
//  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
//  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************

#ifndef __UART_CLI_H__
#define __UART_CLI_H__

#include <string.h>
#include <stdlib.h>
#include <stdio.h>


//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef  __cplusplus
extern "C" {
#endif

//
// Define teh size of UART IF buffer for RX
//
#define UART_IF_BUFFER           64
#define UART_RX_DATA_SIZE 2 //2Bytes
#define UART_RX_CHECKSUM_SIZE 1 //1Byte
#define UART_RX_OPCODE_SIZE 1 //1Byte

typedef enum
{
    OK_CODE             = 0x00,
    BAD_COM_CHKSUM_CODE = 0xF1,
    UNKNOWN_OPCODE_CODE = 0xF2,
    INVALID_PARAM_CODE  = 0xF3
}RadioErrorCode_e;


//
// Define the UART IF buffer
//
extern unsigned char g_ucUARTBuffer[];



/****************************************************************************/
/*                              MACROS                                      */
/****************************************************************************/
#define UART_BAUD_RATE  115200
#define SYSCLK          80000000
#define CONSOLE         UARTA0_BASE
#define CONSOLE_PERIPH  PRCM_UARTA0

/****************************************************************************/
/*                    FUNCTION PROTOTYPES                       */
/****************************************************************************/
void DispatcherUARTConfigure(void);
void DispatcherUartSendPacket(unsigned char *inBuff, unsigned short usLength);
unsigned int GETCmd(unsigned char *ucBuffer);

void ClearTerm(void);

void Error(char *format,...);


#define CLI_Write(x) Report(x)

int GetPacket(unsigned char *pucData, unsigned long *pucSize);
int SendPacket(unsigned char *pucData, unsigned long ucSize);
int AckPacket();
unsigned char CheckSum(unsigned char *pucData, unsigned long ucSize);
//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef  __cplusplus
}
#endif // __cplusplus

#endif // __UART_CLI_H__
