/*
 *
 *   Copyright (C) 2016 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission of
 *   Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been supplied,
 *   and under no circumstances can it be used with non-TI connectivity device.
 *
 */

#ifndef __SIMPLE_LINK_STUDIO__
#define __SIMPLE_LINK_STUDIO__

#ifdef  __cplusplus
extern "C" {
#endif

/* Minimum Visual Studio Version - 2015 (_MSC_VER==1900) */
#if defined (_MSC_VER) && (_MSC_VER < 1900)
#error "Visual Studio 2015 or above is required."
#endif

// used for polling mode system
#define SL_POLLING_MODE_USED
#define SL_STUDIO_VER  "0.0.4.18" //versions 4.10 supports UART, 4.14 - removed prints

typedef short (*SL_P_EVENT_HANDLER)(void* pValue);

int SlStudio_RegisterInterruptHandler(SL_P_EVENT_HANDLER InterruptHdl , void* pValue);

int SlStudio_DisableDevice();

int SlStudio_EnableDevice();

char* SlStudio_GetVer();

int VerifyTimerFrequency(unsigned int FreqConfigured);

// SPI interface
typedef int* SpiHandle_t;

SpiHandle_t SlStudio_SpiOpen(char *ifName, unsigned long flags);

int SlStudio_SpiClose(SpiHandle_t hdl);

int SlStudio_SpiRead(SpiHandle_t hdl, unsigned char *pBuff, int len);

int SlStudio_SpiWrite(SpiHandle_t hdl, unsigned char *pBuff, int len);

int SlStudio_SpiStartWriteSeq(SpiHandle_t hdl);

int SlStudio_SpiEndWriteSeq(SpiHandle_t hdl);

void SlStudio_SpiIRQMask();

void SlStudio_SpiIRQUnMask();


// UART Interface
typedef void* UartHandle_t;

#define UART_IF_OPEN_FLAG_NONE    0
#define UART_IF_OPEN_FLAG_RE_OPEN 1

typedef struct
{
    unsigned int BaudRate;
    unsigned char FlowControlEnable;
    unsigned char CommPort;

} SlStudioUartIfParams_t;

UartHandle_t SlStudio_UartOpen(char *ifName, unsigned long flags);

int SlStudio_UartClose(void* hdl);

int SlStudio_UartWrite(void* hdl, unsigned char* pBuffer, unsigned int BytesToWrite);

int SlStudio_UartRead(void* hdl, unsigned char* pBuffer, unsigned int BytesToRead);

void SlStudio_UartIRQMask();

void SlStudio_UartIRQUnMask();

#ifdef  __cplusplus
}
#endif // __cplusplus


#endif //__SPI_H__

