/*
 *
 *   Copyright (C) 2016 Texas Instruments Incorporated
 *
 *   All rights reserved. Property of Texas Instruments Incorporated.
 *   Restricted rights to use, duplicate or disclose this code are
 *   granted through contract.
 *
 *   The program may not be used without the written permission of
 *   Texas Instruments Incorporated or against the terms and conditions
 *   stipulated in the agreement under which this program has been supplied,
 *   and under no circumstances can it be used with non-TI connectivity device.
 *
 */

#include "stdafx.h"
#include <windows.h>

UCHAR g_ucBuffer[4096];

/* */
RTAPI RadioToolOpen(unsigned char comPort, unsigned long baudRate)
{
	return OpenUART(comPort, baudRate);
}

/* */
RTAPI RadioToolClose()
{
	return CloseUART();
}

/* */
RTAPI RadioStopTX(RadioTxMode_e eTxMode)
{	
	g_ucBuffer[0] = (unsigned char) (TX_STOP_COMMAND_OP);

	if(SendPacket(g_ucBuffer, 1))
	{
		return RADIO_TOOL_ERROR_DELIVER_TX_STOP;
	}

	return 0;
}

/* */
RTAPI RadioStartTX(RadioTxMode_e eTxMode,
	INT8                ePowerLevel_Tone,
	UINT8               eChannel,
	SlWlanRateIndex_e   eRate,
	UINT8               ePreamble,
	RadioDataPattern_e  eDataPattern,
	UINT16              eSize,
	UINT32              eDelay,
	UINT32              eAmount,
	UINT8               eOverrideCCA,
	SlTxInhibitThreshold_e eCCAThreshold,
	UINT8               eEnableACKs,
    UINT8               *epDstMac)
{	
	/* generate TX start command packet  */
	UINT32 index = 0;
	g_ucBuffer[index++] = (UINT8)(TX_START_COMMAND_OP);
	g_ucBuffer[index++] = (UINT8)(eTxMode);
	g_ucBuffer[index++] = (UINT8)(ePowerLevel_Tone);
	g_ucBuffer[index++] = (UINT8)(eChannel);
	g_ucBuffer[index++] = (UINT8)(eRate);
	g_ucBuffer[index++] = (UINT8)(ePreamble);
	g_ucBuffer[index++] = (UINT8)(eDataPattern);

	g_ucBuffer[index++] = (UINT8)(eSize>>8);
	g_ucBuffer[index++] = (UINT8)(eSize);

	g_ucBuffer[index++] = (UINT8)(eDelay>>24);
	g_ucBuffer[index++] = (UINT8)(eDelay>>16);
	g_ucBuffer[index++] = (UINT8)(eDelay>>8);
	g_ucBuffer[index++] = (UINT8)(eDelay);

	g_ucBuffer[index++] = (UINT8)(eAmount>>24);
	g_ucBuffer[index++] = (UINT8)(eAmount>>16);
	g_ucBuffer[index++] = (UINT8)(eAmount>>8);
	g_ucBuffer[index++] = (UINT8)(eAmount);

	g_ucBuffer[index++] = (UINT8)(eOverrideCCA);

	g_ucBuffer[index++] = (UINT8)(eCCAThreshold);

	g_ucBuffer[index++] = (UINT8)(eEnableACKs);

	g_ucBuffer[index++] = (UINT8)(epDstMac[SL_BSSID_LENGTH-1]);
	g_ucBuffer[index++] = (UINT8)(epDstMac[SL_BSSID_LENGTH-2]);
	g_ucBuffer[index++] = (UINT8)(epDstMac[SL_BSSID_LENGTH-3]);
	g_ucBuffer[index++] = (UINT8)(epDstMac[SL_BSSID_LENGTH-4]);
	g_ucBuffer[index++] = (UINT8)(epDstMac[SL_BSSID_LENGTH-5]);
	g_ucBuffer[index++] = (UINT8)(epDstMac[SL_BSSID_LENGTH-6]);

	if(SendPacket(g_ucBuffer, index))
	{
		return RADIO_TOOL_ERROR_DELIVER_TX_START;
	}

	return 0;
}

/* */
RTAPI RadioStopRX ()
{
	g_ucBuffer[0] = (unsigned char)(RX_STOP_COMMAND_OP);
	
	if(SendPacket(g_ucBuffer, 1))
	{
		return RADIO_TOOL_ERROR_DELIVER_RX_STOP;
	}

	return 0;
}

/* */
RTAPI RadioStartRX(UINT8 eChannel)
{
	g_ucBuffer[0] = (unsigned char)(RX_START_COMMAND_OP);
	g_ucBuffer[1] = (unsigned char)(eChannel);

	if(SendPacket(g_ucBuffer, 2))
	{
		return RADIO_TOOL_ERROR_DELIVER_RX_START;
	}

	return 0;
}

/* */
RTAPI RadioGetStats(UINT8 *stats)
{
	ULONG rxStatRespSize = 0;

	g_ucBuffer[0] = (unsigned char)(RX_GET_STATS_COMMAND_OP);
	if(SendPacket(g_ucBuffer, 1))
	{
		return RADIO_TOOL_ERROR_DELIVER_RX_GET_STATS;
	}

	Sleep(100);

	GetPacket(g_ucBuffer, &rxStatRespSize);
	if(g_ucBuffer[0] != RX_GET_STATS_RESPONSE_OP)
	{
		return RADIO_TOOL_ERROR_OPCODE_RX_GET_STATS;
	}

	if(g_ucBuffer[1] != OK_CODE)
	{
		return RADIO_TOOL_ERROR_RX_GET_STATS;
	}

	memcpy(stats, &g_ucBuffer[2], sizeof(SlWlanGetRxStatResponse_t));
	return 0;
}

/* */
RTAPI RadioGetMacAddr(UINT8 *pMacAddress)
{
	ULONG macStatRespSize = 0;

	g_ucBuffer[0] = (unsigned char)(GET_MAC_ADDR_COMMAND_OP);
	if(SendPacket(g_ucBuffer, 1))
	{
		return RADIO_TOOL_ERROR_DELIVER_GET_MAC_ADDR;
	}

	Sleep(100);

	GetPacket(g_ucBuffer,&macStatRespSize);
	if(g_ucBuffer[0] != GET_MAC_ADDR_RESPONSE_OP)
	{
		return RADIO_TOOL_ERROR_OPCODE_GET_MAC_ADDR;
	}

	if(g_ucBuffer[1] != OK_CODE)
	{
		return RADIO_TOOL_ERROR_GET_MAC_ADDR;
	}
	
	memcpy(pMacAddress, &g_ucBuffer[2], SL_BSSID_LENGTH);
	return 0;		
}

/* */
RTAPI RadioGetDeviceVersion(UINT8 *pDevVersion, UINT16 *pHDLength, UINT8 *pHDVersion)
{
	ULONG verStatRespSize = 0;
	UINT32 hd_version_length = sizeof(SlDeviceVersion_t) + 2; //accounting for CC3220 application version
	
	g_ucBuffer[0] = (unsigned char)(GET_DEV_VER_COMMAND_OP);
	if(SendPacket(g_ucBuffer, 1))
	{
		return RADIO_TOOL_ERROR_DELIVER_GET_DEV_VER;
	}

	Sleep(100);

	GetPacket(g_ucBuffer,&verStatRespSize);
	if(g_ucBuffer[0] != GET_DEV_VER_RESPONSE_OP)
	{
		return RADIO_TOOL_ERROR_OPCODE_GET_DEV_VER;
	}

	if(g_ucBuffer[1] != OK_CODE)
	{
		return RADIO_TOOL_ERROR_GET_DEV_VER;
	}
	
	memcpy(pDevVersion, &g_ucBuffer[2], hd_version_length);
	*pHDLength = (((UINT16) g_ucBuffer[hd_version_length + 3]) << 8) | g_ucBuffer[hd_version_length + 2];
	memcpy(pHDVersion, &g_ucBuffer[hd_version_length + 4], *pHDLength);
	
	return 0;
}
