/*
 *
 * Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef __SerialFlashOperations_h__
#define	__SerialFlashOperations_h__

#include "winsock2.h"
#include <atlstr.h>

//Generic definitions
#define ERROR_BUFFER_SIZE 100

//Generic definitions
#define BUFFER_SIZE 100

#define TRACE_LEVEL_ERROR        1
#define TRACE_LEVEL_ACTIVITY     2
#define TRACE_LEVEL_INFO         3
#define TRACE_LEVEL_DEBUG        4

#define TRACE_LEVEL				 4

#define RESET_TRACE_LEVEL(x)	(TRACE_LEVEL = x)

int OpenUART(unsigned char ucComPort, unsigned long ulBaudRate);

void _trace_msg(UINT16 level, char * pcMessage);
int CloseUART(void);
int AutoBaud(void);
int Ping(void);
int SendCommand(unsigned char *pucCommand, unsigned long ucSize);
int SendPacket(unsigned char *pucData, unsigned long ucSize);
int GetPacket(unsigned char *pucData, unsigned long *pucSize);
unsigned char CheckSum(unsigned char *pucData, unsigned long ucSize);
int AckPacket(void);
int NakPacket(void);
int UpdateFlash(unsigned char * pucDataBuffer, unsigned long ulSize, unsigned long ulAddress, unsigned long ulXferSize, int iDeviceId, int iFileId, bool isFileMirrored);
int UARTSendData(unsigned char const *pucData, unsigned long ucSize);
int UARTReceiveData(unsigned char *pucData, unsigned long ucSize);
int SendBreakSignal();
int Disconnect();
int DeviceErase(int iDeviceId, int iStorageBaseAddress, int iEraseSize);
unsigned char GetStorageExistLst();


void DoEvents(void);
int ResetCmd(void);


#endif