﻿/*
 *
 * Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace RadioToolCLI
{
    internal class LibraryImport
    {
        internal delegate Int32 _RadioToolOpen([MarshalAs(UnmanagedType.U1)] Byte comPort, [MarshalAs(UnmanagedType.U8)] UInt64 baudRate);
        internal delegate Int32 _RadioToolClose();
        internal delegate Int32 _RadioStartTX(
            RadioTxMode_e eTxMode,
            SByte ePowerLevel_Tone,
            Byte eChannel,
            RateIndex_e eRate,
            Byte ePreamble,
            RadioDataPattern_e eDataPattern,
            UInt16 eSize,
            UInt32 eDelay,
            UInt32 eAmount,
            Byte eOverrideCCA,
            RadioCCAThreshold_e eCCAThreshold,
            Byte eEnableACKs,
            [In, Out] Byte[] epDstMac);
        internal delegate Int32 _RadioStopTX(RadioTxMode_e eTxMode);
        internal delegate Int32 _RadioStartRX(Byte eChannel);
        internal delegate Int32 _RadioStopRX();
        internal delegate Int32 _RadioGetStats([In, Out] Byte[] stats);
        internal delegate Int32 _RadioGetMacAddr([In, Out] Byte[] pMacAddress);
        internal delegate Int32 _RadioGetDeviceVersion([In, Out] Byte[] pDevVersion, [In, Out] ref UInt16 pHDLength, [In, Out] Byte[] pHDVersion);

        internal static _RadioToolOpen RadioToolOpen;
        internal static _RadioToolClose RadioToolClose;
        internal static _RadioStartTX RadioStartTX;
        internal static _RadioStopTX RadioStopTX;
        internal static _RadioStartRX RadioStartRX;
        internal static _RadioStopRX RadioStopRX;
        internal static _RadioGetStats RadioGetStats;
        internal static _RadioGetMacAddr RadioGetMacAddr;
        internal static _RadioGetDeviceVersion RadioGetDeviceVersion;
    }

    internal class CC3120SPILibrary
    {
        [DllImport("CC3120LibSPI.dll", EntryPoint = "RadioToolOpen", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioToolOpen([MarshalAs(UnmanagedType.U1)] Byte comPort,
                                                    [MarshalAs(UnmanagedType.U8)] UInt64 baudRate);

        [DllImport("CC3120LibSPI.dll", EntryPoint = "RadioToolClose", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioToolClose();

        [DllImport("CC3120LibSPI.dll", EntryPoint = "RadioStartTX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStartTX(
            RadioTxMode_e eTxMode,
            SByte ePowerLevel_Tone,
            Byte eChannel,
            RateIndex_e eRate,
            Byte ePreamble,
            RadioDataPattern_e eDataPattern,
            UInt16 eSize,
            UInt32 eDelay,
            UInt32 eAmount,
            Byte eOverrideCCA,
            RadioCCAThreshold_e eCCAThreshold,
            Byte eEnableACKs,
            [In, Out] Byte[] epDstMac);

        [DllImport("CC3120LibSPI.dll", EntryPoint = "RadioStopTX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStopTX(RadioTxMode_e eTxMode);

        [DllImport("CC3120LibSPI.dll", EntryPoint = "RadioStartRX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStartRX(Byte eChannel);

        [DllImport("CC3120LibSPI.dll", EntryPoint = "RadioStopRX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStopRX();

        [DllImport("CC3120LibSPI.dll", EntryPoint = "RadioGetStats", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioGetStats([In, Out] Byte[] stats);

        [DllImport("CC3120LibSPI.dll", EntryPoint = "RadioGetMacAddr", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioGetMacAddr([In, Out] Byte[] pMacAddress);

        [DllImport("CC3120LibSPI.dll", EntryPoint = "RadioGetDeviceVersion", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioGetDeviceVersion([In, Out] Byte[] pDevVersion, [In, Out] ref UInt16 pHDLength, [In, Out] Byte[] pHDVersion);
    }

    internal class CC3120UARTLibrary
    {
        [DllImport("CC3120LibUART.dll", EntryPoint = "RadioToolOpen", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioToolOpen([MarshalAs(UnmanagedType.U1)] Byte comPort,
                                                    [MarshalAs(UnmanagedType.U8)] UInt64 baudRate);

        [DllImport("CC3120LibUART.dll", EntryPoint = "RadioToolClose", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioToolClose();

        [DllImport("CC3120LibUART.dll", EntryPoint = "RadioStartTX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStartTX(
            RadioTxMode_e eTxMode,
            SByte ePowerLevel_Tone,
            Byte eChannel,
            RateIndex_e eRate,
            Byte ePreamble,
            RadioDataPattern_e eDataPattern,
            UInt16 eSize,
            UInt32 eDelay,
            UInt32 eAmount,
            Byte eOverrideCCA,
            RadioCCAThreshold_e eCCAThreshold,
            Byte eEnableACKs,
            [In, Out] Byte[] epDstMac);

        [DllImport("CC3120LibUART.dll", EntryPoint = "RadioStopTX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStopTX(RadioTxMode_e eTxMode);

        [DllImport("CC3120LibUART.dll", EntryPoint = "RadioStartRX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStartRX(Byte eChannel);

        [DllImport("CC3120LibUART.dll", EntryPoint = "RadioStopRX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStopRX();

        [DllImport("CC3120LibUART.dll", EntryPoint = "RadioGetStats", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioGetStats([In, Out] Byte[] stats);

        [DllImport("CC3120LibUART.dll", EntryPoint = "RadioGetMacAddr", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioGetMacAddr([In, Out] Byte[] pMacAddress);

        [DllImport("CC3120LibUART.dll", EntryPoint = "RadioGetDeviceVersion", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioGetDeviceVersion([In, Out] Byte[] pDevVersion, [In, Out] ref UInt16 pHDLength, [In, Out] Byte[] pHDVersion);
    }

    internal class CC3220Library
    {
        [DllImport("CC3220Lib.dll", EntryPoint = "RadioToolOpen", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioToolOpen([MarshalAs(UnmanagedType.U1)] Byte comPort,
                                                    [MarshalAs(UnmanagedType.U8)] UInt64 baudRate);

        [DllImport("CC3220Lib.dll", EntryPoint = "RadioToolClose", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioToolClose();

        [DllImport("CC3220Lib.dll", EntryPoint = "RadioStartTX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStartTX(
            RadioTxMode_e eTxMode,
            SByte ePowerLevel_Tone,
            Byte eChannel,
            RateIndex_e eRate,
            Byte ePreamble,
            RadioDataPattern_e eDataPattern,
            UInt16 eSize,
            UInt32 eDelay,
            UInt32 eAmount,
            Byte eOverrideCCA,
            RadioCCAThreshold_e eCCAThreshold,
            Byte eEnableACKs,
            [In, Out] Byte[] epDstMac);

        [DllImport("CC3220Lib.dll", EntryPoint = "RadioStopTX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStopTX(RadioTxMode_e eTxMode);

        [DllImport("CC3220Lib.dll", EntryPoint = "RadioStartRX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStartRX(Byte eChannel);

        [DllImport("CC3220Lib.dll", EntryPoint = "RadioStopRX", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioStopRX();

        [DllImport("CC3220Lib.dll", EntryPoint = "RadioGetStats", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioGetStats([In, Out] Byte[] stats);

        [DllImport("CC3220Lib.dll", EntryPoint = "RadioGetMacAddr", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioGetMacAddr([In, Out] Byte[] pMacAddress);

        [DllImport("CC3220Lib.dll", EntryPoint = "RadioGetDeviceVersion", CallingConvention = CallingConvention.Cdecl)]
        internal extern static Int32 RadioGetDeviceVersion([In, Out] Byte[] pDevVersion, [In, Out] ref UInt16 pHDLength, [In, Out] Byte[] pHDVersion);
    }
}
