﻿/*
 *
 * Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace RadioToolGUI
{
    public partial class frmRateGraph : Form
    {
        public frmRateGraph(Boolean displayAsPercentage, float[] dataPercentage, UInt16[] dataAmount)
        {
            InitializeComponent();

            if (displayAsPercentage)
            {
                this.Text = this.Text + " (Percentage)";

                m_chtRate.ChartAreas[0].AxisY.Title = "Percentage (%)";
                m_chtRate.Series["SeriesRate"].Points.Clear();
                m_chtRate.Series["SeriesRate"].Points.AddXY("1Mbps", dataPercentage[0]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("2Mbps", dataPercentage[1]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("5.5Mbps", dataPercentage[2]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("11Mbps", dataPercentage[3]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("6Mbps", dataPercentage[4]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("9Mbps", dataPercentage[5]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("12Mbps", dataPercentage[6]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("18bps", dataPercentage[7]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("24Mbps", dataPercentage[8]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("36Mbps", dataPercentage[9]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("48Mbps", dataPercentage[10]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("54Mbps", dataPercentage[11]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 0", dataPercentage[12]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 1", dataPercentage[13]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 2", dataPercentage[14]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 3", dataPercentage[15]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 4", dataPercentage[16]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 5", dataPercentage[17]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 6", dataPercentage[18]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 7", dataPercentage[19]);
            }
            else
            {
                this.Text = this.Text + " (Packet Amount)";

                m_chtRate.ChartAreas[0].AxisY.Title = "Packet Amount";
                m_chtRate.Series["SeriesRate"].Points.Clear();
                m_chtRate.Series["SeriesRate"].Points.AddXY("1Mbps", dataAmount[0]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("2Mbps", dataAmount[1]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("5.5Mbps", dataAmount[2]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("11Mbps", dataAmount[3]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("6Mbps", dataAmount[4]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("9Mbps", dataAmount[5]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("12Mbps", dataAmount[6]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("18bps", dataAmount[7]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("24Mbps", dataAmount[8]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("36Mbps", dataAmount[9]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("48Mbps", dataAmount[10]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("54Mbps", dataAmount[11]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 0", dataAmount[12]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 1", dataAmount[13]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 2", dataAmount[14]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 3", dataAmount[15]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 4", dataAmount[16]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 5", dataAmount[17]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 6", dataAmount[18]);
                m_chtRate.Series["SeriesRate"].Points.AddXY("MCS 7", dataAmount[19]);
            }
        }
    }
}
