﻿/*
 *
 * Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace RadioToolGUI
{
    public partial class frmRssiGraph : Form
    {
        public frmRssiGraph(Boolean displayAsPercentage, float[] dataPercentage, UInt16[] dataAmount)
        {
            InitializeComponent();

            if (displayAsPercentage)
            {
                this.Text = this.Text + " (Percentage)";

                m_chtRSSI.ChartAreas[0].AxisY.Title = "Percentage (%)";
                m_chtRSSI.Series["SeriesRSSI"].Points.Clear();
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("< -79dBm", dataPercentage[5]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("-72dBm to -79dBm", dataPercentage[4]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("-64dBm to -71dBm", dataPercentage[3]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("-56dBm to -63dBm", dataPercentage[2]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("-48dBm to -55dBm", dataPercentage[1]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("> -48dBm", dataPercentage[0]);
            }
            else
            {
                this.Text = this.Text + " (Packet Amount)";

                m_chtRSSI.ChartAreas[0].AxisY.Title = "Packet Amount";
                m_chtRSSI.Series["SeriesRSSI"].Points.Clear();
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("< -79dBm", dataAmount[5]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("-72dBm to -79dBm", dataAmount[4]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("-64dBm to -71dBm", dataAmount[3]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("-56dBm to -63dBm", dataAmount[2]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("-48dBm to -55dBm", dataAmount[1]);
                m_chtRSSI.Series["SeriesRSSI"].Points.AddXY("> -48dBm", dataAmount[0]);
            }
        }
    }
}
