/*
 * APIs to configure and communicate with ADS1256 ADC over SPI bus
 *
 * Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED

 */


enum ads1255_register_names {
	ADS1255_STATUS,
	ADS1255_MUX,
	ADS1255_ADCON,
	ADS1255_DRATE,
	ADS1255_IO,
	ADS1255_OFC0,
	ADS1255_OFC1,
	ADS1255_OFC2,
	ADS1255_FSC0,
	ADS1255_FSC1,
	ADS1255_FSC2,
};
enum ads1255_commands{
	ADS1255_WAKEUP=0,
	ADS1255_RDATA,
	ADS1255_RDATAC=3,
	ADS1255_SDATAC=0xf,
	ADS1255_RREG=0x10,
	ADS1255_WREG=0x50,
	ADS1255_SELFCAL=0xF0,
	ADS1255_SELFOCAL,
	ADS1255_SELFGCAL,
	ADS1255_SYSOCAL,
	ADS1255_SYSGCAL,
	ADS1255_SYNC=0xFC,
	ADS1255_STANDBY,
	ADS1255_RESET,
};

uint8_t ads1255_convert_drate_to_regval(int drate);
int ads1255_write_command(int fd, uint8_t cmd);
int ads1255_set_register(int fd, uint8_t reg_name, uint8_t reg_val);
void ads1255_read_data(int fd, uint32_t *rx_buf, int num_samples);
int ads1255_set_PGA_gain(int fd, int multiplier);
