/*
 * Functions specific to DLP method of spectroscopy 
 *
 * Copyright (c) 2014 Texas Instruments Inc - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */

#include <stdio.h>
#include <stdbool.h>

#define DEFAULT_ADC_SAMPLE_RATE_KSPS 30
#define MAX_ADC_READ_SAMPLES 64*1024-1

int init_dlpc350(void);
int dlpspectro_prep_scan_solution(FILE *sdf_fd, int num_bmp);
int dlpspectro_add_images_to_firmware(char *fw_filename, int num_images);
int dlpspectro_update_firmware(char *fw_filename);
int dlpspectro_load_images_for_streaming(int num_images, int first_img_idx);
int dlpspectro_stream_images(int spi_fd, int *p_num_patterns, unsigned int exp_time_us, int32_t **pp_mean_readings, FILE *sdf_fd);
int dlpspectro_scan_flash_images(int fd, int first_scan_img_idx, int ptn_count, int exp_time, int32_t **pp_mean_readings, FILE *sdf_fd);
int dlpspectro_setup_calib_scan(int fd);
int dlpspectro_setup_calib_scan_prgb(int fd);
int dlpspectro_compute_absorption_spectrum(FILE *calRefSpectFilePtr, FILE *inputSampleSpectFilePtr, FILE *abspSpeFilePtr, float threshold_factor);
int dlpspectro_find_peaks(FILE *absorp_spect_file, float peak_sel_divisor, float *peaks, float *peak_inds);
int dlpspectro_polyfit(double *x_peaks, double *l_peaks, double*x_to_l_coeffs);
int dlpspectro_compute_mean_readings(int32_t *p_raw_readings, int num_raw_readings, int expected_num_patterns);
int dlpspectro_compute_hadamard_readings(FILE *readings_fd,FILE *output_transformed_readings_fd);
int dlpspectro_test_read_adc_samples(int spi_fd, int num_samples, int32_t **pp_raw_readings);
int dlpspectro_generate_csv_sdf(int first_pixel, int last_pixel, int num_patterns, int csv_begin_number, int integration_time, FILE *sdf_fp, bool use_hadamard_patterns, bool split);
