
#ifndef API_H
#define API_H

typedef struct _rectangle
{
    unsigned short firstPixel;
    unsigned short firstLine;
    unsigned short pixelsPerLine;
    unsigned short linesPerFrame;
}rectangle;


int USB_Open(void);
bool USB_IsConnected();
int USB_Write();
int USB_Read();
int USB_Close();
int USB_Init();
int USB_Exit();


int DLP_SetInputSource(unsigned int source, unsigned int portWidth);
int DLP_GetInputSource(unsigned int *pSource, unsigned int *portWidth);
int DLP_SetPixelFormat(unsigned int format);
int DLP_GetPixelFormat(unsigned int *pFormat);
int DLP_SetPortClock(unsigned int clock);
int DLP_GetPortClock(unsigned int *pClock);
int DLP_SetDataChannelSwap(unsigned int port, unsigned int swap);
int DLP_GetDataChannelSwap(unsigned int *pPort, unsigned int *pSwap);
int DLP_SetFPD_Mode_Field(unsigned int PixelMappingMode, bool SwapPolarity, unsigned int FieldSignalSelect);
int DLP_GetFPD_Mode_Field(unsigned int *pPixelMappingMode, bool *pSwapPolarity, unsigned int *pFieldSignalSelect);
int DLP_SetPowerMode(bool);
int DLP_SetLongAxisImageFlip(bool);
bool DLP_GetLongAxisImageFlip();
int DLP_SetShortAxisImageFlip(bool);
bool DLP_GetShortAxisImageFlip();
int DLP_SetTPGSelect(unsigned int pattern);
int DLP_GetTPGSelect(unsigned int *pPattern);
int DLP_SetLEDPWMInvert(bool invert);
int DLP_GetLEDPWMInvert(bool *inverted);
int DLP_SetLedEnables(bool SeqCtrl, bool Red, bool Green, bool Blue);
int DLP_GetLedEnables(bool *pSeqCtrl, bool *pRed, bool *pGreen, bool *pBlue);
int DLP_GetVersion(unsigned int *pApp_ver, unsigned int *pAPI_ver, unsigned int *pSWConfig_ver, unsigned int *pSeqConfig_ver);
int DLP_SoftwareReset(void);
int DLP_GetStatus(unsigned char *pHWStatus, unsigned char *pSysStatus, unsigned char *pMainStatus);
int DLP_SetPWMEnable(unsigned int channel, bool Enable);
int DLP_GetPWMEnable(unsigned int channel, bool *pEnable);
int DLP_SetPWMConfig(unsigned int channel, unsigned int pulsePeriod, unsigned int dutyCycle);
int DLP_GetPWMConfig(unsigned int channel, unsigned int *pPulsePeriod, unsigned int *pDutyCycle);
int DLP_SetPWMCaptureConfig(unsigned int channel, bool enable, unsigned int sampleRate);
int DLP_GetPWMCaptureConfig(unsigned int channel, bool *pEnabled, unsigned int *pSampleRate);
int DLP_SetGPIOConfig(unsigned int pinNum, bool enAltFunc, bool altFunc1, bool dirOutput, bool outTypeOpenDrain, bool pinState);
int DLP_GetGPIOConfig(unsigned int pinNum, bool *pEnAltFunc, bool *pAltFunc1, bool *pDirOutput, bool *pOutTypeOpenDrain, bool *pState);
int DLP_GetLedCurrents(unsigned char *pRed, unsigned char *pGreen, unsigned char *pBlue);
int DLP_SetLedCurrents(unsigned char RedCurrent, unsigned char GreenCurrent, unsigned char BlueCurrent);
int DLP_SetDisplay(rectangle croppedArea, rectangle displayArea);
int DLP_GetDisplay(rectangle *pCroppedArea, rectangle *pDisplayArea);
int DLP_MemRead(unsigned int addr, unsigned int *readWord);
int DLP_MemWrite(unsigned int addr, unsigned int data);
int DLP_ValidatePatLutData(unsigned int *pStatus);
int DLP_SetPatternDisplayMode(bool external);
int DLP_GetPatternDisplayMode(bool *external);
int DLP_SetTrigOutConfig(unsigned int trigOutNum, bool invert, unsigned int rising, unsigned int falling);
int DLP_GetTrigOutConfig(unsigned int trigOutNum, bool *pInvert,unsigned int *pRising, unsigned int *pFalling);
int DLP_SetRedLEDStrobeDelay(unsigned char rising, unsigned char falling);
int DLP_SetGreenLEDStrobeDelay(unsigned char rising, unsigned char falling);
int DLP_SetBlueLEDStrobeDelay(unsigned char rising, unsigned char falling);
int DLP_GetRedLEDStrobeDelay(unsigned char *, unsigned char *);
int DLP_GetGreenLEDStrobeDelay(unsigned char *, unsigned char *);
int DLP_GetBlueLEDStrobeDelay(unsigned char *, unsigned char *);
int DLP_EnterProgrammingMode(void);
int DLP_ExitProgrammingMode(void);
int DLP_GetProgrammingMode(bool *ProgMode);
int DLP_GetFlashManID(unsigned short *manID);
int DLP_GetFlashDevID(unsigned long long *devID);
int DLP_GetBLStatus(unsigned char *BL_Status);
int DLP_SetFlashAddr(unsigned int Addr);
int DLP_FlashSectorErase(void);
int DLP_SetDownloadSize(unsigned int dataLen);
int DLP_DownloadData(unsigned char *pByteArray, unsigned int dataLen);
void DLP_WaitForFlashReady(void);
int DLP_SetFlashType(unsigned char Type);
int DLP_CalculateFlashChecksum(void);
int DLP_GetFlashChecksum(unsigned int*checksum);
int DLP_SetMode(bool SLmode);
int DLP_GetMode(bool *pMode);
int DLP_LoadSplash(unsigned int index);
int DLP_GetSplashIndex(unsigned int *pIndex);
int DLP_SetTPGColor(unsigned short redFG, unsigned short greenFG, unsigned short blueFG, unsigned short redBG, unsigned short greenBG, unsigned short blueBG);
int DLP_GetTPGColor(unsigned short *pRedFG, unsigned short *pGreenFG, unsigned short *pBlueFG, unsigned short *pRedBG, unsigned short *pGreenBG, unsigned short *pBlueBG);
int DLP_ClearPatLut(void);
int DLP_AddToPatLut(int TrigType, int PatNum,int BitDepth,int LEDSelect,bool InvertPat, bool InsertBlack,bool BufSwap, bool trigOutPrev);
int DLP_GetPatLutItem(int index, int *pTrigType, int *pPatNum,int *pBitDepth,int *pLEDSelect,bool *pInvertPat, bool *pInsertBlack,bool *pBufSwap, bool *pTrigOutPrev);
int DLP_SendPatLut(void);
int DLP_SendSplashLut(unsigned char *lutEntries, unsigned int numEntries);
int DLP_GetPatLut(int numEntries);
int DLP_GetSplashLut(unsigned char *pLut, int numEntries);
int DLP_SetPatternTriggerMode(bool);
int DLP_GetPatternTriggerMode(bool *);
int DLP_PatternDisplay(int Action);
int DLP_SetPatternConfig(unsigned int numLutEntries, bool repeat, unsigned int numPatsForTrigOut2, unsigned int numSplash);
int DLP_GetPatternConfig(unsigned int *pNumLutEntries, bool *pRepeat, unsigned int *pNumPatsForTrigOut2, unsigned int *pNumSplash);
int DLP_SetExposure_FramePeriod(unsigned int exposurePeriod, unsigned int framePeriod);
int DLP_GetExposure_FramePeriod(unsigned int *pExposure, unsigned int *pFramePeriod);
int DLP_SetTrigIn1Delay(unsigned int Delay);
int DLP_GetTrigIn1Delay(unsigned int *pDelay);
int DLP_SetInvertData(bool invert);
int DLP_PWMCaptureRead(unsigned int channel, unsigned int *pLowPeriod, unsigned int *pHighPeriod);
int DLP_SetGeneralPurposeClockOutFreq(unsigned int clkId, bool enable, unsigned int clkDivider);
int DLP_GetGeneralPurposeClockOutFreq(unsigned int clkId, bool *pEnabled, unsigned int *pClkDivider);
int DLP_MeasureSplashLoadTiming(unsigned int startIndex, unsigned int numSplash);
int DLP_ReadSplashLoadTiming(unsigned int *pTimingData);


#endif // API_H
