/**
 * \file  bl.h
 *
 * \brief This file defines boot macros and objects
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED */

/******************************************************************************
**                        Macro Definitions 
*******************************************************************************/
#ifndef __BL_H__
#define __BL_H__

#define E_PASS                (0)
#define E_FAIL                (-1)

#define UARTPuts(x,y) bl_UARTPuts(x)
#define UARTprintf(x) bl_UARTPuts(x)
#if defined(am1808) || defined(omapl138) || defined(c6748)
    /* Magic numbers for gforge and sourceforge */
    #define MAGIC_NUM_GF          (0xA1ACED00)
    #define MAGIC_NUM_SF          (0x55424CBB)
    
    /* Magic number and tokens for RPRC format */
    #define RPRC_MAGIC_NUMBER   0x43525052
    #define RPRC_RESOURCE       0
    #define RPRC_BOOTADDR       5

    typedef struct _spibootheader_
    {
        unsigned int magicNum;    
        unsigned int entryPoint;  
        unsigned int appSize;    
        unsigned int memAddress; 
        unsigned int ldAddress;   
    }SPIBootHeader;
    
    typedef struct rprcFileHeader {
        unsigned int magic;
        unsigned int version;
        unsigned int text_len;
    } rprcFileHeader;

    typedef struct rprcSectionHeader {
        unsigned int type;
        unsigned int addr;
        unsigned int rsvd;  /* note: only use 32 LSBs of standard 64-bit address */
        unsigned int size;
    } rprcSectionHeader;

#elif defined(am335x) || defined(am335x_13x13) || defined(am335x_15x15)
    /* This header is used by the ROM Code to indentify the size of bootloader
     * and the location to which it should be loaded
     */
    typedef struct _ti_header_
    {
        unsigned int image_size;  
        unsigned int load_addr; 
    }ti_header;
#endif

/******************************************************************************
**                    Function Declarations
*******************************************************************************/
extern void BootAbort(void);
extern void Entry (void);

#endif
