/**
 * \file bl_am1808.h
 *
 * \brief This file exports the APIs used for configuring devices
 *        required during boot
 *  
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */
#ifndef __BL_AM1808_H__
#define __BL_AM1808_H__

/******************************************************************************
**                    External Function Declararions 
*******************************************************************************/
extern void UARTPinMuxSetup(unsigned int instanceNum, unsigned int modemCtrlChoice);
extern void SPI1CSPinMuxSetup(unsigned int csPinNum); 
extern void SPIPinMuxSetup(unsigned int instanceNum);
extern void UartConfigure(void);
extern void SPIConfigure(void);
extern void UARTSetup(void);
extern void SPISetup(void);
extern void Entry(void);
extern void USBSetup(void);



#define SPI_INPUT_FREQ                     150000000
#define SPI_SCLK_FREQ                      20000000

#define ARM_300MHZ
#define DDR_150MHZ

#ifdef DDR_150MHZ
        /* Fix DDR timing values/refresh rates */
  #define DDR2_SDTIMR1               0x1C912A08
  #define DDR2_SDTIMR2               0x3811C700
  #define DDR2_SDRCR                 0xC0000459
  #define DDR2_SDRCR_CLEAR           0xC0000000
  #define DDR2_SDCR                  0x0A03C622
  #define VTPIO_CTL_HIGH             0x00080000
#else
  #error Only 150Mhz support is given for DDR
#endif

#ifdef ARM_300MHZ
 /* Fixing PLL0 register values */
 #define PLL_CLK_SRC             0
 #define PLL0_MUL                24
 #define PLL0_PREDIV             0
 #define PLL0_POSTDIV            1
 #define PLL0_DIV1               0
 #define PLL0_DIV3               11
 #define PLL0_DIV7               5

 /* Fixing PLL1 register values */
 #define PLL1_MUL                21
 #define PLL1_POSTDIV            1
 #define PLL1_DIV1               0
 #define PLL1_DIV2               1
 #define PLL1_DIV3               2
#else
    #error Unsupported frequency !!
#endif

/* Fix the offset, where the boot image lies in the flash */
#define IMAGE_OFFSET             64*1024

#define UART_BASE                SOC_UART_2_REGS
#define SPI_BASE                 SOC_SPI_1_REGS
#define SPI_CS                   0x01
#define SPI_CS_INACTIVE_STATE    0x01

#endif

