/**
 * \file bl_am335x_15x15.h
 *
 * \brief Setting values to the macros depending on 
 *        Operating frequencies and DDR frequency 
 *        for 15x15 Soc.
 *  
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */

#ifndef __AM335X_15x15_H__
#define __AM335X_15x15_H__


/******************************************************************************
**                 Configuration Options for Boot Loader
*******************************************************************************/

/* Set of config parameters for AM335x */


    #define  OPP_100
    /* 
    **Setting the CORE PLL values at OPP100:
    ** OSCIN = 24MHz, Fdpll = 2GHz
    ** HSDM4 = 200MHz, HSDM5 = 250MHz
    ** HSDM6 = 500MHz
    */
    #define COREPLL_M                1000
    #define COREPLL_N                23
    #define COREPLL_HSD_M4           10
    #define COREPLL_HSD_M5           8
    #define COREPLL_HSD_M6           4

    /* Setting the  PER PLL values at OPP100:
    ** OSCIN = 24MHz, Fdpll = 960MHz
    ** CLKLDO = 960MHz, CLKOUT = 192MHz
    */
    #define PERPLL_M                960
    #define PERPLL_N                23
    #define PERPLL_M2               5

    #ifdef  OPP_SR_TURBO
         /* Setting the MPU (Cortex) clock at 720MHz */
         #define MPUPLL_M                720
    #elif  (defined OPP_100)
        /* Setting the MPU (Cortex) clock at 550MHz */
        #define MPUPLL_M                550
    #endif

    #define MPUPLL_N                23
    #define MPUPLL_M2               1

     /* Setting the Display CLKOUT at 300MHz independently
     ** This is required for full clock 150MHz for LCD
     ** OSCIN = 24MHz, Fdpll = 300MHz
     ** CLKOUT = 150MHz
     */
    #define DISPLL_M                23
    #define DISPLL_N                48
    #define DISPLL_M2               1

    /* 
    **Setting the DDR2 frequency to 266MHz
    */
    #define DDRPLL_M		   266
    #define DDRPLL_N		   23
    #define DDRPLL_M2		   1

#endif

