/**
 * \file bl_config.h
 *
 * \brief Setting values to the macros depending on 
 *            Operating frequencies and DDR frequency.
 *  
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */

#ifndef __BL_CONFIG_H__
#define __BL_CONFIG_H__

#include <bl.h>

/******************************************************************************
**                 Configuration Options for Boot Loader
*******************************************************************************/
#ifdef am335x_15x15

    #include "soc_AM335x.h"
    #include "bl_am335x.h"    
    #include "bl_am335x_15x15.h"

#elif defined(am335x_13x13)
    #include "soc_AM335x.h"
    #include "bl_am335x.h"        
    #include "bl_am335x_13x13.h"

#elif defined(am1808)
    #include "soc_AM1808.h"
    #include "bl_am1808.h"

#elif defined(omapl138)
    #include "soc_OMAPL138.h"
    #include "bl_am1808.h"

#elif defined(c6748)
    #include "soc_C6748.h"
    #include "bl_am1808.h"

#else
    #error "UNSUPPORTED EVM"
#endif /* EVM */

void DeviceConfig(void);
void PLLInit(void);

#endif
