/**
 *  \file   bl_nand.h
 *
 *  \brief  NAND functions used inside the bootloader
 *
 *   This file contains functions for NAND Initialization
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */

#ifndef __BL_NAND_H__
#define __BL_NAND_H__


/******************************************************************************
**                    Internal Macro Definitions
*******************************************************************************/
#define NAND_PAGE_SIZE                    (2048u)

/******************************************************************************
**                    External Function Declarations 
*******************************************************************************/
extern unsigned int NANDConfigure(NANDInfo *nandInfo);
extern void NANDSetup();
extern unsigned int NANDCSGet();
extern void NANDReadFlash (NANDInfo *nandInfo, unsigned int offset);
#endif

