/*
 * \file     pmic.h
 *
 * \brief    This file contains the function prototypes power management API's
 *
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */
 
#ifndef      __PMIC_H__
#define      __PMIC_H__

#include "hw_control_AM335x.h"

#ifdef beaglebone
    #include "hw_tps65217.h"
#else
    #include "hw_tps65910.h"
#endif

#include "hw_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef  beaglebone

/*****************************************************************************
**                   MACRO DEFINITIONS                                   
*****************************************************************************/

#define SMPS_DRIVE_SCLSR_EN1	(0x0u)
#define SMPS_DRIVE_SDASR_EN2	(0x1u)

/*****************************************************************************
**                   FUNCTION DECLARATIONS                                   
*****************************************************************************/
void selectI2CInstance(unsigned int i2cInstance);

/*	VDD2_REG	*/
void configureVdd2(unsigned int opVolMultiplier, unsigned maxLoadCurrent,
					unsigned int timeStep, unsigned int supplyState);

/*	VDD2_OP_REG	*/
void selectVdd2Source(unsigned int vdd1Source);
					
/*	VDD2_OP_REG	*/
void setVdd2OpVoltage(unsigned int opVolSelector);


/*	VDD1_REG	*/
void configureVdd1(unsigned int opVolMultiplier, unsigned maxLoadCurrent,
					unsigned int timeStep, unsigned int supplyState);

/*	VDD1_OP_REG	*/
void selectVdd1Source(unsigned int vdd1Source);
					
/*	VDD1_OP_REG	*/
void setVdd1OpVoltage(unsigned int opVolSelector);


/*	VDD1_SR_REG	*/
void setVdd2SrVoltage(unsigned int opVolSelector);

/*	BCK1_REG
 * 	BCK2_REG
 *	BCK3_REG
 *	BCK4_REG
 *	BCK5_REG
*/

#else

void tps65217_reg_read(unsigned char regOffset, unsigned char* dest);
void tps65217_reg_write(unsigned char port_level, unsigned char regOffset,
                        unsigned char dest_val, unsigned char mask);
void tps65217_voltage_update(unsigned char dc_cntrl_reg, unsigned char volt_sel);

#endif

void configVddOpVoltage(void);

#ifdef __cplusplus
}
#endif

#endif
