;******************************************************************************
;
; init.S - Init code routines
;
; Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
; All rights reserved.
;
;******************************************************************************

	MODULE EXCEPTIONS
;****************************** Global Symbols*********************************
        PUBLIC Entry
        IMPORT bl_start
        IMPORT __iar_data_init3

        IMPORT stack_end$$Base
 
        SECTION .bss:CODE:NOROOT(3)
        SECTION SYSTEMSTART:CODE (4)
;************************ Internal Definitions ********************************

;
; to set the mode bits in CPSR for different modes
;        
UND_STACK_SIZE DEFINE 0x8
ABT_STACK_SIZE DEFINE 0x8
FIQ_STACK_SIZE DEFINE 0x8
IRQ_STACK_SIZE DEFINE 0x500
SVC_STACK_SIZE DEFINE 0x8

MODE_USR DEFINE 0x10            
MODE_FIQ DEFINE 0x11
MODE_IRQ DEFINE 0x12
MODE_SVC DEFINE 0x13
MODE_ABT DEFINE 0x17
MODE_UND DEFINE 0x1B
MODE_SYS DEFINE 0x1F            

I_F_BIT DEFINE 0xC0               

;******************************************************************************
; This source file is assembled for ARM instructions
        CODE32
;******************************************************************************
;
; The reset handler sets up the stack pointers for all the modes. The FIQ and
; IRQ shall be disabled during this. Then, clearthe BSS sections, switch to the
; main() function. 
;
Entry:
;
; Set up the Stack for Undefined mode
;
         LDR   r0, =stack_end$$Base             ; Read the stack address
         MSR   cpsr_c, #MODE_UND|I_F_BIT       ; switch to undef  mode
         MOV   sp,r0                           ; write the stack pointer
         SUB   r0, r0, #UND_STACK_SIZE         ; give stack space
;
; Set up the Stack for abort mode
;
         MSR   cpsr_c, #MODE_ABT|I_F_BIT       ; Change to abort mode
         MOV   sp, r0                          ; write the stack pointer
         SUB   r0,r0, #ABT_STACK_SIZE          ; give stack space
;
; Set up the Stack for FIQ mode
;
         MSR   cpsr_c, #MODE_FIQ|I_F_BIT       ; change to FIQ mode
         MOV   sp,r0                           ; write the stack pointer
         SUB   r0,r0, #FIQ_STACK_SIZE          ; give stack space
;
; Set up the Stack for IRQ mode
;
         MSR   cpsr_c, #MODE_IRQ|I_F_BIT       ; change to IRQ mode
         MOV   sp,r0                           ; write the stack pointer
         SUB   r0,r0, #IRQ_STACK_SIZE          ; give stack space
;
; Set up the Stack for SVC mode
;
         MSR   cpsr_c, #MODE_SVC|I_F_BIT       ; change to SVC mode
         MOV   sp,r0                           ; write the stack pointer
         SUB   r0,r0, #SVC_STACK_SIZE          ; give stack space
;
; Set up the Stack for USer/System mode
;
         MSR   cpsr_c, #MODE_SYS|I_F_BIT       ; change to system mode
         MOV   sp,r0                           ; write the stack pointer

;
; Clear the BSS section here. Use IAR library functions to init data sections.
; Do so because the linker script is not friendly enough for access this section
;
         LDR   r10,=__iar_data_init3
         BLX   r10


         LDR   r0, =SFB(.bss)                    ; Start address of BSS
         LDR   r1, =SFE(.bss)                    ; End address of BSS
         MOV   r2, #0
loop_zi_copy:
         STR   r2, [r0], #4                    ; Clear one word in BSS
         CMP   r0, r1
         BLE   loop_zi_copy                    ; Clear till BSS end

;
; Enter the main function. The execution still happens in system mode
;
Enter_main:
         LDR   r10, =bl_start		           ; Get the address of main
         MOV   lr,pc                           ; Dummy return to main
         BLX    r10                             ; Branch to main 
         SUB   pc, pc, #0x08                   ; looping   

;
; End of the file
;
         END    
    



