/*
 * \file bl_main.c
 *
 * Boot loader
 *
*/

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */
#include "bl.h"
#include "bl_copy.h"
//#include "uartStdio.h"
#include "bl_pmic.h"

#define APPL_BUILD_VER  "1.0.0"

/******************************************************************************
**                    External Variable Declararions 
*******************************************************************************/
extern char *deviceType;
extern void DeviceConfig(void);
extern void bl_UARTPuts(char* buffer);
extern void bl_UARTInit(void);
/******************************************************************************
**                     Local Function Declararion 
*******************************************************************************/
static void (*appEntry)();

/******************************************************************************
**                     Global variable Definitions
*******************************************************************************/
unsigned int entryPoint;

/******************************************************************************
**                          FUNCTION DEFINITIONS
*******************************************************************************/
/*
 * \br0000ae3cief This function initializes the system and copies the image. 
 *
 * \param  none
 *
 * \return none 
*/

#ifdef _TMS320C6X
void main(void)
#else
void bl_start(void)
#endif
{
    #ifdef am335x_15x15
    #ifdef evmAM335x
        //configVddOpVoltage();
        #ifdef  OPP_SR_TURBO
               /* 
               **set vdd1 voltage to 1.26v .This
               **voltage is configure by writing 
               **0x38 to SEL(0:6) bitfiled of VDD1_OP_REG.
               **
               ** Vout = (SEL(0:6) * 12.5mv + 562.5mv)
               */
              //setVdd1OpVoltage(0x38);
        #elif  (defined OPP_120)
               /* 
               **set vdd1 voltage to 1.2v .This
               **voltage is configure by writing 
               **0x38 to SEL(0:6) bitfiled of VDD1_OP_REG.
               **
               ** Vout = (SEL(0:6) * 12.5mv + 562.5mv)
               */
              //setVdd1OpVoltage(0x33);
        #endif
    #elif  (defined beaglebone)
        configVddOpVoltage();
    #else
        #error Unsupported EVM !!
    #endif
    #endif

    /* Configures PLL and DDR controller*/
    DeviceConfig();
    *(unsigned int*)0x44E00508 = 2;			// select 32kHz

    /* UART Initialization */
    bl_UARTInit();

    bl_UARTPuts("\n\r*** StarterWare ");
    bl_UARTPuts(deviceType);
    bl_UARTPuts(" Boot Loader. Build - ");
	bl_UARTPuts(APPL_BUILD_VER);
	bl_UARTPuts(" ***\n\r");

    /* Copies application from flash to DDR */    
    if(ImageCopy() == E_FAIL)
    {
        bl_UARTPuts(" Image Copy failed, Aborting..\n\r");
        BootAbort();
    }
    bl_UARTPuts(" Image Copy Successful, Executing Application..\n\r");
    appEntry = (void (*)(void)) entryPoint;


    /* Giving control to the application */
    (*appEntry)( );
}

/*
 * \brief This function Aborts execution. 
 *
 * \param  none
 *
 * \return none 
*/

void BootAbort(void)
{
    while (1);
}

/***************************** End Of File ***********************************/
