/*
Keystone memory configuration including memory map and memmory protection
Author: Brighton
Created on 2010-12-12
*/
#include <stdio.h>
#include <c6x.h>
#include <cslr_chip.h>


void Exception_cfg()
{
	}

void memory_protection_exception(unsigned int MPFAR, 
	unsigned int MPFSR)
{

}

void EXC_external(void)
{

}

/*internal exception handler*/
void EXC_internal(void)
{
	unsigned int ierr;

	/*record IERR */    
	ierr = IERR;
	
	if (ierr & CSL_CHIP_IERR_IFX_MASK) {
		puts("Instruction fetch exception happened");
	}
	else if (ierr & CSL_CHIP_IERR_FPX_MASK) {
		puts("Fetch packet exception happened");
	}
	else if (ierr & CSL_CHIP_IERR_EPX_MASK) {
		puts("Execute patcket exception happened");
	}
	else if (ierr & CSL_CHIP_IERR_OPX_MASK) {
		puts("Opcode exception happened");
	}
	else if (ierr & CSL_CHIP_IERR_RCX_MASK) {
		puts("Resource conflict exception happened");
	}
	else if (ierr & CSL_CHIP_IERR_RAX_MASK) {
		puts("Resource access exception happened");
	}
	else if (ierr & CSL_CHIP_IERR_PRX_MASK) {
		puts("Privilege exception happened");
	}
	else if (ierr & CSL_CHIP_IERR_LBX_MASK) {
		puts("Loop buffer exception happened");
	}
	else {
		printf("internal exception. IERR= 0x%x\n", ierr);
	}
	
}

void EXC_nmi(void)
{
	puts("Legacy NMI exception happened");
}

/*software generated exception handler*/
void EXC_swgen(void)
{	
	puts("Software generated exception happened.");
}

void interrupt Exeception_ISR(void)
{
	unsigned int efr, nrp, ntsr, tscl, tsch;

	/*record timestamp*/
	tscl = TSCL;
	tsch = TSCH;
	
	nrp = NRP;   /*record NRP */
	ntsr = NTSR; /*record NTSR */
	efr = EFR;   /*record EFR */
	
	/*check all possible exceptions*/
	if (efr & CSL_CHIP_EFR_OXF_MASK) {
		/* S/W generated exception */
		EXC_swgen();		
	}
	else if (efr & CSL_CHIP_EFR_IXF_MASK) {
		/* internal exception */
		EXC_internal();		
	}
	else if (efr & CSL_CHIP_EFR_EXF_MASK) {
		/* external exception */
		EXC_external();		
	}
	else if (efr & CSL_CHIP_EFR_NXF_MASK) {
		/* legacy NMI exception */
		EXC_nmi();		
	}
	else {
		printf("Exception happened. EFR = 0x%x\n", efr);
	}

	printf("NRP=0x%x, NTSR=0x%x, TSCH= 0x%x, TSCL= 0x%x\n", 
		nrp, ntsr, tsch, tscl);

	while(1);		//trap
}


