
#include <c6x.h>
#include <stdio.h>
#include <string.h>
#include <ti\csl\cslr_device.h>
#include <ti\csl\csl_cacheAux.h>

#include "drv.h"
#include "init.h"

/*Queue Manager definition*/
CSL_Qm_configRegs * qmCfgRegs= (CSL_Qm_configRegs *)(0x02a68000);
QMSS_DescriptorMemoryRegionRegs * qmDescriptorRegions= 
	(QMSS_DescriptorMemoryRegionRegs *)(0x02a6a000);

/*queue access registers through VBUSP configration bus*/
QueueManageRegs * queueManageRegs= 
	(QueueManageRegs *)(0x02a20000);

/*queue access data space through VBUSM data bus*/
QueueManageRegs * queueManageData= 
	(QueueManageRegs *)(0x34020000);

CSL_Qm_intdRegs * qmIntRegs= (CSL_Qm_intdRegs *)(0x02aa0000);

/*PacketDMA definition*/
CSL_Cppidma_global_configRegs * qmDmaCfgRegs= 
	(CSL_Cppidma_global_configRegs * )(0x02a6c000);
CSL_Cppidma_tx_channel_configRegs * qmDmaTxChCfgRegs= 
	(CSL_Cppidma_tx_channel_configRegs * )(0x02a6c400);
CSL_Cppidma_rx_channel_configRegs * qmDmaRxChCfgRegs= 
	(CSL_Cppidma_rx_channel_configRegs * )(0x02a6c800);
volatile Uint32 * qmDmaTxChPriority = 
	(volatile Uint32 *)(0x02a6cc00);
CSL_Cppidma_rx_flow_configRegs * qmDmaRxFlowCfgRegs= 
	(CSL_Cppidma_rx_flow_configRegs * )(0x02a6d000);


void QMSS_Linking_RAM_init()
{
#if 0
	int i;
	// 0x80000 is the fixed address for region 0
	qmCfgRegs->LINKING_RAM_REGION_0_BASE_ADDRESS_REG= 0x80000; 
	//0x3FFF means the whole region 0 will be used
	qmCfgRegs->LINKING_RAM_REGION_0_SIZE_REG= 0x3FFF; 


	//empty all queues
	for(i=0; i<8192 ; i++)
		queueManageRegs[i].REG_D_Descriptor= 0;
	
#else
	int i;
	Uint32 *p;

	p = (Uint32 *)0x02A6800C;
	// 0x80000 is the fixed address for region 0
	*p= 0x80000; 
	//0x3FFF means the whole region 0 will be used
	p = (Uint32 *)0x02A68010;
	*p= 0x3FFF; 


	//empty all queues
	//0x02a2000c
	//0x02a2001c
	//0x02a2002c
	p = (Uint32 *)0x02a2000c;
	for(i=0; i<8192 ; i++)
	{	
		*p=0;
		p = p + 0x10;
	}
	
#endif

}

void QMSS_Descriptor_Regions_init()
{
		qmDescriptorRegions[0].BASE_ADDRESS_REG=(Uint32)(&hostDescriptor[0][0])+0x10000000;
		qmDescriptorRegions[0].START_INDEX_REG= 0; 
		qmDescriptorRegions[0].DESCRIPTOR_SETUP_REG= 0x10000;

		qmDescriptorRegions[1].BASE_ADDRESS_REG= (Uint32)(&rhostDescriptor[0][0])+0x10000000;
		qmDescriptorRegions[1].START_INDEX_REG= 32; 
		qmDescriptorRegions[1].DESCRIPTOR_SETUP_REG= 0x10000;

}

void Host_Descriptor_Queues_init()
{
	int i;
	Uint32 uiTempletSize, uiBufferAddress, uiDescriptorAddress;
	HostPacketDescriptor descriptorTemplet, * descriptor;
	Uint32 uiFreeQuNum;

	uiTempletSize= sizeof(descriptorTemplet);
	memset(&descriptorTemplet, 0, uiTempletSize); 

	descriptorTemplet.type_id= Cppi_DescType_HOST;
	descriptorTemplet.ret_push_policy= 1 ; //return to queue head
	descriptorTemplet.return_policy= 1 ; //each descriptor separately goes to pkt_return_qnum

/*
 * configure the first free descriptor queue
 * 	(1) populate the descriptors
 * 	(2) link the descriptors with their corresponding buffers
 * 	(3) push to the queue
 *
 */
	uiBufferAddress =(Uint32)(&packetBuffer[0][0])+0x10000000;
	uiDescriptorAddress =(Uint32)(&hostDescriptor[0][0])+0x10000000;
	uiFreeQuNum =FDQ_USED_FOR_SEND;
	{
		/*initialze buffer size*/
		descriptorTemplet.packet_length		= SIZE_PKT_BUF;
		descriptorTemplet.buffer_len		= SIZE_PKT_BUF;
		descriptorTemplet.orig_buff0_len	= SIZE_PKT_BUF;

		/*initialize this free queue as return queue number*/
		descriptorTemplet.pkt_return_qmgr= uiFreeQuNum>>12;
		descriptorTemplet.pkt_return_qnum= uiFreeQuNum&0xFFF;

		for(i=0; i<NUM_HOST_DESCRIPTOR; i++)
		{
			memcpy((void *)uiDescriptorAddress, (void *)&descriptorTemplet, uiTempletSize);
			descriptor = (HostPacketDescriptor *)uiDescriptorAddress;
			descriptor->buffer_ptr= uiBufferAddress;
			descriptor->orig_buff0_ptr= uiBufferAddress;

			/*push this descriptor to free queue*/
			queueManageRegs[uiFreeQuNum].REG_D_Descriptor=uiDescriptorAddress|FETCH_SIZE_32;
			
			uiDescriptorAddress+= SIZE_HOST_DESCRIPTOR;
			uiBufferAddress+= SIZE_PKT_BUF;
		}
	}
	/*
	 * configure the second free descriptor queue
	 * 	(1) populate the descriptors
	 * 	(2) link the descriptors with their corresponding buffers
	 * 	(3) push to the queue
	 *
	 */
		uiBufferAddress =(Uint32)(&rpacketBuffer[0][0])+0x10000000;
		uiDescriptorAddress =(Uint32)(&rhostDescriptor[0][0])+0x10000000;
		uiFreeQuNum =FDQ_USED_FOR_RECEIVE;
		{
			/*initialze buffer size*/
			descriptorTemplet.packet_length		= SIZE_PKT_BUF;
			descriptorTemplet.buffer_len		= SIZE_PKT_BUF;
			descriptorTemplet.orig_buff0_len	= SIZE_PKT_BUF;

			/*initialize this free queue as return queue number*/
			descriptorTemplet.pkt_return_qmgr= uiFreeQuNum>>12;
			descriptorTemplet.pkt_return_qnum= uiFreeQuNum&0xFFF;

			for(i=0; i<NUM_HOST_DESCRIPTOR; i++)
			{
				memcpy((void *)uiDescriptorAddress, (void *)&descriptorTemplet, uiTempletSize);
				descriptor = (HostPacketDescriptor *)uiDescriptorAddress;
				descriptor->buffer_ptr= uiBufferAddress;
				descriptor->orig_buff0_ptr= uiBufferAddress;

				/*push this descriptor to free queue*/
				queueManageRegs[uiFreeQuNum].REG_D_Descriptor=uiDescriptorAddress|FETCH_SIZE_32;

				uiDescriptorAddress+= SIZE_HOST_DESCRIPTOR;
				uiBufferAddress+= SIZE_PKT_BUF;
			}
		}

	CACHE_wbAllL2(CACHE_WAIT); 	//write back all descriptors in cache
}

/*configure the global control registers of a packet DMA*/
void pktDma_Global_Control (
	CSL_Cppidma_global_configRegs * pktDmaCfgRegs,
	Uint32 uiStarvationWaitCycles, Uint32 rxPriority, Uint32 txPriority)
{
	pktDmaCfgRegs->PERF_CONTROL_REG = (pktDmaCfgRegs->PERF_CONTROL_REG&(~0x0000FFFFu))|
		(uiStarvationWaitCycles<<0x00000000u);

	pktDmaCfgRegs->PRIORITY_CONTROL_REG = (rxPriority<<0x00000010u)|
		(txPriority<<0x00000000u);

	pktDmaCfgRegs->QM_BASE_ADDRESS_REG[0]= 0x34020000; 	/*queue 0~4095*/
	pktDmaCfgRegs->QM_BASE_ADDRESS_REG[1]= 0x34030000; 	/*queue 4096~8191*/
}

void pktDma_configureRxFlow (CSL_Cppidma_rx_flow_configRx_flow_configRegs * rxFlowCfgRegs)
{
       Uint32      reg;
       int i =0;

	{
	    reg = 0;
		/* Rx flow configuration register A */
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DEST_QNUM, PKTDMA_RX_Q);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DEST_QMGR, PKTDMA_RX_Q>>12);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_SOP_OFFSET, 0);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_PS_LOCATION, 0);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DESC_TYPE, Cppi_DescType_HOST);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_ERROR_HANDLING, 0);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_PSINFO_PRESENT, 0);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_EINFO_PRESENT, 0);
	    rxFlowCfgRegs[i].RX_FLOW_CONFIG_REG_A = reg;

	    reg = 0;
	    /* Rx flow configuration register B */
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_DEST_TAG_LO, 0);// don't care because don't ovewrite specified in Reg C
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_DEST_TAG_HI, 0);// don't care because don't ovewrite specified in Reg C
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_SRC_TAG_LO, 0);// don't care because don't ovewrite specified in Reg C
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_SRC_TAG_HI, 0);// don't care because don't ovewrite specified in Reg C
	    rxFlowCfgRegs[i].RX_FLOW_CONFIG_REG_B = reg;

	    reg = 0;
	    /* Rx flow configuration register C */		
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SIZE_THRESH_EN, 1); // do not enable selection for different rx Q
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_DEST_TAG_LO_SEL, 0); // don't overwrite
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_DEST_TAG_HI_SEL, 0);// don't overwrite
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SRC_TAG_LO_SEL, 0);// don't overwrite
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SRC_TAG_HI_SEL, 0);// don't overwrite
	    rxFlowCfgRegs[i].RX_FLOW_CONFIG_REG_C = reg;

	    reg = 0;
		/* Rx flow configuration register D */
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ1_QNUM, FDQ_USED_FOR_RECEIVE);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ1_QMGR, FDQ_USED_FOR_RECEIVE>>12);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ0_SZ0_QNUM, FDQ_USED_FOR_RECEIVE);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ0_SZ0_QMGR, FDQ_USED_FOR_RECEIVE>>12);
	    rxFlowCfgRegs[i].RX_FLOW_CONFIG_REG_D = reg;

	    reg = 0;
		/* Rx flow configuration register E */
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ3_QNUM, FDQ_USED_FOR_RECEIVE);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ3_QMGR, FDQ_USED_FOR_RECEIVE>>12);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ2_QNUM, FDQ_USED_FOR_RECEIVE);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ2_QMGR, FDQ_USED_FOR_RECEIVE>>12);
	    rxFlowCfgRegs[i].RX_FLOW_CONFIG_REG_E = reg;

	    reg = 0;
		/* Rx flow configuration register F */
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_F_RX_SIZE_THRESH1, 1);// don't care since not enabled in Reg C
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_F_RX_SIZE_THRESH0, 1);// don't care since not enabled in Reg C
	    rxFlowCfgRegs[i].RX_FLOW_CONFIG_REG_F = reg;
	    
	    reg = 0;
	    /* Rx flow configuration register G */
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_FDQ0_SZ1_QNUM, FDQ_USED_FOR_RECEIVE);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_FDQ0_SZ1_QMGR, FDQ_USED_FOR_RECEIVE>>12);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_SIZE_THRESH2, 1);// don't care since not enabled in Reg C
	    rxFlowCfgRegs[i].RX_FLOW_CONFIG_REG_G = reg;

	    reg = 0;
	    /* Rx flow configuration register H */
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ3_QNUM, FDQ_USED_FOR_RECEIVE);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ3_QMGR, FDQ_USED_FOR_RECEIVE>>12);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ2_QNUM, FDQ_USED_FOR_RECEIVE);
	    CSL_FINS (reg, CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ2_QMGR, FDQ_USED_FOR_RECEIVE>>12);
	    rxFlowCfgRegs[i].RX_FLOW_CONFIG_REG_H = reg;
	}
}

