#ifndef _KEYSTONE_MULTICORE_NAVIGATOR_H_
#define _KEYSTONE_MULTICORE_NAVIGATOR_H_

#include <ti\csl\tistdtypes.h>
#include <ti\csl\cslr_qm_config.h>
#include <ti\csl\cslr_qm_descriptor_region_config.h>
#include <ti\csl\cslr_qm_queue_management.h>
#include <ti\csl\cslr_qm_queue_status_config.h>
#include <ti\csl\cslr_qm_intd.h>
#include <ti\csl\cslr_pdsp.h>
#include <ti\csl\cslr_cppidma_global_config.h>
#include <ti\csl\cslr_cppidma_rx_channel_config.h>
#include <ti\csl\cslr_cppidma_rx_flow_config.h>
#include <ti\csl\cslr_cppidma_tx_channel_config.h>
#include "Descriptor.h"

#include "init.h"

typedef struct  { 
    volatile Uint32 BASE_ADDRESS_REG;
    volatile Uint32 START_INDEX_REG;
    volatile Uint32 DESCRIPTOR_SETUP_REG;
    volatile Uint8 RSVD0[4];
} QMSS_DescriptorMemoryRegionRegs;


typedef struct  {
    volatile Uint32 REG_A_EntryCount;
    volatile Uint32 REG_B_ByteCount;
    volatile Uint32 REG_C_HeadTail_PacketSize;
    volatile Uint32 REG_D_Descriptor;
} QueueManageRegs;

typedef enum
{
	FETCH_SIZE_16 = 0, 						
	FETCH_SIZE_32 , 						
	FETCH_SIZE_48 , 						
	FETCH_SIZE_64 , 						
	FETCH_SIZE_80 , 						
	FETCH_SIZE_96 ,						
	FETCH_SIZE_112,						
	FETCH_SIZE_128,						
	FETCH_SIZE_144,						
	FETCH_SIZE_160,						
	FETCH_SIZE_176,						
	FETCH_SIZE_192,						
	FETCH_SIZE_208,						
	FETCH_SIZE_224,						
	FETCH_SIZE_240,						
	FETCH_SIZE_256						
}Initial_Descriptor_Fetch_Size;


/*Queue Manager definition*/
extern CSL_Qm_configRegs * qmCfgRegs;
extern QMSS_DescriptorMemoryRegionRegs * qmDescriptorRegions; 

/*queue access registers through VBUSP configration bus*/
extern QueueManageRegs * queueManageRegs;

/*queue access data space through VBUSM data bus*/
extern QueueManageRegs * queueManageData;
extern CSL_Qm_intdRegs * qmIntRegs;


/*PacketDMA definition*/
extern CSL_Cppidma_global_configRegs * qmDmaCfgRegs;
extern CSL_Cppidma_rx_channel_configRegs * qmDmaRxChCfgRegs;
extern CSL_Cppidma_rx_flow_configRegs * qmDmaRxFlowCfgRegs;
extern CSL_Cppidma_tx_channel_configRegs * qmDmaTxChCfgRegs;
extern CSL_Cppidma_global_configRegs * paDmaCfgRegs;
extern CSL_Cppidma_rx_channel_configRegs * paDmaRxChCfgRegs;
extern CSL_Cppidma_rx_flow_configRegs * paDmaRxFlowCfgRegs;
extern CSL_Cppidma_tx_channel_configRegs * paDmaTxChCfgRegs;

static inline void pktDma_TxCh_enable(
	CSL_Cppidma_tx_channel_configRegs * pktDmaTxChCfgRegs, Uint32 uiChNum)
{
	pktDmaTxChCfgRegs->TX_CHANNEL_GLOBAL_CONFIG[uiChNum].TX_CHANNEL_GLOBAL_CONFIG_REG_A |= 
		(CSL_CPPIDMA_TX_CHANNEL_CONFIG_TX_CHANNEL_GLOBAL_CONFIG_REG_A_TX_ENABLE_MASK);
}

static inline void pktDma_RxCh_enable(
	CSL_Cppidma_rx_channel_configRegs * pktDmaRxChCfgRegs, Uint32 uiChNum)
{
	pktDmaRxChCfgRegs->RX_CHANNEL_GLOBAL_CONFIG[uiChNum].RX_CHANNEL_GLOBAL_CONFIG_REG |= 
		(CSL_CPPIDMA_RX_CHANNEL_CONFIG_RX_CHANNEL_GLOBAL_CONFIG_REG_RX_ENABLE_MASK);
}
	
void pktDma_Global_Control (CSL_Cppidma_global_configRegs * pktDmaCfgRegs,
	Uint32 uiStarvationWaitCycles, Uint32 rxPriority, Uint32 txPriority);
void 	pktDma_configureRxFlow (CSL_Cppidma_rx_flow_configRx_flow_configRegs * rxFlowCfgRegs);
void 	QMSS_Linking_RAM_init();
void 	Host_Descriptor_Queues_init();

#endif
