
#include <stdio.h>
#include <c6x.h>
#include <csl_cacheAux.h>
#include <csl_cache.h>
#include <csl_qm_queue.h>
#include "Init.h"

void TestCPPI()
{
	Uint32 				uiByteCount = SIZE_PKT_BUF;
	Uint32 				uiaDescriptorBuffer;
	HostPacketDescriptor * 	hostDescriptor;
	Uint8					*myP;
	int 					i;

	hostDescriptor= (HostPacketDescriptor *)(queueManageRegs[FDQ_USED_FOR_SEND].REG_D_Descriptor&0xFFFFFFF0);
	if(NULL==hostDescriptor)	{printf("Source queue descriptor %d is NULL\n", 0);	return;}

	hostDescriptor->packet_length= uiByteCount;
	hostDescriptor->buffer_len= uiByteCount;
	hostDescriptor->src_tag_lo= 0; // Uint32 uiFlowID = 0;

		/*initialize the source buffer*/
		myP= (Uint8 *)hostDescriptor->buffer_ptr;
		for(i=0; i<SIZE_PKT_BUF; i++)
			*myP++= i;

	/*push the packet descriptor to Packet DMA TX queue*/
		uiaDescriptorBuffer= (Uint32)hostDescriptor|FETCH_SIZE_32;
		queueManageData[PKTDMA_TX_Q].REG_D_Descriptor=uiaDescriptorBuffer;
}


void main(void)
{
	int i;

	for (i=0;i<SIZE_PKT_BUF;i++){
		rpacketBuffer[0][i]= 0xbe;
	}

	QMSS_init();
	PktDMA_init();
	TestCPPI();

	puts("Test complete");
  return;
}

