/**
 *   @file  edma_test.c
 *
 *   @brief
 *
*/

#include <stdio.h>
#include <ti/csl/csl_edma3.h>
#include <ti/csl/csl_edma3Aux.h>
#include <ti/csl/csl_cache.h>
#include <ti/csl/csl_cacheAux.h>

/**********************************************************************
 ************************** Global Variables **************************
 **********************************************************************/

/* Global Variables which are used to dump the TPCC register overlay in the
 * debugger... */
CSL_TpccRegs*  gEDMACC0Regs  = (CSL_TpccRegs*)CSL_EDMA0CC_REGS;
CSL_TpccRegs*  gEDMACC1Regs  = (CSL_TpccRegs*)CSL_EDMA1CC_REGS;
CSL_TpccRegs*  gEDMACC2Regs  = (CSL_TpccRegs*)CSL_EDMA2CC_REGS;


/* Global Buffers (Source and Destination) for PING-PONG */
float srcBuff1[512];
float srcBuff2[512];
float dstBuff1[512];
float dstBuff2[512];

/**********************************************************************
 ************************ EDMA TEST FUNCTIONS *************************
 **********************************************************************/



CSL_Edma3Handle                 hModule;
CSL_Edma3ChannelHandle          hChannel;
CSL_Edma3CmdIntr                regionIntr;
CSL_Edma3Handle                 hModule2;
CSL_Edma3ChannelHandle          hChannel2;

static Int32 edma_ping_pong_xfer_gbl_region (Int32 instNum, Uint8 channelNum)
{

	CSL_Edma3Obj                    edmaObj;
	CSL_Edma3ParamHandle            hParamPing;
	CSL_Edma3ChannelObj             chObj;

	CSL_Edma3ParamSetup             myParamSetup;
	CSL_Edma3Context                context;
	CSL_Edma3ChannelAttr            chAttr;
	CSL_Status                      status;


    /* Start the EDMA PING-PONG test over the Global Region. */
    printf ("Debug: Testing EDMA(%d) Ping-Pong Test (Global) Region for Channel %d...\n", instNum, channelNum);



    /* Module initialization */
    if (CSL_edma3Init(&context) != CSL_SOK)
    {
        printf ("Error: EDMA module initialization failed\n");
        return -1;
    }

    /* Open the EDMA Module using the provided instance number */
    hModule = CSL_edma3Open(&edmaObj, instNum, NULL, &status);
    if ( (hModule == NULL) || (status != CSL_SOK))
    {
        printf ("Error: EDMA module open failed\n");
        return -1;
    }

    /* Channel open */
    chAttr.regionNum = CSL_EDMA3_REGION_GLOBAL;
    chAttr.chaNum    = channelNum;
    hChannel = CSL_edma3ChannelOpen(&chObj, instNum, &chAttr, &status);
    if ((hChannel == NULL) || (status != CSL_SOK))
    {
        printf ("Error: Unable to open EDMA Channel:%d\n", channelNum);
        return -1;
    }

    /* Change Channel Default queue setup from 0 to 3  */
    if(0)//if (CSL_edma3HwChannelSetupQue(hChannel,CSL_EDMA3_QUE_3) != CSL_SOK)
    {
        printf ("Error: EDMA channel setup queue failed\n");
        return -1;
    }

    /* Map the DMA Channel to PARAM Block 2. */
    CSL_edma3MapDMAChannelToParamBlock (hModule, channelNum, 2);

    /* Obtain a handle to parameter set 2 */
    hParamPing = CSL_edma3GetParamHandle(hChannel, 2, &status);
    if (hParamPing == NULL)
    {
        printf ("Error: EDMA Get Parameter Entry failed for 2.\n");
        return -1;
    }


    /* Setup the parameter entry parameters (Ping buffer)//CSL_EDMA3_STATIC_EN޸ */
    myParamSetup.option = CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS, \
                                             CSL_EDMA3_TCCH_DIS, \
                                             CSL_EDMA3_ITCINT_DIS, \
                                             CSL_EDMA3_TCINT_EN, \
                                             0, CSL_EDMA3_TCC_NORMAL,\
                                             CSL_EDMA3_FIFOWIDTH_NONE, \
                                             CSL_EDMA3_STATIC_EN, \
                                             CSL_EDMA3_SYNC_A, \
                                             CSL_EDMA3_ADDRMODE_INCR, \
                                             CSL_EDMA3_ADDRMODE_INCR );
    myParamSetup.srcAddr    = (Uint32)srcBuff1;
    myParamSetup.aCntbCnt   = CSL_EDMA3_CNT_MAKE(2048,1);
    myParamSetup.dstAddr    = (Uint32)dstBuff1;
    myParamSetup.srcDstBidx = CSL_EDMA3_BIDX_MAKE(1,1);
//    myParamSetup.linkBcntrld= CSL_EDMA3_LINKBCNTRLD_MAKE(hParamPong,0);
    myParamSetup.srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,1);
    myParamSetup.cCnt = 1;

    /* Ping setup */
    if (CSL_edma3ParamSetup(hParamPing,&myParamSetup) != CSL_SOK)
    {
        printf ("Error: EDMA Parameter Entry Setup failed\n");
        return -1;
    }


    //ZW added to keep the coherience between L1D and L2(MSM). Jun 1 2012
    CACHE_wbInvAllL1d(CACHE_NOWAIT);
    CACHE_wbInvAllL1dWait();

    /* Interrupt enable (Bits 0-1)  for the global region interrupts */
    regionIntr.region = CSL_EDMA3_REGION_GLOBAL;
    regionIntr.intr   = 0x1;
    regionIntr.intrh  = 0x0000;
    CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_INTR_ENABLE,&regionIntr);

    return 1;

}
static Int32 edma_ping_pong_xfer_gbl_region_2 (Int32 instNum2, Uint8 channelNum2)
{

	CSL_Edma3Obj                    edmaObj2;
	CSL_Edma3ParamHandle            hParamPing2;
	CSL_Edma3ChannelObj             chObj2;

	CSL_Edma3ParamSetup             myParamSetup2;
	CSL_Edma3Context                context2;
	CSL_Edma3ChannelAttr            chAttr2;
	CSL_Status                      status2;


    /* Start the EDMA PING-PONG test over the Global Region. */
    printf ("Debug: Testing EDMA(%d) Ping-Pong Test (Global) Region for Channel %d...\n", instNum2, channelNum2);



    /* Module initialization */
    if (CSL_edma3Init(&context2) != CSL_SOK)
    {
        printf ("Error: EDMA module initialization failed\n");
        return -1;
    }

    /* Open the EDMA Module using the provided instance number */
    hModule2 = CSL_edma3Open(&edmaObj2, instNum2, NULL, &status2);
    if ( (hModule2 == NULL) || (status2 != CSL_SOK))
    {
        printf ("Error: EDMA module open failed\n");
        return -1;
    }

    /* Channel open */
    chAttr2.regionNum = CSL_EDMA3_REGION_GLOBAL;
    chAttr2.chaNum    = channelNum2;
    hChannel2 = CSL_edma3ChannelOpen(&chObj2, instNum2, &chAttr2, &status2);
    if ((hChannel2 == NULL) || (status2 != CSL_SOK))
    {
        printf ("Error: Unable to open EDMA Channel:%d\n", channelNum2);
        return -1;
    }

    /* Change Channel Default queue setup from 0 to 3  */
    if(0)//if (CSL_edma3HwChannelSetupQue(hChannel2,CSL_EDMA3_QUE_3) != CSL_SOK)
    {
        printf ("Error: EDMA channel setup queue failed\n");
        return -1;
    }

    /* Map the DMA Channel to PARAM Block 2. */
    CSL_edma3MapDMAChannelToParamBlock (hModule2, channelNum2, 1);

    /* Obtain a handle to parameter set 2 */
    hParamPing2 = CSL_edma3GetParamHandle(hChannel2, 1, &status2);
    if (hParamPing2 == NULL)
    {
        printf ("Error: EDMA Get Parameter Entry failed for 2.\n");
        return -1;
    }


    /* Setup the parameter entry parameters (Ping buffer)//CSL_EDMA3_STATIC_EN޸ */
    myParamSetup2.option = CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS, \
                                             CSL_EDMA3_TCCH_DIS, \
                                             CSL_EDMA3_ITCINT_DIS, \
                                             CSL_EDMA3_TCINT_EN, \
                                             1, CSL_EDMA3_TCC_NORMAL,\
                                             CSL_EDMA3_FIFOWIDTH_NONE, \
                                             CSL_EDMA3_STATIC_EN, \
                                             CSL_EDMA3_SYNC_A, \
                                             CSL_EDMA3_ADDRMODE_INCR, \
                                             CSL_EDMA3_ADDRMODE_INCR );
    myParamSetup2.srcAddr    = (Uint32)srcBuff2;
    myParamSetup2.aCntbCnt   = CSL_EDMA3_CNT_MAKE(2048,1);
    myParamSetup2.dstAddr    = (Uint32)dstBuff2;
    myParamSetup2.srcDstBidx = CSL_EDMA3_BIDX_MAKE(1,1);
//    myParamSetup2.linkBcntrld= CSL_EDMA3_LINKBCNTRLD_MAKE(hParamPong,0);
    myParamSetup2.srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,1);
    myParamSetup2.cCnt = 1;

    /* Ping setup */
    if (CSL_edma3ParamSetup(hParamPing2,&myParamSetup2) != CSL_SOK)
    {
        printf ("Error: EDMA Parameter Entry Setup failed\n");
        return -1;
    }


    //ZW added to keep the coherience between L1D and L2(MSM). Jun 1 2012
    CACHE_wbInvAllL1d(CACHE_NOWAIT);
    CACHE_wbInvAllL1dWait();

    /* Interrupt enable (Bits 0-1)  for the global region interrupts */
    regionIntr.region = CSL_EDMA3_REGION_GLOBAL;
    regionIntr.intr   = 0x2;
    regionIntr.intrh  = 0x0000;
    CSL_edma3HwControl(hModule2,CSL_EDMA3_CMD_INTR_ENABLE,&regionIntr);

    return 1;

}

/**
 *  @b Description
 *  @n
 *      Entry point for the test code.
 *
 *  @retval
 *      Not Applicable.
 */
void main (void)
{
	int i=0,a=0;//temp

	//EDMA
    Uint8  channelNum,channelNum2;
    Uint8  instNum ,instNum2;
    channelNum=0;
    instNum = 0;
    channelNum2=channelNum+8;
    instNum2=instNum+1;
    int loopIndex;
    printf ("**************************************************\n");
    printf ("******************* EDMA Testing *****************\n");
    printf ("**************************************************\n");

    /* Initialize data  */
    for (loopIndex = 0; loopIndex < 512; loopIndex++)
    {
        srcBuff1[loopIndex] = loopIndex;
        srcBuff2[loopIndex] = loopIndex;
        dstBuff1[loopIndex] = 0;
        dstBuff2[loopIndex] = 0;
    }

       edma_ping_pong_xfer_gbl_region(instNum, channelNum);
       edma_ping_pong_xfer_gbl_region_2(instNum2, channelNum2);


//       CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_SET,NULL);
//     do
//         {
//          	CSL_edma3GetHwStatus(hModule,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);
//         }  while(!(regionIntr.intr & 0x1));
//
//     CSL_edma3HwChannelControl(hChannel2,CSL_EDMA3_CMD_CHANNEL_SET,NULL);
//     do
//         {
//          	CSL_edma3GetHwStatus(hModule2,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);
//         }  while(!(regionIntr.intr & 0x2));

    /* Trigger channel 111111111111111*/
       CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_SET,NULL);
       CSL_edma3HwChannelControl(hChannel2,CSL_EDMA3_CMD_CHANNEL_SET,NULL);

       regionIntr.region = CSL_EDMA3_REGION_GLOBAL;
       regionIntr.intr   = 0;
       regionIntr.intrh  = 0;




    i=0;//temp
    while(i<10)
    {
    	i++;//temp
     	CSL_edma3GetHwStatus(hModule,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);
    	CSL_edma3GetHwStatus(hModule2,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);

    	if((regionIntr.intr & 0x1)&&(regionIntr.intr & 0x2))//
    	{
    	    /* Clear the pending bitλ  */
           CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_INTRPEND_CLEAR,&regionIntr);
           CSL_edma3HwControl(hModule2,CSL_EDMA3_CMD_INTRPEND_CLEAR,&regionIntr);

    	    //temp  process data
    	    a=a+1;
    	    for (loopIndex = 0; loopIndex < 512; loopIndex++)
    	    {

    	        dstBuff1[loopIndex] = 0;
    	        dstBuff2[loopIndex] = 0;
    	    }

 	       CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_SET,NULL);
  	       CSL_edma3HwChannelControl(hChannel2,CSL_EDMA3_CMD_CHANNEL_SET,NULL);

    	}

    	 continue;
    }



    /* Close channel */
    if (CSL_edma3ChannelClose(hChannel) != CSL_SOK)
    {
        printf("Error: EDMA Channel Close failed\n");
        return ;
    }

    /* Close EDMA module */
    if (CSL_edma3Close(hModule) != CSL_SOK)
    {
        printf("Error: EDMA Module Close failed\n");
        return ;
    }





    printf ("**************************************************\n");
    printf ("************* EDMA Testing Successful ************\n");
    printf ("**************************************************\n");

    /* The test passed. */
       return ;
}
