#ifndef __VITERBI_H
#define __VITERBI_H

#define CONSTRAINT_LEN 8

extern int DecodeFlag;
extern int LDLDataNum;
extern int DataPackNum;
extern int WaveType;

typedef struct
{
   unsigned char BWDataByte[256*12];
   unsigned char table[256*8];
   short tempdata1[256*8*2];
   short tempdata2[256*8*2];
   short XIData[3872];
   short XQData[3872];
   short sourcedataI0[120*8];
   short sourcedataQ0[120*8];
   short sourcedataI1[120*8];
   short sourcedataQ1[120*8];
   short sourcedataI2[120*8];
   short sourcedataQ2[120*8];
   short sourcedataI3[120*8];
   short sourcedataQ3[120*8];
   
   char UserData[3872];
   char convdata1[256*8*2];
   char convdata2[256*8*2];
   char convdata3[256*8*2];
   char convdata4[256*8*2];
   char SourceDataTest[256*8*2*4];
}DataStruct;

extern DataStruct NodeData;
void Byte2Bit(unsigned char bits[],unsigned char bytes[],int ByteLen);
extern void Bit2Byte(unsigned char bytes[],unsigned char bits[],int BitLen);


#endif


