/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @file  cslr_cache.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for CACHE
 */
#ifndef _CSLR_CACHE_H_
#define _CSLR_CACHE_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 L2CFG;
    volatile Uint8 RSVD0[28];
    volatile Uint32 L1PCFG;
    volatile Uint32 L1PCC;
    volatile Uint8 RSVD1[24];
    volatile Uint32 L1DCFG;
    volatile Uint32 L1DCC;
    volatile Uint8 RSVD2[16312];
    volatile Uint32 L2WBAR;
    volatile Uint32 L2WWC;
    volatile Uint8 RSVD3[8];
    volatile Uint32 L2WIBAR;
    volatile Uint32 L2WIWC;
    volatile Uint32 L2IBAR;
    volatile Uint32 L2IWC;
    volatile Uint32 L1PIBAR;
    volatile Uint32 L1PIWC;
    volatile Uint8 RSVD4[8];
    volatile Uint32 L1DWIBAR;
    volatile Uint32 L1DWIWC;
    volatile Uint8 RSVD5[8];
    volatile Uint32 L1DWBAR;
    volatile Uint32 L1DWWC;
    volatile Uint32 L1DIBAR;
    volatile Uint32 L1DIWC;
    volatile Uint8 RSVD6[4016];
    volatile Uint32 L2WB;
    volatile Uint32 L2WBINV;
    volatile Uint32 L2INV;
    volatile Uint8 RSVD7[28];
    volatile Uint32 L1PINV;
    volatile Uint8 RSVD8[20];
    volatile Uint32 L1DWB;
    volatile Uint32 L1DWBINV;
    volatile Uint32 L1DINV;
    volatile Uint8 RSVD9[12212];
    volatile Uint32 MAR[256];
} CSL_CacheRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_CacheRegs  *CSL_CacheRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* L2CFG */

#define CSL_CACHE_L2CFG_NUM_MM_MASK      (0x07000000u)
#define CSL_CACHE_L2CFG_NUM_MM_SHIFT     (0x00000018u)
#define CSL_CACHE_L2CFG_NUM_MM_RESETVAL  (0x00000000u)

#define CSL_CACHE_L2CFG_MMID_MASK        (0x00070000u)
#define CSL_CACHE_L2CFG_MMID_SHIFT       (0x00000010u)
#define CSL_CACHE_L2CFG_MMID_RESETVAL    (0x00000000u)

#define CSL_CACHE_L2CFG_IP_MASK          (0x00000200u)
#define CSL_CACHE_L2CFG_IP_SHIFT         (0x00000009u)
#define CSL_CACHE_L2CFG_IP_RESETVAL      (0x00000000u)

#define CSL_CACHE_L2CFG_ID_MASK          (0x00000100u)
#define CSL_CACHE_L2CFG_ID_SHIFT         (0x00000008u)
#define CSL_CACHE_L2CFG_ID_RESETVAL      (0x00000000u)

#define CSL_CACHE_L2CFG_L2CC_MASK        (0x00000008u)
#define CSL_CACHE_L2CFG_L2CC_SHIFT       (0x00000003u)
#define CSL_CACHE_L2CFG_L2CC_RESETVAL    (0x00000000u)

/*----L2CC Tokens----*/
#define CSL_CACHE_L2CFG_L2CC_ENABLED     (0x00000000u)
#define CSL_CACHE_L2CFG_L2CC_FREEZE      (0x00000001u)

#define CSL_CACHE_L2CFG_MODE_MASK        (0x00000007u)
#define CSL_CACHE_L2CFG_MODE_SHIFT       (0x00000000u)
#define CSL_CACHE_L2CFG_MODE_RESETVAL    (0x00000000u)

/*----MODE Tokens----*/
#define CSL_CACHE_L2CFG_MODE_OFF         (0x00000000u)
#define CSL_CACHE_L2CFG_MODE_0K          (0x00000000u)
#define CSL_CACHE_L2CFG_MODE_32K         (0x00000001u)
#define CSL_CACHE_L2CFG_MODE_64K         (0x00000002u)
#define CSL_CACHE_L2CFG_MODE_128K        (0x00000003u)
#define CSL_CACHE_L2CFG_MODE_256K        (0x00000004u)

#define CSL_CACHE_L2CFG_RESETVAL         (0x00000000u)

/* L2WBAR */

#define CSL_CACHE_L2WBAR_ADDR_MASK       (0xFFFFFFFFu)
#define CSL_CACHE_L2WBAR_ADDR_SHIFT      (0x00000000u)
#define CSL_CACHE_L2WBAR_ADDR_RESETVAL   (0x00000000u)

#define CSL_CACHE_L2WBAR_RESETVAL        (0x00000000u)

/* L2WWC */

#define CSL_CACHE_L2WWC_RESERVED_MASK    (0xFFFF0000u)
#define CSL_CACHE_L2WWC_RESERVED_SHIFT   (0x00000010u)
#define CSL_CACHE_L2WWC_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L2WWC_CNT_MASK         (0x0000FFFFu)
#define CSL_CACHE_L2WWC_CNT_SHIFT        (0x00000000u)
#define CSL_CACHE_L2WWC_CNT_RESETVAL     (0x00000000u)

#define CSL_CACHE_L2WWC_RESETVAL         (0x00000000u)

/* L2WIBAR */

#define CSL_CACHE_L2WIBAR_ADDR_MASK      (0xFFFFFFFFu)
#define CSL_CACHE_L2WIBAR_ADDR_SHIFT     (0x00000000u)
#define CSL_CACHE_L2WIBAR_ADDR_RESETVAL  (0x00000000u)

#define CSL_CACHE_L2WIBAR_RESETVAL       (0x00000000u)

/* L2WIWC */

#define CSL_CACHE_L2WIWC_RESERVED_MASK   (0xFFFF0000u)
#define CSL_CACHE_L2WIWC_RESERVED_SHIFT  (0x00000010u)
#define CSL_CACHE_L2WIWC_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L2WIWC_CNT_MASK        (0x0000FFFFu)
#define CSL_CACHE_L2WIWC_CNT_SHIFT       (0x00000000u)
#define CSL_CACHE_L2WIWC_CNT_RESETVAL    (0x00000000u)

#define CSL_CACHE_L2WIWC_RESETVAL        (0x00000000u)

/* L2IBAR */

#define CSL_CACHE_L2IBAR_ADDR_MASK       (0xFFFFFFFFu)
#define CSL_CACHE_L2IBAR_ADDR_SHIFT      (0x00000000u)
#define CSL_CACHE_L2IBAR_ADDR_RESETVAL   (0x00000000u)

#define CSL_CACHE_L2IBAR_RESETVAL        (0x00000000u)

/* L2IWC */

#define CSL_CACHE_L2IWC_RESERVED_MASK    (0xFFFF0000u)
#define CSL_CACHE_L2IWC_RESERVED_SHIFT   (0x00000010u)
#define CSL_CACHE_L2IWC_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L2IWC_CNT_MASK         (0x0000FFFFu)
#define CSL_CACHE_L2IWC_CNT_SHIFT        (0x00000000u)
#define CSL_CACHE_L2IWC_CNT_RESETVAL     (0x00000000u)

#define CSL_CACHE_L2IWC_RESETVAL         (0x00000000u)

/* L1DWBAR */

#define CSL_CACHE_L1DWBAR_ADDR_MASK      (0xFFFFFFFFu)
#define CSL_CACHE_L1DWBAR_ADDR_SHIFT     (0x00000000u)
#define CSL_CACHE_L1DWBAR_ADDR_RESETVAL  (0x00000000u)

#define CSL_CACHE_L1DWBAR_RESETVAL       (0x00000000u)

/* L1DWWC */

#define CSL_CACHE_L1DWWC_RESERVED_MASK   (0xFFFF0000u)
#define CSL_CACHE_L1DWWC_RESERVED_SHIFT  (0x00000010u)
#define CSL_CACHE_L1DWWC_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1DWWC_CNT_MASK        (0x0000FFFFu)
#define CSL_CACHE_L1DWWC_CNT_SHIFT       (0x00000000u)
#define CSL_CACHE_L1DWWC_CNT_RESETVAL    (0x00000000u)

#define CSL_CACHE_L1DWWC_RESETVAL        (0x00000000u)

/* L1DWIBAR */

#define CSL_CACHE_L1DWIBAR_ADDR_MASK     (0xFFFFFFFFu)
#define CSL_CACHE_L1DWIBAR_ADDR_SHIFT    (0x00000000u)
#define CSL_CACHE_L1DWIBAR_ADDR_RESETVAL (0x00000000u)

#define CSL_CACHE_L1DWIBAR_RESETVAL      (0x00000000u)

/* L1DWIWC */

#define CSL_CACHE_L1DWIWC_RESERVED_MASK  (0xFFFF0000u)
#define CSL_CACHE_L1DWIWC_RESERVED_SHIFT (0x00000010u)
#define CSL_CACHE_L1DWIWC_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1DWIWC_CNT_MASK       (0x0000FFFFu)
#define CSL_CACHE_L1DWIWC_CNT_SHIFT      (0x00000000u)
#define CSL_CACHE_L1DWIWC_CNT_RESETVAL   (0x00000000u)

#define CSL_CACHE_L1DWIWC_RESETVAL       (0x00000000u)

/* L1DIBAR */

#define CSL_CACHE_L1DIBAR_ADDR_MASK      (0xFFFFFFFFu)
#define CSL_CACHE_L1DIBAR_ADDR_SHIFT     (0x00000000u)
#define CSL_CACHE_L1DIBAR_ADDR_RESETVAL  (0x00000000u)

#define CSL_CACHE_L1DIBAR_RESETVAL       (0x00000000u)

/* L1DIWC */

#define CSL_CACHE_L1DIWC_RESERVED_MASK   (0xFFFF0000u)
#define CSL_CACHE_L1DIWC_RESERVED_SHIFT  (0x00000010u)
#define CSL_CACHE_L1DIWC_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1DIWC_CNT_MASK        (0x0000FFFFu)
#define CSL_CACHE_L1DIWC_CNT_SHIFT       (0x00000000u)
#define CSL_CACHE_L1DIWC_CNT_RESETVAL    (0x00000000u)

#define CSL_CACHE_L1DIWC_RESETVAL        (0x00000000u)

/* L1PIBAR */

#define CSL_CACHE_L1PIBAR_ADDR_MASK      (0xFFFFFFFFu)
#define CSL_CACHE_L1PIBAR_ADDR_SHIFT     (0x00000000u)
#define CSL_CACHE_L1PIBAR_ADDR_RESETVAL  (0x00000000u)

#define CSL_CACHE_L1PIBAR_RESETVAL       (0x00000000u)

/* L1PIWC */

#define CSL_CACHE_L1PIWC_RESERVED_MASK   (0xFFFF0000u)
#define CSL_CACHE_L1PIWC_RESERVED_SHIFT  (0x00000010u)
#define CSL_CACHE_L1PIWC_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1PIWC_CNT_MASK        (0x0000FFFFu)
#define CSL_CACHE_L1PIWC_CNT_SHIFT       (0x00000000u)
#define CSL_CACHE_L1PIWC_CNT_RESETVAL    (0x00000000u)

#define CSL_CACHE_L1PIWC_RESETVAL        (0x00000000u)

/* L1PCFG */

#define CSL_CACHE_L1PCFG_RESERVED_MASK   (0xFFFFFFF8u)
#define CSL_CACHE_L1PCFG_RESERVED_SHIFT  (0x00000003u)
#define CSL_CACHE_L1PCFG_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1PCFG_MODE_MASK       (0x00000007u)
#define CSL_CACHE_L1PCFG_MODE_SHIFT      (0x00000000u)
#define CSL_CACHE_L1PCFG_MODE_RESETVAL   (0x00000000u)

/*----MODE Tokens----*/
#define CSL_CACHE_L1PCFG_MODE_OFF        (0x00000000u)
#define CSL_CACHE_L1PCFG_MODE_0K         (0x00000000u)
#define CSL_CACHE_L1PCFG_MODE_4K         (0x00000001u)
#define CSL_CACHE_L1PCFG_MODE_8K         (0x00000002u)
#define CSL_CACHE_L1PCFG_MODE_16K        (0x00000003u)
#define CSL_CACHE_L1PCFG_MODE_32K        (0x00000004u)

#define CSL_CACHE_L1PCFG_RESETVAL        (0x00000000u)

/* L1DCFG */

#define CSL_CACHE_L1DCFG_RESERVED_MASK   (0xFFFFFFF8u)
#define CSL_CACHE_L1DCFG_RESERVED_SHIFT  (0x00000003u)
#define CSL_CACHE_L1DCFG_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1DCFG_MODE_MASK       (0x00000007u)
#define CSL_CACHE_L1DCFG_MODE_SHIFT      (0x00000000u)
#define CSL_CACHE_L1DCFG_MODE_RESETVAL   (0x00000000u)

/*----MODE Tokens----*/
#define CSL_CACHE_L1DCFG_MODE_OFF        (0x00000000u)
#define CSL_CACHE_L1DCFG_MODE_0K         (0x00000000u)
#define CSL_CACHE_L1DCFG_MODE_4K         (0x00000001u)
#define CSL_CACHE_L1DCFG_MODE_8K         (0x00000002u)
#define CSL_CACHE_L1DCFG_MODE_16K        (0x00000003u)
#define CSL_CACHE_L1DCFG_MODE_32K        (0x00000004u)

#define CSL_CACHE_L1DCFG_RESETVAL        (0x00000000u)

/* L1PCC */

#define CSL_CACHE_L1PCC_RESERVED_MASK    (0xFFFE0000u)
#define CSL_CACHE_L1PCC_RESERVED_SHIFT   (0x00000011u)
#define CSL_CACHE_L1PCC_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1PCC_POPER_MASK       (0x00010000u)
#define CSL_CACHE_L1PCC_POPER_SHIFT      (0x00000010u)
#define CSL_CACHE_L1PCC_POPER_RESETVAL   (0x00000000u)

/*----POPER Tokens----*/
#define CSL_CACHE_L1PCC_POPER_NORM       (0x00000000u)
#define CSL_CACHE_L1PCC_POPER_FREEZE     (0x00000001u)

#define CSL_CACHE_L1PCC_OPER_MASK        (0x00000001u)
#define CSL_CACHE_L1PCC_OPER_SHIFT       (0x00000000u)
#define CSL_CACHE_L1PCC_OPER_RESETVAL    (0x00000000u)

/*----OPER Tokens----*/
#define CSL_CACHE_L1PCC_OPER_NORM        (0x00000000u)
#define CSL_CACHE_L1PCC_OPER_FREEZE      (0x00000001u)

#define CSL_CACHE_L1PCC_RESETVAL         (0x00000000u)

/* L1DCC */

#define CSL_CACHE_L1DCC_RESERVED_MASK    (0xFFFE0000u)
#define CSL_CACHE_L1DCC_RESERVED_SHIFT   (0x00000011u)
#define CSL_CACHE_L1DCC_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1DCC_POPER_MASK       (0x00010000u)
#define CSL_CACHE_L1DCC_POPER_SHIFT      (0x00000010u)
#define CSL_CACHE_L1DCC_POPER_RESETVAL   (0x00000000u)

/*----POPER Tokens----*/
#define CSL_CACHE_L1DCC_POPER_NORM       (0x00000000u)
#define CSL_CACHE_L1DCC_POPER_FREEZE     (0x00000001u)

#define CSL_CACHE_L1DCC_OPER_MASK        (0x00000001u)
#define CSL_CACHE_L1DCC_OPER_SHIFT       (0x00000000u)
#define CSL_CACHE_L1DCC_OPER_RESETVAL    (0x00000000u)

/*----OPER Tokens----*/
#define CSL_CACHE_L1DCC_OPER_NORM        (0x00000000u)
#define CSL_CACHE_L1DCC_OPER_FREEZE      (0x00000001u)

#define CSL_CACHE_L1DCC_RESETVAL         (0x00000000u)

/* L2WB */

#define CSL_CACHE_L2WB_RESERVED_MASK     (0xFFFFFFFEu)
#define CSL_CACHE_L2WB_RESERVED_SHIFT    (0x00000001u)
#define CSL_CACHE_L2WB_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L2WB_CMDANDSTAT_MASK   (0x00000001u)
#define CSL_CACHE_L2WB_CMDANDSTAT_SHIFT  (0x00000000u)
#define CSL_CACHE_L2WB_CMDANDSTAT_RESETVAL (0x00000000u)

/*----CMDANDSTAT Tokens----*/
#define CSL_CACHE_L2WB_CMDANDSTAT_WB     (0x00000001u)
#define CSL_CACHE_L2WB_CMDANDSTAT_DONE   (0x00000000u)
#define CSL_CACHE_L2WB_CMDANDSTAT_NOTDONE (0x00000001u)

#define CSL_CACHE_L2WB_RESETVAL          (0x00000000u)

/* L2WBINV */

#define CSL_CACHE_L2WBINV_RESERVED_MASK  (0xFFFFFFFEu)
#define CSL_CACHE_L2WBINV_RESERVED_SHIFT (0x00000001u)
#define CSL_CACHE_L2WBINV_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L2WBINV_CMDANDSTAT_MASK (0x00000001u)
#define CSL_CACHE_L2WBINV_CMDANDSTAT_SHIFT (0x00000000u)
#define CSL_CACHE_L2WBINV_CMDANDSTAT_RESETVAL (0x00000000u)

/*----CMDANDSTAT Tokens----*/
#define CSL_CACHE_L2WBINV_CMDANDSTAT_WBINV (0x00000001u)
#define CSL_CACHE_L2WBINV_CMDANDSTAT_DONE (0x00000000u)
#define CSL_CACHE_L2WBINV_CMDANDSTAT_NOTDONE (0x00000001u)

#define CSL_CACHE_L2WBINV_RESETVAL       (0x00000000u)

/* L2INV */

#define CSL_CACHE_L2INV_RESERVED_MASK    (0xFFFFFFFEu)
#define CSL_CACHE_L2INV_RESERVED_SHIFT   (0x00000001u)
#define CSL_CACHE_L2INV_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L2INV_CMDANDSTAT_MASK  (0x00000001u)
#define CSL_CACHE_L2INV_CMDANDSTAT_SHIFT (0x00000000u)
#define CSL_CACHE_L2INV_CMDANDSTAT_RESETVAL (0x00000000u)

/*----CMDANDSTAT Tokens----*/
#define CSL_CACHE_L2INV_CMDANDSTAT_INV   (0x00000001u)
#define CSL_CACHE_L2INV_CMDANDSTAT_DONE  (0x00000000u)
#define CSL_CACHE_L2INV_CMDANDSTAT_NOTDONE (0x00000001u)

#define CSL_CACHE_L2INV_RESETVAL         (0x00000000u)

/* L1DWB */

#define CSL_CACHE_L1DWB_RESERVED_MASK    (0xFFFFFFFEu)
#define CSL_CACHE_L1DWB_RESERVED_SHIFT   (0x00000001u)
#define CSL_CACHE_L1DWB_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1DWB_CMDANDSTAT_MASK  (0x00000001u)
#define CSL_CACHE_L1DWB_CMDANDSTAT_SHIFT (0x00000000u)
#define CSL_CACHE_L1DWB_CMDANDSTAT_RESETVAL (0x00000000u)

/*----CMDANDSTAT Tokens----*/
#define CSL_CACHE_L1DWB_CMDANDSTAT_WB    (0x00000001u)
#define CSL_CACHE_L1DWB_CMDANDSTAT_DONE  (0x00000000u)
#define CSL_CACHE_L1DWB_CMDANDSTAT_NOTDONE (0x00000001u)

#define CSL_CACHE_L1DWB_RESETVAL         (0x00000000u)

/* L1DWBINV */

#define CSL_CACHE_L1DWBINV_RESERVED_MASK (0xFFFFFFFEu)
#define CSL_CACHE_L1DWBINV_RESERVED_SHIFT (0x00000001u)
#define CSL_CACHE_L1DWBINV_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1DWBINV_CMDANDSTAT_MASK (0x00000001u)
#define CSL_CACHE_L1DWBINV_CMDANDSTAT_SHIFT (0x00000000u)
#define CSL_CACHE_L1DWBINV_CMDANDSTAT_RESETVAL (0x00000000u)

/*----CMDANDSTAT Tokens----*/
#define CSL_CACHE_L1DWBINV_CMDANDSTAT_WBINV (0x00000001u)
#define CSL_CACHE_L1DWBINV_CMDANDSTAT_DONE (0x00000000u)
#define CSL_CACHE_L1DWBINV_CMDANDSTAT_NOTDONE (0x00000001u)

#define CSL_CACHE_L1DWBINV_RESETVAL      (0x00000000u)

/* L1DINV */

#define CSL_CACHE_L1DINV_RESERVED_MASK   (0xFFFFFFFEu)
#define CSL_CACHE_L1DINV_RESERVED_SHIFT  (0x00000001u)
#define CSL_CACHE_L1DINV_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1DINV_CMDANDSTAT_MASK (0x00000001u)
#define CSL_CACHE_L1DINV_CMDANDSTAT_SHIFT (0x00000000u)
#define CSL_CACHE_L1DINV_CMDANDSTAT_RESETVAL (0x00000000u)

/*----CMDANDSTAT Tokens----*/
#define CSL_CACHE_L1DINV_CMDANDSTAT_INV  (0x00000001u)
#define CSL_CACHE_L1DINV_CMDANDSTAT_DONE (0x00000000u)
#define CSL_CACHE_L1DINV_CMDANDSTAT_NOTDONE (0x00000001u)

#define CSL_CACHE_L1DINV_RESETVAL        (0x00000000u)

/* L1PINV */

#define CSL_CACHE_L1PINV_RESERVED_MASK   (0xFFFFFFFEu)
#define CSL_CACHE_L1PINV_RESERVED_SHIFT  (0x00000001u)
#define CSL_CACHE_L1PINV_RESERVED_RESETVAL (0x00000000u)

#define CSL_CACHE_L1PINV_CMDANDSTAT_MASK (0x00000001u)
#define CSL_CACHE_L1PINV_CMDANDSTAT_SHIFT (0x00000000u)
#define CSL_CACHE_L1PINV_CMDANDSTAT_RESETVAL (0x00000000u)

/*----CMDANDSTAT Tokens----*/
#define CSL_CACHE_L1PINV_CMDANDSTAT_INV  (0x00000001u)
#define CSL_CACHE_L1PINV_CMDANDSTAT_DONE (0x00000000u)
#define CSL_CACHE_L1PINV_CMDANDSTAT_NOTDONE (0x00000001u)
#define CSL_CACHE_L1PINV_CMDANDSTAT_     (0x00000000u)

#define CSL_CACHE_L1PINV_RESETVAL        (0x00000000u)

/* MAR */

#define CSL_CACHE_MAR_RESERVED_MASK      (0xFFFFFFFEu)
#define CSL_CACHE_MAR_RESERVED_SHIFT     (0x00000001u)
#define CSL_CACHE_MAR_RESERVED_RESETVAL  (0x00000000u)

#define CSL_CACHE_MAR_PC_MASK            (0x00000001u)
#define CSL_CACHE_MAR_PC_SHIFT           (0x00000000u)
#define CSL_CACHE_MAR_PC_RESETVAL        (0x00000000u)

#define CSL_CACHE_MAR_RESETVAL           (0x00000000u)

#endif
