/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2011
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
 Examples to show the usage and performance of SRIO on Keystone DSP
 these tests are internal loopback
* =============================================================================
 *  Revision History
 *  ===============
 *  June 13, 2011 Brighton Feng   File Created
 * ============================================================================
 */
#include <stdio.h>
#include "SRIO_PktDMA_Init.h"
#include "SRIO_test.h"
#include "SRIO_debug.h"
#include "SRIO_loopback_test.h"

float internal_speed[]= {5, 3.125, 2.5, 1.25};

SRIO_1x2x4x_Path_Control internal_path[]=
{
	SRIO_PATH_CTL_1xLaneA, 

	SRIO_PATH_CTL_2xLaneAB,
	SRIO_PATH_CTL_4xLaneABCD
};

SRIO_Multiple_Test_Config internal_multi_port_test_cfg[]=
{
    {SRIO_PATH_CTL_1xLaneA_1xLaneB_1xLaneC_1xLaneD, /*multiple_port_path*/
        /*packet_type               source                                                   dest                                                size*/
        {{SRIO_PKT_TYPE_NREAD,      ((Uint32)&packetBuffer_LL2_Size1[0][0])+0x12000000,     ((Uint32)&packetBuffer_LL2_Size1[0][0])+0x13000000, LL2_PACKET_BUFFER_SIZE1},   /*port0*/
        {SRIO_PKT_TYPE_NWRITE,      ((Uint32)&packetBuffer_LL2_Size1[1][0])+0x12000000,     ((Uint32)&packetBuffer_LL2_Size1[1][0])+0x13000000, LL2_PACKET_BUFFER_SIZE1},   /*port1*/
        {SRIO_PKT_TYPE_NWRITE_R,    ((Uint32)&packetBuffer_LL2_Size1[2][0])+0x12000000,     ((Uint32)&packetBuffer_LL2_Size1[2][0])+0x13000000, LL2_PACKET_BUFFER_SIZE1},   /*port2*/
        {SRIO_PKT_TYPE_SWRITE,      ((Uint32)&packetBuffer_LL2_Size1[3][0])+0x12000000,     ((Uint32)&packetBuffer_LL2_Size1[3][0])+0x13000000, LL2_PACKET_BUFFER_SIZE1}}    /*port3*/
    },

};



/*test SRIO transfer through multiple ports in parallel*/
void srio_multiple_ports_internal_loopback_test()
{

	Uint32 uiNumTestCases;

	SRIO_Multiple_Test_Config * test_cfg;

	printf("SRIO mulitple ports test with link speed %.3fGbps\n", SRIO_DEFAULT_TEST_SPEED);
	serdesLinkSetup.linkSpeed_GHz= SRIO_DEFAULT_TEST_SPEED;

	//test different cases
	uiNumTestCases = 
		sizeof(internal_multi_port_test_cfg)/sizeof(SRIO_Multiple_Test_Config);

	printf("\nuiNumTestCases=%d\n",uiNumTestCases);

		test_cfg= &internal_multi_port_test_cfg[0];
	   	srio_cfg.srio_1x2x4x_path_control= SRIO_PATH_CTL_1xLaneA_1xLaneB_1xLaneC_1xLaneD;
		srio_identify_used_ports_lanes(srio_cfg.srio_1x2x4x_path_control);
		printf("\nEnter Keystone_SRIO_Init");
		Keystone_SRIO_Init(&srio_cfg);
		printf("\nEnter SRIO_PktDM_init");
		SRIO_PktDM_init();
		printf("\nEnter srio_multiple_port_transfer");
		srio_multiple_port_transfer(test_cfg);
		puts("");
}

