/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2011
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
* ============================================================================
 Examples to show the usage and performance of SRIO on Keystone DSP
 these tests are loopback test
* =============================================================================
 *  Revision History
 *  ===============
 *  June 13, 2011 Brighton Feng   File Created
 * ============================================================================
 */
#include <stdio.h>
#include <ti/csl/csl_qm_queue.h>
#include "SRIO_PktDMA_Init.h"
#include "SRIO_test.h"
#include "TSC.h"
#include "SRIO_debug.h"



Uint32 directIO_src_dest[][2]=
{
	{((Uint32)&packetBuffer_LL2_Size1[0][0])+0x10000000,	((Uint32)&packetBuffer_LL2_Size1[1][0])+0x10000000}, 	/*LL2->LL2*/
	{((Uint32)&packetBuffer_LL2_Size1[0][0])+0x10000000,	((Uint32)&packetBuffer_SL2_Size1[1][0])}, 				/*LL2->SL2*/
	{((Uint32)&packetBuffer_LL2_Size1[0][0])+0x10000000,	((Uint32)&packetBuffer_DDR_Size1[1][0])}, 				/*LL2->DDR*/
	{((Uint32)&packetBuffer_SL2_Size1[0][0]),				((Uint32)&packetBuffer_LL2_Size1[1][0])+0x10000000}, 	/*SL2->LL2*/
	{((Uint32)&packetBuffer_SL2_Size1[0][0]),				((Uint32)&packetBuffer_SL2_Size1[1][0])}, 				/*SL2->SL2*/
	{((Uint32)&packetBuffer_SL2_Size1[0][0]),				((Uint32)&packetBuffer_DDR_Size1[1][0])}, 				/*SL2->DDR*/
	{((Uint32)&packetBuffer_DDR_Size1[0][0]),				((Uint32)&packetBuffer_LL2_Size1[1][0])+0x10000000}, 	/*DDR->LL2*/
	{((Uint32)&packetBuffer_DDR_Size1[0][0]),				((Uint32)&packetBuffer_SL2_Size1[1][0])}, 				/*DDR->SL2*/
	{((Uint32)&packetBuffer_DDR_Size1[0][0]),				((Uint32)&packetBuffer_DDR_Size1[1][0])}, 				/*DDR->DDR*/
};



/*transfer through multiple SRIO ports in parallel*/
void srio_multiple_port_transfer(SRIO_Multiple_Test_Config * test_cfg)
{
	int j;
	SRIO_Transfer_Param * transferParam;
	SRIO_LSU_Transfer lsuTransfer[4];
	Int32 uiCompletionCode[4]= {-1, -1, -1, -1}, uiCompletion_context_code;
	Uint32 cycles[4];
	Uint32 uiWordIndex;
	Uint32 * uipSrc[4], * uipDst[4], uiByteCount[4];
	SRIO_Packet_Type packet_type[4];

	//prepare all transfer requests
	for(j= 0; j< 4; j++)
	{
		transferParam= &test_cfg->transfer_param[j];
		uiByteCount[j]= transferParam->byteCount;
		if(0==uiByteCount[j])
		{
			uiCompletionCode[j]= 0;
			continue;
		}

		packet_type[j]= transferParam->packet_type;
		if(packet_type[j]<0x90) 	//directIO
		{
			uipSrc[j] = (Uint32 *)transferParam->source;
			uipDst[j]= (Uint32 *)transferParam->dest;

			/*initialize buffer*/
			InitDataBuffer(uipSrc[j], uipDst[j], uiByteCount[j]);

			InitLsuTransfer(&lsuTransfer[j], transferParam, j,
				DSP0_SRIO_BASE_ID+j, j);
        }
		else 	//message
		{
			printf("\npacket type wrong!");
		}
        
    }   

    //submit all transfers
	for(j= 0; j< 4; j++)
	{
		transferParam= &test_cfg->transfer_param[j];
		if(0==uiByteCount[j])
			continue;
		if(packet_type[j]<0x90) 	//directIO
		{

			cycles[j]= TSCL;
			Keystone_SRIO_LSU_transfer(&lsuTransfer[j]);

		}

	}

	printf("\nwaiting\n");
	//wait all transfers complete
	while((-1==uiCompletionCode[0])||(-1==uiCompletionCode[1])||
		(-1==uiCompletionCode[2])||(-1==uiCompletionCode[3]))
	{
		for(j= 0; j< 4; j++)
		{
			if(-1!=uiCompletionCode[j])
				continue;

			if(packet_type[j]<0x90) 	//DirectIO
			{

				uiCompletion_context_code= 
					Keystone_SRIO_get_LSU_completion_context_code(j,
					lsuTransfer[j].transactionID);

				uiWordIndex= uiByteCount[j]/4-1;
				Invalid((void *)&uipSrc[j][uiWordIndex], 4);
				Invalid((void *)&uipDst[j][uiWordIndex], 4);

				if((uipSrc[j][uiWordIndex]==uipDst[j][uiWordIndex])&&
					((uiCompletion_context_code&1)==lsuTransfer[j].contextBit))
				{
					cycles[j]= TSC_delay_cycle(cycles[j]);
                    uiCompletionCode[j]= uiCompletion_context_code>>1;
				}
			}
			else 	//message
			{
				printf("\npacket type wrong!");
			}
		}
	}
	//check and print result
	for(j= 0; j< 4; j++)
	{
		if(0==uiByteCount[j])
			continue;

		printf("%s from 0x%8x to 0x%8x through port %d, %6d bytes, %6d cycles, %5lld Mbps, completion code = %d\n", 
			get_packet_type_string(packet_type[j]),
			uipSrc[j], uipDst[j], j, uiByteCount[j], cycles[j],
			(unsigned long long)uiByteCount[j]*8*CPU_CLK_KHZ/cycles[j]/1000, 
			uiCompletionCode[j]);

		VerifyData(uipSrc[j], uipDst[j], uiByteCount[j]);
	}

}

