/*
 * cslr_lcdc.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


/** ============================================================================
 *   @file  cslr_lcd.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for LCD
 *  ============================================================================
 */


#ifndef _CSLR_LCDC_H_
#define _CSLR_LCDC_H_

#ifdef __cplusplus
extern "C" {
#endif


#include <ti/pspiom/cslr/cslr.h>
#include <ti/pspiom/cslr/tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REV;
    volatile Uint32 LCD_CTRL;
    volatile Uint32 LCD_STAT;
    volatile Uint32 LIDD_CTRL;
    volatile Uint32 LIDD_CS0_CONF;
    volatile Uint32 LIDD_CS0_ADDR;
    volatile Uint32 LIDD_CS0_DATA;
    volatile Uint32 LIDD_CS1_CONF;
    volatile Uint32 LIDD_CS1_ADDR;
    volatile Uint32 LIDD_CS1_DATA;
    volatile Uint32 RASTER_CTRL;
    volatile Uint32 RASTER_TIMING_0;
    volatile Uint32 RASTER_TIMING_1;
    volatile Uint32 RASTER_TIMING_2;
    volatile Uint32 RASTER_SUBPANEL;
    volatile Uint32 RSVD0;
    volatile Uint32 LCDDMA_CTRL;
    volatile Uint32 LCDDMA_FB0_BASE;
    volatile Uint32 LCDDMA_FB0_CEILING;
    volatile Uint32 LCDDMA_FB1_BASE;
    volatile Uint32 LCDDMA_FB1_CEILING;
} CSL_LcdcRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_LcdcRegs             * CSL_LcdcRegsOvly;
/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* LCD_REV */

#define CSL_LCDC_REVID_REV_MASK (0xFFFFFFFFu)
#define CSL_LCDC_REVID_REV_SHIFT (0x00000000u)
#define CSL_LCDC_REVID_REV_RESETVAL (0x4C100100u)


#define CSL_LCDC_REVID_RESETVAL (0x4C100100u)

/* LCD_CTRL */


#define CSL_LCDC_LCD_CTRL_CLKDIV_MASK (0x0000FF00u)
#define CSL_LCDC_LCD_CTRL_CLKDIV_SHIFT (0x00000008u)
#define CSL_LCDC_LCD_CTRL_CLKDIV_RESETVAL (0x00000000u)


#define CSL_LCDC_LCD_CTRL_MODESEL_MASK (0x00000001u)
#define CSL_LCDC_LCD_CTRL_MODESEL_SHIFT (0x00000000u)
#define CSL_LCDC_LCD_CTRL_MODESEL_RESETVAL (0x00000000u)
/*----MODESEL Tokens----*/
#define CSL_LCDC_LCD_CTRL_MODESEL_LIDD (0x00000000u)
#define CSL_LCDC_LCD_CTRL_MODESEL_RASTER (0x00000001u)

#define CSL_LCDC_LCD_CTRL_RESETVAL (0x00000000u)

/* LCD_STAT */


#define CSL_LCDC_LCD_STAT_EOF1_MASK (0x00000200u)
#define CSL_LCDC_LCD_STAT_EOF1_SHIFT (0x00000009u)
#define CSL_LCDC_LCD_STAT_EOF1_RESETVAL (0x00000000u)
/*----EOF1 Tokens----*/
#define CSL_LCDC_LCD_STAT_EOF1_EOF1_NO_DETECT (0x00000000u)
#define CSL_LCDC_LCD_STAT_EOF1_EOF1_DETECT (0x00000001u)

#define CSL_LCDC_LCD_STAT_EOF0_MASK (0x00000100u)
#define CSL_LCDC_LCD_STAT_EOF0_SHIFT (0x00000008u)
#define CSL_LCDC_LCD_STAT_EOF0_RESETVAL (0x00000000u)
/*----EOF0 Tokens----*/
#define CSL_LCDC_LCD_STAT_EOF0_EOF0_NO_DETECT (0x00000000u)
#define CSL_LCDC_LCD_STAT_EOF0_EOF0_DETECT (0x00000001u)


#define CSL_LCDC_LCD_STAT_PL_MASK (0x00000040u)
#define CSL_LCDC_LCD_STAT_PL_SHIFT (0x00000006u)
#define CSL_LCDC_LCD_STAT_PL_RESETVAL (0x00000000u)
/*----PL Tokens----*/
#define CSL_LCDC_LCD_STAT_PL_NO (0x00000000u)
#define CSL_LCDC_LCD_STAT_PL_YES (0x00000001u)

#define CSL_LCDC_LCD_STAT_FUF_MASK (0x00000020u)
#define CSL_LCDC_LCD_STAT_FUF_SHIFT (0x00000005u)
#define CSL_LCDC_LCD_STAT_FUF_RESETVAL (0x00000000u)
/*----FUF Tokens----*/
#define CSL_LCDC_LCD_STAT_FUF_NO (0x00000000u)
#define CSL_LCDC_LCD_STAT_FUF_YES (0x00000001u)


#define CSL_LCDC_LCD_STAT_ABC_MASK (0x00000008u)
#define CSL_LCDC_LCD_STAT_ABC_SHIFT (0x00000003u)
#define CSL_LCDC_LCD_STAT_ABC_RESETVAL (0x00000000u)
/*----ABC Tokens----*/
#define CSL_LCDC_LCD_STAT_ABC_NOT_ZERO (0x00000000u)
#define CSL_LCDC_LCD_STAT_ABC_ZERO (0x00000001u)

#define CSL_LCDC_LCD_STAT_SYNC_MASK (0x00000004u)
#define CSL_LCDC_LCD_STAT_SYNC_SHIFT (0x00000002u)
#define CSL_LCDC_LCD_STAT_SYNC_RESETVAL (0x00000000u)
/*----SYNC Tokens----*/
#define CSL_LCDC_LCD_STAT_SYNC_NORMAL (0x00000000u)
#define CSL_LCDC_LCD_STAT_SYNC_SYNC_LOST (0x00000001u)


#define CSL_LCDC_LCD_STAT_DONE_MASK (0x00000001u)
#define CSL_LCDC_LCD_STAT_DONE_SHIFT (0x00000000u)
#define CSL_LCDC_LCD_STAT_DONE_RESETVAL (0x00000000u)
/*----DONE Tokens----*/
#define CSL_LCDC_LCD_STAT_DONE_ENABLE (0x00000000u)
#define CSL_LCDC_LCD_STAT_DONE_DISABLE (0x00000001u)

#define CSL_LCDC_LCD_STAT_RESETVAL (0x00000000u)

/* LIDD_CTRL */


#define CSL_LCDC_LIDD_CTRL_DONE_INT_EN_MASK (0x00000400u)
#define CSL_LCDC_LIDD_CTRL_DONE_INT_EN_SHIFT (0x0000000Au)
#define CSL_LCDC_LIDD_CTRL_DONE_INT_EN_RESETVAL (0x00000000u)
/*----DONE_INT_EN Tokens----*/
#define CSL_LCDC_LIDD_CTRL_DONE_INT_EN_DISABLE (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_DONE_INT_EN_ENABLE (0x00000001u)

#define CSL_LCDC_LIDD_CTRL_DMA_CS0_CS1_MASK (0x00000200u)
#define CSL_LCDC_LIDD_CTRL_DMA_CS0_CS1_SHIFT (0x00000009u)
#define CSL_LCDC_LIDD_CTRL_DMA_CS0_CS1_RESETVAL (0x00000000u)
/*----DMA_CS0_CS1 Tokens----*/
#define CSL_LCDC_LIDD_CTRL_DMA_CS0_CS1_DMA_TO_CS0 (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_DMA_CS0_CS1_DMA_TO_CS1 (0x00000001u)

#define CSL_LCDC_LIDD_CTRL_LIDD_DMA_EN_MASK (0x00000100u)
#define CSL_LCDC_LIDD_CTRL_LIDD_DMA_EN_SHIFT (0x00000008u)
#define CSL_LCDC_LIDD_CTRL_LIDD_DMA_EN_RESETVAL (0x00000000u)
/*----LIDD_DMA_EN Tokens----*/
#define CSL_LCDC_LIDD_CTRL_LIDD_DMA_EN_DEACTIVATE_DMA (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_LIDD_DMA_EN_ACTIVATE_DMA (0x00000001u)

#define CSL_LCDC_LIDD_CTRL_CS1_E1_POL_MASK (0x00000080u)
#define CSL_LCDC_LIDD_CTRL_CS1_E1_POL_SHIFT (0x00000007u)
#define CSL_LCDC_LIDD_CTRL_CS1_E1_POL_RESETVAL (0x00000000u)
/*----CS1_E1_POL Tokens----*/
#define CSL_LCDC_LIDD_CTRL_CS1_E1_POL_DONOT_INVERT (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_CS1_E1_POL_INVERT (0x00000001u)

#define CSL_LCDC_LIDD_CTRL_CS0_E0_POL_MASK (0x00000040u)
#define CSL_LCDC_LIDD_CTRL_CS0_E0_POL_SHIFT (0x00000006u)
#define CSL_LCDC_LIDD_CTRL_CS0_E0_POL_RESETVAL (0x00000000u)
/*----CS0_E0_POL Tokens----*/
#define CSL_LCDC_LIDD_CTRL_CS0_E0_POL_DONOT_INVERT (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_CS0_E0_POL_INVERT (0x00000001u)

#define CSL_LCDC_LIDD_CTRL_WS_DIR_POL_MASK (0x00000020u)
#define CSL_LCDC_LIDD_CTRL_WS_DIR_POL_SHIFT (0x00000005u)
#define CSL_LCDC_LIDD_CTRL_WS_DIR_POL_RESETVAL (0x00000000u)
/*----WS_DIR_POL Tokens----*/
#define CSL_LCDC_LIDD_CTRL_WS_DIR_POL_DONOT_INVERT (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_WS_DIR_POL_INVERT (0x00000001u)

#define CSL_LCDC_LIDD_CTRL_RS_EN_POL_MASK (0x00000010u)
#define CSL_LCDC_LIDD_CTRL_RS_EN_POL_SHIFT (0x00000004u)
#define CSL_LCDC_LIDD_CTRL_RS_EN_POL_RESETVAL (0x00000000u)
/*----RS_EN_POL Tokens----*/
#define CSL_LCDC_LIDD_CTRL_RS_EN_POL_DONOT_INVERT (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_RS_EN_POL_INVERT (0x00000001u)

#define CSL_LCDC_LIDD_CTRL_ALEPOL_MASK (0x00000008u)
#define CSL_LCDC_LIDD_CTRL_ALEPOL_SHIFT (0x00000003u)
#define CSL_LCDC_LIDD_CTRL_ALEPOL_RESETVAL (0x00000000u)
/*----ALEPOL Tokens----*/
#define CSL_LCDC_LIDD_CTRL_ALEPOL_DONOT_INVERT (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_ALEPOL_INVERT (0x00000001u)

#define CSL_LCDC_LIDD_CTRL_LIDD_MODE_SEL_MASK (0x00000007u)
#define CSL_LCDC_LIDD_CTRL_LIDD_MODE_SEL_SHIFT (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_LIDD_MODE_SEL_RESETVAL (0x00000000u)
/*----LIDD_MODE_SEL Tokens----*/
#define CSL_LCDC_LIDD_CTRL_LIDD_MODE_SEL_SYNC_MPU68 (0x00000000u)
#define CSL_LCDC_LIDD_CTRL_LIDD_MODE_SEL_ASYNC_MPU68 (0x00000001u)
#define CSL_LCDC_LIDD_CTRL_LIDD_MODE_SEL_SYNC_MPU80 (0x00000002u)
#define CSL_LCDC_LIDD_CTRL_LIDD_MODE_SEL_ASYNC_MPU80 (0x00000003u)
#define CSL_LCDC_LIDD_CTRL_LIDD_MODE_SEL_HITACHI (0x00000004u)

#define CSL_LCDC_LIDD_CTRL_RESETVAL (0x00000000u)

/* LIDD_CS0_CONF */

#define CSL_LCDC_LIDD_CS0_CONF_W_SU_MASK (0xF8000000u)
#define CSL_LCDC_LIDD_CS0_CONF_W_SU_SHIFT (0x0000001Bu)
#define CSL_LCDC_LIDD_CS0_CONF_W_SU_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS0_CONF_W_STROBE_MASK (0x07E00000u)
#define CSL_LCDC_LIDD_CS0_CONF_W_STROBE_SHIFT (0x00000015u)
#define CSL_LCDC_LIDD_CS0_CONF_W_STROBE_RESETVAL (0x00000001u)

#define CSL_LCDC_LIDD_CS0_CONF_W_HOLD_MASK (0x001E0000u)
#define CSL_LCDC_LIDD_CS0_CONF_W_HOLD_SHIFT (0x00000011u)
#define CSL_LCDC_LIDD_CS0_CONF_W_HOLD_RESETVAL (0x00000001u)

#define CSL_LCDC_LIDD_CS0_CONF_R_SU_MASK (0x0001F000u)
#define CSL_LCDC_LIDD_CS0_CONF_R_SU_SHIFT (0x0000000Cu)
#define CSL_LCDC_LIDD_CS0_CONF_R_SU_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS0_CONF_R_STROBE_MASK (0x00000FC0u)
#define CSL_LCDC_LIDD_CS0_CONF_R_STROBE_SHIFT (0x00000006u)
#define CSL_LCDC_LIDD_CS0_CONF_R_STROBE_RESETVAL (0x00000001u)

#define CSL_LCDC_LIDD_CS0_CONF_R_HOLD_MASK (0x0000003Cu)
#define CSL_LCDC_LIDD_CS0_CONF_R_HOLD_SHIFT (0x00000002u)
#define CSL_LCDC_LIDD_CS0_CONF_R_HOLD_RESETVAL (0x00000001u)

#define CSL_LCDC_LIDD_CS0_CONF_TA_MASK (0x00000003u)
#define CSL_LCDC_LIDD_CS0_CONF_TA_SHIFT (0x00000000u)
#define CSL_LCDC_LIDD_CS0_CONF_TA_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS0_CONF_RESETVAL (0x00220044u)

/* LIDD_CS0_ADDR */


#define CSL_LCDC_LIDD_CS0_ADDR_ADR_INDX_MASK (0x0000FFFFu)
#define CSL_LCDC_LIDD_CS0_ADDR_ADR_INDX_SHIFT (0x00000000u)
#define CSL_LCDC_LIDD_CS0_ADDR_ADR_INDX_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS0_ADDR_RESETVAL (0x00000000u)

/* LIDD_CS0_DATA */


#define CSL_LCDC_LIDD_CS0_DATA_DATA_MASK (0x0000FFFFu)
#define CSL_LCDC_LIDD_CS0_DATA_DATA_SHIFT (0x00000000u)
#define CSL_LCDC_LIDD_CS0_DATA_DATA_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS0_DATA_RESETVAL (0x00000000u)

/* LIDD_CS1_CONF */

#define CSL_LCDC_LIDD_CS1_CONF_W_SU_MASK (0xF8000000u)
#define CSL_LCDC_LIDD_CS1_CONF_W_SU_SHIFT (0x0000001Bu)
#define CSL_LCDC_LIDD_CS1_CONF_W_SU_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS1_CONF_W_STROBE_MASK (0x07E00000u)
#define CSL_LCDC_LIDD_CS1_CONF_W_STROBE_SHIFT (0x00000015u)
#define CSL_LCDC_LIDD_CS1_CONF_W_STROBE_RESETVAL (0x00000001u)

#define CSL_LCDC_LIDD_CS1_CONF_W_HOLD_MASK (0x001E0000u)
#define CSL_LCDC_LIDD_CS1_CONF_W_HOLD_SHIFT (0x00000011u)
#define CSL_LCDC_LIDD_CS1_CONF_W_HOLD_RESETVAL (0x00000001u)

#define CSL_LCDC_LIDD_CS1_CONF_R_SU_MASK (0x0001F000u)
#define CSL_LCDC_LIDD_CS1_CONF_R_SU_SHIFT (0x0000000Cu)
#define CSL_LCDC_LIDD_CS1_CONF_R_SU_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS1_CONF_R_STROBE_MASK (0x00000FC0u)
#define CSL_LCDC_LIDD_CS1_CONF_R_STROBE_SHIFT (0x00000006u)
#define CSL_LCDC_LIDD_CS1_CONF_R_STROBE_RESETVAL (0x00000001u)

#define CSL_LCDC_LIDD_CS1_CONF_R_HOLD_MASK (0x0000003Cu)
#define CSL_LCDC_LIDD_CS1_CONF_R_HOLD_SHIFT (0x00000002u)
#define CSL_LCDC_LIDD_CS1_CONF_R_HOLD_RESETVAL (0x00000001u)

#define CSL_LCDC_LIDD_CS1_CONF_TA_MASK (0x00000003u)
#define CSL_LCDC_LIDD_CS1_CONF_TA_SHIFT (0x00000000u)
#define CSL_LCDC_LIDD_CS1_CONF_TA_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS1_CONF_RESETVAL (0x00220044u)

/* LIDD_CS1_ADDR */


#define CSL_LCDC_LIDD_CS1_ADDR_ADR_INDX_MASK (0x0000FFFFu)
#define CSL_LCDC_LIDD_CS1_ADDR_ADR_INDX_SHIFT (0x00000000u)
#define CSL_LCDC_LIDD_CS1_ADDR_ADR_INDX_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS1_ADDR_RESETVAL (0x00000000u)

/* LIDD_CS1_DATA */


#define CSL_LCDC_LIDD_CS1_DATA_DATA_MASK (0x0000FFFFu)
#define CSL_LCDC_LIDD_CS1_DATA_DATA_SHIFT (0x00000000u)
#define CSL_LCDC_LIDD_CS1_DATA_DATA_RESETVAL (0x00000000u)

#define CSL_LCDC_LIDD_CS1_DATA_RESETVAL (0x00000000u)


/* RASTER_CTRL */


#define CSL_LCDC_RASTER_CTRL_STN_565_MASK (0x01000000u)
#define CSL_LCDC_RASTER_CTRL_STN_565_SHIFT (0x00000018u)
#define CSL_LCDC_RASTER_CTRL_STN_565_RESETVAL (0x00000000u)
/*----STN_565 Tokens----*/
#define CSL_LCDC_RASTER_CTRL_STN_565_DISABLE (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_STN_565_ENABLE (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_TFT_ALT_MAP_MASK (0x00800000u)
#define CSL_LCDC_RASTER_CTRL_TFT_ALT_MAP_SHIFT (0x00000017u)
#define CSL_LCDC_RASTER_CTRL_TFT_ALT_MAP_RESETVAL (0x00000000u)
/*----TFT_ALT_MAP Tokens----*/
#define CSL_LCDC_RASTER_CTRL_TFT_ALT_MAP_444_DATA (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_TFT_ALT_MAP_565_DATA (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_NIB_MODE_MASK (0x00400000u)
#define CSL_LCDC_RASTER_CTRL_NIB_MODE_SHIFT (0x00000016u)
#define CSL_LCDC_RASTER_CTRL_NIB_MODE_RESETVAL (0x00000000u)
/*----NIB_MODE Tokens----*/
#define CSL_LCDC_RASTER_CTRL_NIB_MODE_DISABLE (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_NIB_MODE_ENABLE (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_PLM_MASK (0x00300000u)
#define CSL_LCDC_RASTER_CTRL_PLM_SHIFT (0x00000014u)
#define CSL_LCDC_RASTER_CTRL_PLM_RESETVAL (0x00000000u)
/*----PLM Tokens----*/
#define CSL_LCDC_RASTER_CTRL_PLM_PALETTE_DATA (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_PLM_PALETTE (0x00000001u)
#define CSL_LCDC_RASTER_CTRL_PLM_DATA (0x00000002u)
#define CSL_LCDC_RASTER_CTRL_PLM_DONOT_USE (0x00000003u)

#define CSL_LCDC_RASTER_CTRL_FIFO_DMA_DELAY_MASK (0x000FF000u)
#define CSL_LCDC_RASTER_CTRL_FIFO_DMA_DELAY_SHIFT (0x0000000Cu)
#define CSL_LCDC_RASTER_CTRL_FIFO_DMA_DELAY_RESETVAL (0x00000000u)


#define CSL_LCDC_RASTER_CTRL_MONO8B_MASK (0x00000200u)
#define CSL_LCDC_RASTER_CTRL_MONO8B_SHIFT (0x00000009u)
#define CSL_LCDC_RASTER_CTRL_MONO8B_RESETVAL (0x00000000u)
/*----MONO8B Tokens----*/
#define CSL_LCDC_RASTER_CTRL_MONO8B_4DATA_PIN (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_MONO8B_8DATA_PIN (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_RD_ORDER_MASK (0x00000100u)
#define CSL_LCDC_RASTER_CTRL_RD_ORDER_SHIFT (0x00000008u)
#define CSL_LCDC_RASTER_CTRL_RD_ORDER_RESETVAL (0x00000000u)
/*----RD_ORDER Tokens----*/
#define CSL_LCDC_RASTER_CTRL_RD_ORDER_LSBTOMSB (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_RD_ORDER_MSBTOLSB (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_TFT_STN_MASK (0x00000080u)
#define CSL_LCDC_RASTER_CTRL_TFT_STN_SHIFT (0x00000007u)
#define CSL_LCDC_RASTER_CTRL_TFT_STN_RESETVAL (0x00000000u)
/*----TFT_STN Tokens----*/
#define CSL_LCDC_RASTER_CTRL_TFT_STN_STN (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_TFT_STN_TFT (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_FUF_EN_MASK (0x00000040u)
#define CSL_LCDC_RASTER_CTRL_FUF_EN_SHIFT (0x00000006u)
#define CSL_LCDC_RASTER_CTRL_FUF_EN_RESETVAL (0x00000000u)
/*----FUF_EN Tokens----*/
#define CSL_LCDC_RASTER_CTRL_FUF_EN_DISABLE (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_FUF_EN_ENABLE (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_SL_EN_MASK (0x00000020u)
#define CSL_LCDC_RASTER_CTRL_SL_EN_SHIFT (0x00000005u)
#define CSL_LCDC_RASTER_CTRL_SL_EN_RESETVAL (0x00000000u)
/*----SL_EN Tokens----*/
#define CSL_LCDC_RASTER_CTRL_SL_EN_DISABLE (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_SL_EN_ENABLE (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_PL_EN_MASK (0x00000010u)
#define CSL_LCDC_RASTER_CTRL_PL_EN_SHIFT (0x00000004u)
#define CSL_LCDC_RASTER_CTRL_PL_EN_RESETVAL (0x00000000u)
/*----PL_EN Tokens----*/
#define CSL_LCDC_RASTER_CTRL_PL_EN_DISABLE (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_PL_EN_ENABLE (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_DONE_EN_MASK (0x00000008u)
#define CSL_LCDC_RASTER_CTRL_DONE_EN_SHIFT (0x00000003u)
#define CSL_LCDC_RASTER_CTRL_DONE_EN_RESETVAL (0x00000000u)
/*----DONE_EN Tokens----*/
#define CSL_LCDC_RASTER_CTRL_DONE_EN_DISABLE (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_DONE_EN_ENABLE (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_AC_EN_MASK (0x00000004u)
#define CSL_LCDC_RASTER_CTRL_AC_EN_SHIFT (0x00000002u)
#define CSL_LCDC_RASTER_CTRL_AC_EN_RESETVAL (0x00000000u)
/*----AC_EN Tokens----*/
#define CSL_LCDC_RASTER_CTRL_AC_EN_DISABLE (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_AC_EN_ENABLE (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_MONO_COLOR_MASK (0x00000002u)
#define CSL_LCDC_RASTER_CTRL_MONO_COLOR_SHIFT (0x00000001u)
#define CSL_LCDC_RASTER_CTRL_MONO_COLOR_RESETVAL (0x00000000u)
/*----MONO_COLOR Tokens----*/
#define CSL_LCDC_RASTER_CTRL_MONO_COLOR_COLOR (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_MONO_COLOR_MONOCHROME (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_RASTER_EN_MASK (0x00000001u)
#define CSL_LCDC_RASTER_CTRL_RASTER_EN_SHIFT (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_RASTER_EN_RESETVAL (0x00000000u)
/*----RASTER_EN Tokens----*/
#define CSL_LCDC_RASTER_CTRL_RASTER_EN_DISABLE (0x00000000u)
#define CSL_LCDC_RASTER_CTRL_RASTER_EN_ENABLE (0x00000001u)

#define CSL_LCDC_RASTER_CTRL_RESETVAL (0x00000000u)

/* RASTER_TIMING_0 */

#define CSL_LCDC_RASTER_TIMING_0_HBP_MASK (0xFF000000u)
#define CSL_LCDC_RASTER_TIMING_0_HBP_SHIFT (0x00000018u)
#define CSL_LCDC_RASTER_TIMING_0_HBP_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_TIMING_0_HFP_MASK (0x00FF0000u)
#define CSL_LCDC_RASTER_TIMING_0_HFP_SHIFT (0x00000010u)
#define CSL_LCDC_RASTER_TIMING_0_HFP_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_TIMING_0_HSW_MASK (0x0000FC00u)
#define CSL_LCDC_RASTER_TIMING_0_HSW_SHIFT (0x0000000Au)
#define CSL_LCDC_RASTER_TIMING_0_HSW_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_TIMING_0_PPL_MASK (0x000003F0u)
#define CSL_LCDC_RASTER_TIMING_0_PPL_SHIFT (0x00000004u)
#define CSL_LCDC_RASTER_TIMING_0_PPL_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_TIMING_0_RESETVAL (0x00000000u)

/* RASTER_TIMING_1 */

#define CSL_LCDC_RASTER_TIMING_1_VBP_MASK (0xFF000000u)
#define CSL_LCDC_RASTER_TIMING_1_VBP_SHIFT (0x00000018u)
#define CSL_LCDC_RASTER_TIMING_1_VBP_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_TIMING_1_VFP_MASK (0x00FF0000u)
#define CSL_LCDC_RASTER_TIMING_1_VFP_SHIFT (0x00000010u)
#define CSL_LCDC_RASTER_TIMING_1_VFP_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_TIMING_1_VSW_MASK (0x0000FC00u)
#define CSL_LCDC_RASTER_TIMING_1_VSW_SHIFT (0x0000000Au)
#define CSL_LCDC_RASTER_TIMING_1_VSW_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_TIMING_1_LPP_MASK (0x000003FFu)
#define CSL_LCDC_RASTER_TIMING_1_LPP_SHIFT (0x00000000u)
#define CSL_LCDC_RASTER_TIMING_1_LPP_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_TIMING_1_RESETVAL (0x00000000u)

/* RASTER_TIMING_2 */


#define CSL_LCDC_RASTER_TIMING_2_SYNC_CTRL_MASK (0x02000000u)
#define CSL_LCDC_RASTER_TIMING_2_SYNC_CTRL_SHIFT (0x00000019u)
#define CSL_LCDC_RASTER_TIMING_2_SYNC_CTRL_RESETVAL (0x00000000u)
/*----SYNC_CTRL Tokens----*/
#define CSL_LCDC_RASTER_TIMING_2_SYNC_CTRL_INACTIVE (0x00000000u)
#define CSL_LCDC_RASTER_TIMING_2_SYNC_CTRL_ACTIVE (0x00000001u)

#define CSL_LCDC_RASTER_TIMING_2_SYNC_EDGE_MASK (0x01000000u)
#define CSL_LCDC_RASTER_TIMING_2_SYNC_EDGE_SHIFT (0x00000018u)
#define CSL_LCDC_RASTER_TIMING_2_SYNC_EDGE_RESETVAL (0x00000000u)
/*----SYNC_EDGE Tokens----*/
#define CSL_LCDC_RASTER_TIMING_2_SYNC_EDGE_RISING (0x00000000u)
#define CSL_LCDC_RASTER_TIMING_2_SYNC_EDGE_FALLING (0x00000001u)

#define CSL_LCDC_RASTER_TIMING_2_BIAS_MASK (0x00800000u)
#define CSL_LCDC_RASTER_TIMING_2_BIAS_SHIFT (0x00000017u)
#define CSL_LCDC_RASTER_TIMING_2_BIAS_RESETVAL (0x00000000u)
/*----BIAS Tokens----*/
#define CSL_LCDC_RASTER_TIMING_2_BIAS_ACTIVE_HIGH (0x00000000u)
#define CSL_LCDC_RASTER_TIMING_2_BIAS_ACTIVE_LOW (0x00000001u)

#define CSL_LCDC_RASTER_TIMING_2_IPC_MASK (0x00400000u)
#define CSL_LCDC_RASTER_TIMING_2_IPC_SHIFT (0x00000016u)
#define CSL_LCDC_RASTER_TIMING_2_IPC_RESETVAL (0x00000000u)
/*----IPC Tokens----*/
#define CSL_LCDC_RASTER_TIMING_2_IPC_RISING (0x00000000u)
#define CSL_LCDC_RASTER_TIMING_2_IPC_FALLING (0x00000001u)

#define CSL_LCDC_RASTER_TIMING_2_IHS_MASK (0x00200000u)
#define CSL_LCDC_RASTER_TIMING_2_IHS_SHIFT (0x00000015u)
#define CSL_LCDC_RASTER_TIMING_2_IHS_RESETVAL (0x00000000u)
/*----IHS Tokens----*/
#define CSL_LCDC_RASTER_TIMING_2_IHS_ACTIVE_HIGH (0x00000000u)
#define CSL_LCDC_RASTER_TIMING_2_IHS_ACTIVE_LOW (0x00000001u)

#define CSL_LCDC_RASTER_TIMING_2_IVS_MASK (0x00100000u)
#define CSL_LCDC_RASTER_TIMING_2_IVS_SHIFT (0x00000014u)
#define CSL_LCDC_RASTER_TIMING_2_IVS_RESETVAL (0x00000000u)
/*----IVS Tokens----*/
#define CSL_LCDC_RASTER_TIMING_2_IVS_ACTIVE_HIGH (0x00000000u)
#define CSL_LCDC_RASTER_TIMING_2_IVS_ACTIVE_LOW (0x00000001u)

#define CSL_LCDC_RASTER_TIMING_2_ACB_I_MASK (0x000F0000u)
#define CSL_LCDC_RASTER_TIMING_2_ACB_I_SHIFT (0x00000010u)
#define CSL_LCDC_RASTER_TIMING_2_ACB_I_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_TIMING_2_ACB_MASK (0x0000FF00u)
#define CSL_LCDC_RASTER_TIMING_2_ACB_SHIFT (0x00000008u)
#define CSL_LCDC_RASTER_TIMING_2_ACB_RESETVAL (0x00000000u)


#define CSL_LCDC_RASTER_TIMING_2_RESETVAL (0x00000000u)

/* RASTER_SUBPANEL */

#define CSL_LCDC_RASTER_SUBPANEL_SPEN_MASK (0x80000000u)
#define CSL_LCDC_RASTER_SUBPANEL_SPEN_SHIFT (0x0000001Fu)
#define CSL_LCDC_RASTER_SUBPANEL_SPEN_RESETVAL (0x00000000u)
/*----SPEN Tokens----*/
#define CSL_LCDC_RASTER_SUBPANEL_SPEN_DISABLE (0x00000000u)
#define CSL_LCDC_RASTER_SUBPANEL_SPEN_ENABLE (0x00000001u)


#define CSL_LCDC_RASTER_SUBPANEL_HOLS_MASK (0x20000000u)
#define CSL_LCDC_RASTER_SUBPANEL_HOLS_SHIFT (0x0000001Du)
#define CSL_LCDC_RASTER_SUBPANEL_HOLS_RESETVAL (0x00000000u)
/*----HOLS Tokens----*/
#define CSL_LCDC_RASTER_SUBPANEL_HOLS_LOW (0x00000000u)
#define CSL_LCDC_RASTER_SUBPANEL_HOLS_HIGH (0x00000001u)


#define CSL_LCDC_RASTER_SUBPANEL_LPPT_MASK (0x03FF0000u)
#define CSL_LCDC_RASTER_SUBPANEL_LPPT_SHIFT (0x00000010u)
#define CSL_LCDC_RASTER_SUBPANEL_LPPT_RESETVAL (0x00000000u)

#define CSL_LCDC_RASTER_SUBPANEL_DPD_MASK (0x0000FFF0u)
#define CSL_LCDC_RASTER_SUBPANEL_DPD_SHIFT (0x00000004u)
#define CSL_LCDC_RASTER_SUBPANEL_DPD_RESETVAL (0x00000000u)


#define CSL_LCDC_RASTER_SUBPANEL_RESETVAL (0x00000000u)

/* LCDDMA_CTRL */


#define CSL_LCDC_LCDDMA_CTRL_BURST_SIZE_MASK (0x00000070u)
#define CSL_LCDC_LCDDMA_CTRL_BURST_SIZE_SHIFT (0x00000004u)
#define CSL_LCDC_LCDDMA_CTRL_BURST_SIZE_RESETVAL (0x00000000u)
/*----BURST_SIZE Tokens----*/
#define CSL_LCDC_LCDDMA_CTRL_BURST_SIZE_ONE (0x00000000u)
#define CSL_LCDC_LCDDMA_CTRL_BURST_SIZE_TWO (0x00000001u)
#define CSL_LCDC_LCDDMA_CTRL_BURST_SIZE_FOUR (0x00000002u)
#define CSL_LCDC_LCDDMA_CTRL_BURST_SIZE_EIGHT (0x00000003u)
#define CSL_LCDC_LCDDMA_CTRL_BURST_SIZE_SIXTEEN (0x00000004u)


#define CSL_LCDC_LCDDMA_CTRL_EOF_INTEN_MASK (0x00000004u)
#define CSL_LCDC_LCDDMA_CTRL_EOF_INTEN_SHIFT (0x00000002u)
#define CSL_LCDC_LCDDMA_CTRL_EOF_INTEN_RESETVAL (0x00000000u)
/*----EOF_INTEN Tokens----*/
#define CSL_LCDC_LCDDMA_CTRL_EOF_INTEN_DISABLE (0x00000000u)
#define CSL_LCDC_LCDDMA_CTRL_EOF_INTEN_ENABLE (0x00000001u)

#define CSL_LCDC_LCDDMA_CTRL_BIGENDIAN_MASK (0x00000002u)
#define CSL_LCDC_LCDDMA_CTRL_BIGENDIAN_SHIFT (0x00000001u)
#define CSL_LCDC_LCDDMA_CTRL_BIGENDIAN_RESETVAL (0x00000000u)
/*----BIGENDIAN Tokens----*/
#define CSL_LCDC_LCDDMA_CTRL_BIGENDIAN_DISABLE (0x00000000u)
#define CSL_LCDC_LCDDMA_CTRL_BIGENDIAN_ENABLE (0x00000001u)

#define CSL_LCDC_LCDDMA_CTRL_FRAME_MODE_MASK (0x00000001u)
#define CSL_LCDC_LCDDMA_CTRL_FRAME_MODE_SHIFT (0x00000000u)
#define CSL_LCDC_LCDDMA_CTRL_FRAME_MODE_RESETVAL (0x00000000u)
/*----FRAME_MODE Tokens----*/
#define CSL_LCDC_LCDDMA_CTRL_FRAME_MODE_ONE_FB (0x00000000u)
#define CSL_LCDC_LCDDMA_CTRL_FRAME_MODE_TWO_FB (0x00000001u)

#define CSL_LCDC_LCDDMA_CTRL_RESETVAL (0x00000000u)

/* LCDDMA_FB0_BASE */

#define CSL_LCDC_LCDDMA_FB0_BASE_FB0_BASE_MASK (0xFFFFFFFFu)
#define CSL_LCDC_LCDDMA_FB0_BASE_FB0_BASE_SHIFT (0x00000000u)
#define CSL_LCDC_LCDDMA_FB0_BASE_FB0_BASE_RESETVAL (0x00000000u)

#define CSL_LCDC_LCDDMA_FB0_BASE_RESETVAL (0x00000000u)

/* LCDDMA_FB0_CEILING */

#define CSL_LCDC_LCDDMA_FB0_CEILING_FB0_CEIL_MASK (0xFFFFFFFFu)
#define CSL_LCDC_LCDDMA_FB0_CEILING_FB0_CEIL_SHIFT (0x00000000u)
#define CSL_LCDC_LCDDMA_FB0_CEILING_FB0_CEIL_RESETVAL (0x00000000u)

#define CSL_LCDC_LCDDMA_FB0_CEILING_RESETVAL (0x00000000u)

/* LCDDMA_FB1_BASE */

#define CSL_LCDC_LCDDMA_FB1_BASE_FB1_BASE_MASK (0xFFFFFFFFu)
#define CSL_LCDC_LCDDMA_FB1_BASE_FB1_BASE_SHIFT (0x00000000u)
#define CSL_LCDC_LCDDMA_FB1_BASE_FB1_BASE_RESETVAL (0x00000000u)

#define CSL_LCDC_LCDDMA_FB1_BASE_RESETVAL (0x00000000u)

/* LCDDMA_FB1_CEILING */

#define CSL_LCDC_LCDDMA_FB1_CEILING_FB1_CEIL_MASK (0xFFFFFFFFu)
#define CSL_LCDC_LCDDMA_FB1_CEILING_FB1_CEIL_SHIFT (0x00000000u)
#define CSL_LCDC_LCDDMA_FB1_CEILING_FB1_CEIL_RESETVAL (0x00000000u)

#define CSL_LCDC_LCDDMA_FB1_CEILING_RESETVAL (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif
