/*
 *  ======== main.c ========
 */

#include <string.h>

#include <xdc/std.h>
#include <xdc/cfg/global.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>

#include <ti/ipc/Ipc.h>
#include <ti/ipc/MessageQ.h>
#include <ti/ipc/HeapBufMP.h>
#include <ti/ipc/MultiProc.h>
#include <ti/ipc/SharedRegion.h>

#include "msgq.h"
/*
 *  ======== main ========
 */
#define HEAP_IPC_ID 0
void Init()
{
	int status = -20;
	status = Ipc_start();
	if (status < 0)
	{
//		System_abort("Ipc_start failed\n");
		System_printf("Ipc_start failed\n");
	}
	/* Register this heap with MessageQ */
	MessageQ_registerHeap((IHeap_Handle)SharedRegion_getHeap(0), HEAP_IPC_ID);
}
Void main()
{ 
    /*
     * use ROV->SysMin to view the characters in the circular buffer
     */
	//    System_printf("enter main()\n");
//		ULONGLONG ullCount;
	unsigned int i;

	Task_Params taskParams[6];
	Task_Handle taskHandle[6];
	Sem_create_1();
	Init();
	for(i = 0; i < 6; i++)
	{
		Task_Params_init(&taskParams[i]);
	}
	taskParams[0].priority = 15;
	taskParams[1].priority = 8;
	taskParams[2].priority = 8;
	taskParams[3].priority = 6;
	taskParams[4].priority = 6;
	taskParams[5].priority = 14;
	task_create();
	if(MultiProc_self() == 0)
	{
		taskHandle[0] = Task_create(timer_create, &taskParams[0], NULL);
		taskHandle[1] = Task_create(task_malloc_syn, &taskParams[1], NULL);
		if(taskHandle[0]&&taskHandle[1])
		{
			System_printf("task0-1 create success.\n");
		}
		else
		{
			System_printf("some of task0-1 create failed.\n");
		}
	}
	taskHandle[2] = Task_create(task_pend_Syn, &taskParams[2], NULL);
	taskHandle[3] = Task_create(task_malloc_Nor, &taskParams[3], NULL);
	taskHandle[4] = Task_create(task_pend_Nor, &taskParams[4], NULL);
//	taskHandle[5] = Task_create(task_create, &taskParams[5], NULL);
	if(taskHandle[2]&&taskHandle[3]&&taskHandle[4])
	{
		System_printf("task2-5 create success.\n");
	}
	else
	{
		System_printf("some of task2-5 create failed.\n");
	}
	BIOS_start();   /* enable interrupts and start SYS/BIOS */
}
