#include <xdc/runtime/System.h>
#include <ti/ipc/MultiProc.h>
#include <ti/sysbios/BIOS.h>
#include <string.h>
#include "msgq.h"
char t_cName[2][32];
unsigned int interruptNUM;
static MessageQ_Handle MsgHandle[2];
static Semaphore_Handle Synch_SemHandle;
static Semaphore_Handle Start_SemHandle;
#define HEAP_IPC_ID 0
typedef struct
{
	unsigned int TCore;
	unsigned int FCore;
}Struct_Msg;
void timer_Hwi()
{
	Semaphore_post(Synch_SemHandle);
	interruptNUM++;
}
void timer_create()
{
	Timer_Handle timeHandle;
	Timer_Params timerParams;
	Timer_Params_init(&timerParams);
	timerParams.period = 20000;//Ϊ40ms
	timeHandle = Timer_create(Timer_ANY, (Timer_FuncPtr)timer_Hwi, &timerParams, NULL);
	Timer_start(timeHandle);
}
void task_create()
{
	System_sprintf(t_cName[0], "core %u to Nor", MultiProc_self());
	MsgHandle[0] = MessageQ_create(t_cName[0], NULL);
	System_sprintf(t_cName[1], "core %u to Syn", MultiProc_self());
	MsgHandle[1] = MessageQ_create(t_cName[1], NULL);
	System_printf("create success.\n");
}

void task_malloc_syn()
{
	char Name[4][32];
	MessageQ_QueueId queueId[4];
	char *t_pInfo = NULL;
	unsigned int i;
	char startMsg[4][10];
	int t_iStatus = 100;
	for(i = 0 ; i < 4; i++)
	{
		System_sprintf(startMsg[i], "core %u go", i);
	}
	for(i = 0; i < 4; i++)
	{
		System_sprintf(Name[i], "core %u to Syn", i);
		do
		{
			t_iStatus = MessageQ_open (Name[i], &queueId[i]);
		}while(t_iStatus < 0);
	}
	System_printf("task_malloc_synopen success.\n");
	while(1)
	{
		Semaphore_pend(Synch_SemHandle, BIOS_WAIT_FOREVER);
		System_printf("%u\n\n", interruptNUM);
		for(i = 0; i < 4; i++)
		{/*allocĿռСheader+32+Ϣȣ32cacheline64ֽڶá*/
			t_pInfo = (char *)MessageQ_alloc(HEAP_IPC_ID, (sizeof(startMsg[i]) + sizeof(MessageQ_MsgHeader)+32));
			if(NULL == t_pInfo)
			{
				System_printf("MessageQ_alloc failed !");
			}
			else
			{
				memcpy((t_pInfo + sizeof(MessageQ_MsgHeader)+32), startMsg[i], sizeof(startMsg));
				t_iStatus = MessageQ_put(queueId[i], (MessageQ_Msg)t_pInfo);
				if(t_iStatus < 0)
				{
					System_printf("postMessage has a invalid MessageQ_put status !");
				}
				else
				{
//					System_printf("task_malloc_syn: StartMsg to %u go.\n", i);
				}
			}
		}
	}
}

void task_pend_Syn()
{
	char startMsg[100];
	int t_iStatus = 100;
	unsigned int t_uiMsgSize = 0;
	char pucMessage[100];
	char *t_pcMsg;
	System_sprintf(startMsg, "core %u go", MultiProc_self());
//	System_sprintf(t_cName[1], "core %u to Syn", MultiProc_self());
//	MsgHandle[1] = MessageQ_create(t_cName[1], NULL);
//	System_printf("create success.\n");
	while(1)
	{
		t_iStatus = MessageQ_get(MsgHandle[1], (MessageQ_Msg*)&t_pcMsg, BIOS_WAIT_FOREVER);
		if(t_iStatus != 0)
			System_printf("task_pend_Syn: Get failed.\n");
		t_uiMsgSize = ((MessageQ_Msg)t_pcMsg)->msgSize - sizeof(MessageQ_MsgHeader)-32;
		memcpy(pucMessage, (t_pcMsg+sizeof(MessageQ_MsgHeader)+32), t_uiMsgSize);
		if(memcmp(pucMessage, startMsg, t_uiMsgSize))
		{
			System_printf("task_pend_Syn: start msg wrong.\n");
		}
		else
		{
			Semaphore_post(Start_SemHandle);
		}
		t_iStatus = MessageQ_free((MessageQ_Msg)t_pcMsg);
		if (t_iStatus < 0)
		{
			System_printf("FreeMsgQ is error !");
		}
	}

}
void task_malloc_Nor()
{
	char Name[4][32];
	MessageQ_QueueId queueId[4];
	char *t_pInfo[4];
	Struct_Msg NorMsg[4];
	int t_iStatus = 100;
	unsigned int i;
	for(i = 0; i < 4; i++)
	{
		NorMsg[i].FCore = MultiProc_self();
		NorMsg[i].TCore = i;
		System_sprintf(Name[i], "core %u to Nor", i);
		do
		{
			t_iStatus = MessageQ_open (Name[i], &queueId[i]);
		}while(t_iStatus < 0);
	}
	System_printf("task_malloc_Noropen success.\n");
	while(1)
	{
		Semaphore_pend(Start_SemHandle, BIOS_WAIT_FOREVER);
		for(i = 0; i < 4; i++)
		{
			t_pInfo[i] = (char *)MessageQ_alloc(HEAP_IPC_ID, (sizeof(NorMsg[i]) + sizeof(MessageQ_MsgHeader)+32));
			if(NULL == t_pInfo[i])
			{
				System_printf("MessageQ_alloc failed !");
			}
			memcpy((t_pInfo[i] + sizeof(MessageQ_MsgHeader)+32), (void*)(&NorMsg[i]), sizeof(NorMsg[0]));
			t_iStatus = MessageQ_put(queueId[i], (MessageQ_Msg)t_pInfo[i]);
			if(t_iStatus < 0)
			{
				System_printf("postMessage has a invalid MessageQ_put status !");
			}
		}
	}
}

void task_pend_Nor()
{
	int t_iStatus = 100;
	unsigned int t_uiMsgSize = 0;
	char *t_pcMsg;
	char pucMessage[100];
//	System_sprintf(t_cName[0], "core %u to Nor", MultiProc_self());
//	MsgHandle[0] = MessageQ_create(t_cName[0], NULL);
//	System_printf("create success.\n");
	while(1)
	{
		t_iStatus = MessageQ_get(MsgHandle[0], (MessageQ_Msg*)&t_pcMsg, BIOS_WAIT_FOREVER);
		if(t_iStatus != 0)
			System_printf("task_pend_Syn: Get failed.\n");
		t_uiMsgSize = ((MessageQ_Msg)t_pcMsg)->msgSize - sizeof(MessageQ_MsgHeader)-32;
		memcpy(pucMessage, (t_pcMsg+sizeof(MessageQ_MsgHeader)+32), t_uiMsgSize);
		t_iStatus = MessageQ_free((MessageQ_Msg)t_pcMsg);
		if (t_iStatus < 0)
		{
			System_printf("FreeMsgQ is error !");
		}
		if(((Struct_Msg*)pucMessage)->TCore != MultiProc_self())
		{
			System_printf("task_pend_Nor: Msg is wrong.\n");
		}
		else
		{
			System_printf("%u to %u.\n", ((Struct_Msg*)pucMessage)->FCore, ((Struct_Msg*)pucMessage)->TCore);
		}
	}
}
void Sem_create_1()
{
	Start_SemHandle = Semaphore_create(0, NULL, NULL);
	Synch_SemHandle = Semaphore_create(0, NULL, NULL);
}
