/*
 *  ======== main.c ========
 */

#include <string.h>

#include <xdc/std.h>
#include <xdc/cfg/global.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>

#include <ti/ipc/Ipc.h>
#include <ti/ipc/MessageQ.h>
#include <ti/ipc/HeapBufMP.h>
#include <ti/ipc/MultiProc.h>
#include <ti/ipc/SharedRegion.h>

#include "dp_basic_type.h"
#include "DP_Start.h"
#include "dp.h"

#include "dp_exception.h"
#include "dp_timer_Test.h"
/*
 *  ======== main ========
 */

Void main()
{
    /*
     * use ROV->SysMin to view the characters in the circular buffer
     */
//    System_printf("enter main()\n");
	UCHAR taskName[5][20] = {
			"task0", "task1", "task2", "task3", "task4"
	};
	ULONGLONG ullCount;
	DP_init(DP_DSP_0, 102400, 0x3);
	ullCount = DP_getSystemTime();
	System_printf("The system run time is %x.\n", ullCount);
//	DP_createTask(14, 2048, taskName[0], (DP_Function)Task_TimerCreateANDStart_test);
//	DP_createTask(14, 2048, taskName[1], (DP_Function)Task_TimerCreateANDDelete_test);
//	DP_createTask(14, 2048, taskName[2], (DP_Function)Task_TimerCreateANDStop_test);
	DP_createTask(14, 2048, taskName[3], (DP_Function)Task_TimerCreateANDGetCount_test);
	ullCount = DP_getSystemTime();
	System_printf("The system run time is %x.\n", ullCount);
	DP_start();

//    BIOS_start();        /* enable interrupts and start SYS/BIOS */
}
